/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.comparator.IComparable;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.IDefiner;
import com.oceanbase.obtools.dbdiff.model.base.IGrammar;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractIndex
extends AbstractOwnership
implements IDefiner,
IGrammar,
IComparable<AbstractIndex> {
    private final Map<String, String> collationMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 3188302206792580519L;
        {
            this.put("A", " ASC");
            this.put("D", " DESC");
            this.put("ASC", " ASC");
            this.put("DESC", " DESC");
            this.put("R", " RANDOM");
        }
    };
    private final Map<String, String> uniqueRuleMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 3188302206792580519L;
        {
            this.put("U", " UNIQUE");
            this.put("UNIQUE", " UNIQUE");
            this.put("V", " UNIQUE WHERE NOT NULL");
            this.put("E", " ENCODED VECTOR");
        }
    };
    private final Map<String, String> indexTypeMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = -1637246424096953846L;
        {
            this.put("HASH", " USING HASH");
            this.put("BTREE", " USING BTREE");
            this.put("NORMAL", " USING HASH");
            this.put("FUNCTION-BASED NORMAL", " USING HASH");
            this.put("BITMAP", " USING HASH");
            this.put("HEAP", "USING HEAP");
            this.put("GIST", "USING GIST");
            this.put("GIN", "USING GIN");
            this.put("SPGIST", "USING SPGIST");
            this.put("BRIN", "USING BRIN");
        }
    };
    private final List<KeyColumn> indexColumns = new ArrayList<KeyColumn>();
    private String indexSchema;
    private String indexName;
    private String indexType;
    private String comment;

    public AbstractIndex(AbstractSchema schema) {
        super(schema);
    }

    public String getWrappedIndexName() {
        return this.wrap(this.getIndexName());
    }

    public String getSchemaIndexName() {
        StringBuilder sb = new StringBuilder();
        if (super.getGlobal().withSchema()) {
            sb.append(this.wrapAndCase(this.getSchemaName(), "schemaCase")).append(".");
        }
        return sb.append(this.getWrappedIndexName()).toString();
    }

    public String getSimpleIndexName() {
        if (super.getGlobal().withSchema()) {
            return this.getIndexName();
        }
        return this.getSchemaName() + "." + this.getIndexName();
    }

    public StringBuilder joinIndexColumns() {
        return this.enclose(this.getIndexColumns().stream().map(e -> {
            String columnOrder;
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            String subPart = e.getSubPart();
            if (!"SPATIAL".equals(this.getIndexType()) && StringUtils.isNotBlank((CharSequence)subPart)) {
                columnName = columnName + "(" + subPart + ")";
            }
            if (StringUtils.isNotBlank((CharSequence)(columnOrder = this.getCollationMapping().get(e.getColumnOrder())))) {
                columnName = columnName + columnOrder;
            }
            return columnName;
        }).collect(Collectors.joining(", ")));
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP INDEX ").append(this.getSchemaIndexName());
        return new DropObjectDefine(ObjectType.INDEX, this.getSimpleObjectName(), this.terminate(sb));
    }

    public ObjectDefine buildRenameDefinition(String dstIndexName) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER INDEX ").append(this.getSchemaIndexName());
        sb.append(" RENAME TO ").append(this.wrap(dstIndexName));
        return new DropObjectDefine(ObjectType.INDEX, this.getSimpleObjectName(), sb.toString());
    }

    protected void addUniqueAttribute() {
        String indexType = this.getIndexType();
        if (indexType == null) {
            this.setIndexType("UNIQUE");
        } else if (indexType.contains("UNIQUE")) {
            this.setIndexType(indexType);
        } else {
            this.setIndexType(indexType + " " + "UNIQUE");
        }
    }

    @Override
    public String getDefinitionSchemaObjectName() {
        StringBuilder sb = new StringBuilder();
        if (this.getGlobal().withSchema()) {
            sb.append(this.wrapAndEscape(this.getDefinitionSchemaName())).append(".");
        }
        String table = this.getGlobal().getTableCase().apply(this.getObjectName());
        return sb.append(this.wrapAndEscape(table)).toString();
    }

    public Map<String, String> getCollationMapping() {
        return this.collationMapping;
    }

    public Map<String, String> getUniqueRuleMapping() {
        return this.uniqueRuleMapping;
    }

    public Map<String, String> getIndexTypeMapping() {
        return this.indexTypeMapping;
    }

    public List<KeyColumn> getIndexColumns() {
        return this.indexColumns;
    }

    public String getIndexSchema() {
        return this.indexSchema;
    }

    public void setIndexSchema(String indexSchema) {
        this.indexSchema = indexSchema;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

