/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public abstract class AbstractOwnership {
    public static final String EMPTY_STRING = "";
    public static final String BLANK_STRING = " ";
    public static final String BACK_QUOTE_ESCAPE = "`";
    public static final String DOUBLE_QUOTE_ESCAPE = "\"";
    public static final String SINGLE_QUOTE = "'";
    private final AbstractSchema schema;
    private String objectName;

    public AbstractOwnership(AbstractSchema schema) {
        this.schema = schema;
    }

    public Global getGlobal() {
        return this.schema.getGlobal();
    }

    public DbType getDbType() {
        return this.schema.getDbType();
    }

    public String getCatalogName() {
        return this.schema.getCatalogName();
    }

    public String getSchemaName() {
        return this.schema.getSchemaName();
    }

    public String getDefinitionSchemaName() {
        return this.schema.getDefinitionSchemaName();
    }

    public DbType getOriginDbType() {
        return this.schema.getOriginDbType();
    }

    public String getOriginSchemaName() {
        return this.schema.getOriginSchemaName();
    }

    public String getSchemaObjectName() {
        StringBuilder sb = new StringBuilder();
        if (this.getGlobal().withSchema()) {
            sb.append(this.wrapAndEscape(this.getSchemaName())).append(".");
        }
        return sb.append(this.wrapAndEscape(this.getObjectName())).toString();
    }

    public String getOriginSchemaObjectName() {
        StringBuilder sb = new StringBuilder();
        if (this.getGlobal().withSchema()) {
            sb.append(this.wrapAndEscape(this.getOriginSchemaName())).append(".");
        }
        return sb.append(this.wrapAndEscape(this.getObjectName())).toString();
    }

    public String getSimpleObjectName() {
        StringBuilder sb = new StringBuilder(64);
        if (this.getGlobal().withSchema()) {
            sb.append(this.getSchemaName()).append(".");
        }
        return sb.append(this.getObjectName()).toString();
    }

    public String getOriginSimpleObjectName() {
        StringBuilder sb = new StringBuilder(64);
        if (this.getGlobal().withSchema()) {
            sb.append(this.getOriginSchemaName()).append(".");
        }
        return sb.append(this.getObjectName()).toString();
    }

    public String getDefinitionSchemaObjectName() {
        return this.getSchemaObjectName();
    }

    public String wrap(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name is null");
        }
        if (this.getGlobal().withQuota() && !Pattern.matches(this.getRegPattern(), name)) {
            return this.getQuotaCharacter() + name + this.getQuotaCharacter();
        }
        return name;
    }

    public String wrapAndCase(String name, String caseName) {
        name = this.wrap(this.caseName(name, caseName));
        return name;
    }

    public String caseName(String name, String caseName) {
        if (name == null) {
            throw new IllegalArgumentException("The name is null");
        }
        if ("schemaCase".equals(caseName)) {
            name = this.getGlobal().getSchemaCase().apply(name);
        }
        if ("tableCase".equals(caseName)) {
            name = this.getGlobal().getTableCase().apply(name);
        }
        if ("columnCase".equals(caseName)) {
            name = this.getGlobal().getColumnCase().apply(name);
        }
        return name;
    }

    public String wrapAndEscape(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name is null");
        }
        name = name.trim();
        if (this.getGlobal().withQuota()) {
            name = name.replace(this.getQuotaCharacter(), this.getQuotaCharacter() + this.getQuotaCharacter());
            return this.getQuotaCharacter() + name + this.getQuotaCharacter();
        }
        return name;
    }

    public void reverseMetadata(AbstractOwnership targetOwnership) {
        if (targetOwnership == null) {
            return;
        }
        AbstractSchema sourceSchema = this.getSchema();
        if (sourceSchema == null) {
            return;
        }
        AbstractSchema targetSchema = targetOwnership.getSchema();
        if (targetSchema == null) {
            return;
        }
        targetSchema.setOriginDbType(sourceSchema.getDbType());
        sourceSchema.setDbType(targetSchema.getDbType());
        sourceSchema.setSchemaName(targetSchema.getSchemaName());
    }

    @Deprecated
    public String rewritePlSql(CharSequence ch, Predicate<String> predicate) {
        String name = null;
        String sql = String.valueOf(ch);
        StringTokenizer st = new StringTokenizer(sql);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!predicate.test(token) || !st.hasMoreTokens()) continue;
            name = st.nextToken();
            break;
        }
        st = null;
        if (name == null) {
            return sql;
        }
        int index = sql.indexOf(name);
        StringBuilder sb = new StringBuilder();
        sb.append(sql.substring(0, index));
        sb.append(this.getSchemaObjectName());
        sb.append(sql.substring(index + name.length()));
        return sb.toString().trim();
    }

    public String getQuotaCharacter() {
        return DOUBLE_QUOTE_ESCAPE;
    }

    public StringBuilder enclose(Object part) {
        return new StringBuilder(" (").append(String.valueOf(part).trim()).append(")");
    }

    public String safetyMapping(Map<String, String> map, String key) {
        if (map == null || key == null) {
            return EMPTY_STRING;
        }
        String val = map.get(key);
        return val == null ? EMPTY_STRING : val;
    }

    public String getRegPattern() {
        String escapeStr = this.getQuotaCharacter();
        StringBuilder sb = new StringBuilder("^");
        sb.append(escapeStr).append("[\\w+\\W+]+").append(escapeStr);
        return sb.append("$").toString();
    }

    public int hashCode() {
        return Objects.hash(this.schema);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractOwnership)) {
            return false;
        }
        AbstractOwnership other = (AbstractOwnership)obj;
        return Objects.equals(this.schema, other.schema);
    }

    public AbstractSchema getSchema() {
        return this.schema;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }
}

