/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model;

import com.oceanbase.obtools.dbdiff.comparator.IComparable;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.IDefiner;
import com.oceanbase.obtools.dbdiff.resolver.DdlMetaResolveAble;

public abstract class AbstractTable
extends AbstractOwnership
implements IDefiner,
IComparable<AbstractTable>,
DdlMetaResolveAble {
    private String tableType;
    private String tableComment;
    private String extra;

    public AbstractTable(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE ").append(this.getSchemaObjectName());
        return new DropObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb));
    }

    @Override
    public String getDefinitionSchemaObjectName() {
        StringBuilder sb = new StringBuilder();
        if (this.getGlobal().withSchema()) {
            sb.append(this.wrapAndEscape(this.getDefinitionSchemaName())).append(".");
        }
        String table = this.getGlobal().getTableCase().apply(this.getObjectName());
        return sb.append(this.wrapAndEscape(table)).toString();
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

