/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.comparator.IComparable;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.IDefiner;
import com.oceanbase.obtools.dbdiff.model.base.IDelimiter;
import java.util.List;

public abstract class AbstractTrigger
extends AbstractOwnership
implements IDefiner,
IDelimiter,
IComparable<AbstractTrigger> {
    private boolean fullText;
    private String text;
    private String status;

    public AbstractTrigger(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (!this.isFullText()) {
            sb.append("CREATE OR REPLACE ");
        }
        sb.append(this.getText());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TRIGGER ").append(this.getSchemaObjectName());
        return new DropObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), this.terminate(sb));
    }

    public boolean isFullText() {
        return this.fullText;
    }

    public void setFullText(boolean fullText) {
        this.fullText = fullText;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

