/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model;

import com.oceanbase.obtools.dbdiff.comparator.IComparable;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.IDefiner;
import com.oceanbase.obtools.dbdiff.utils.TextUtils;

public abstract class AbstractView
extends AbstractOwnership
implements IDefiner,
IComparable<AbstractView> {
    private String text;
    private String readOnly;
    private boolean fullText;

    public AbstractView(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP VIEW ").append(this.getSchemaObjectName());
        return new DropObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(sb));
    }

    public String getText() {
        return TextUtils.replace(this.text, this.getQuotaCharacter() + this.getOriginSchemaName() + this.getQuotaCharacter(), this.getQuotaCharacter() + this.getSchemaName() + this.getQuotaCharacter());
    }

    @Override
    public String getDefinitionSchemaObjectName() {
        StringBuilder sb = new StringBuilder();
        if (this.getGlobal().withSchema()) {
            sb.append(this.wrapAndEscape(this.getDefinitionSchemaName())).append(".");
        }
        String table = this.getGlobal().getTableCase().apply(this.getObjectName());
        return sb.append(this.wrapAndEscape(table)).toString();
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(String readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isFullText() {
        return this.fullText;
    }

    public void setFullText(boolean fullText) {
        this.fullText = fullText;
    }
}

