/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.adbmysql;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlConstraint;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

public class AdbMySqlCheck
extends AbstractMySqlConstraint {
    private String checkClause;

    public AdbMySqlCheck(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("constraint `").append(this.getConstraintName()).append("`");
        ChangeUtils.warn(ObjectType.TABLE, this.getSimpleObjectName(), ChangeInfo.ChangeType.CONVERT, "Check constraint is invalid in AnalyticDB MySQL.");
        return sb.append(" check (").append(this.getCheckClause()).append(")");
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof AdbMySqlCheck)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getCheckClause() {
        return this.checkClause;
    }

    public void setCheckClause(String checkClause) {
        this.checkClause = checkClause;
    }
}

