/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.adbmysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlSchema;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlConstraint;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

public class AdbMySqlForeignKey
extends AbstractMySqlConstraint {
    public AdbMySqlForeignKey(AdbMySqlSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        ChangeUtils.warn(ObjectType.TABLE, this.getSimpleObjectName(), ChangeInfo.ChangeType.DISCARD, "Foreign key is invalid in AnalyticDB MySQL.");
        StringBuilder sb = new StringBuilder(256);
        sb.append("constraint ").append(this.wrap(this.getConstraintName()));
        sb.append(" foreign key").append((CharSequence)this.joinForeignConstraintColumns());
        sb.append(" references ").append(this.getRefOwnerTableName());
        sb.append((CharSequence)this.joinRefConstraintColumns());
        String matchOption = this.getMatchOption();
        if (StringUtils.isNotBlank((CharSequence)matchOption) && !"NONE".equals(matchOption)) {
            sb.append(" match ").append(matchOption);
        }
        sb.append(this.safetyMapping(DELETE_RULE_MAPPING, this.getDeleteRule()));
        return sb.append(this.safetyMapping(UPDATE_RULE_MAPPING, this.getUpdateRule()));
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof AdbMySqlForeignKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

