/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.adbmysql;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlSchema;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlIndex;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;
import java.util.stream.Collectors;

public class AdbMySqlIndex
extends AbstractMySqlIndex {
    public AdbMySqlIndex(AdbMySqlSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (this.getIndexColumns().size() > 1) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "MULTIPLE-COLUMNS INDEX " + this.joinIndexColumns() + " -> [NULL]");
            return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), sb.toString())});
        }
        String indexType = this.getIndexType();
        if ("UNIQUE".equals(indexType)) {
            sb.append("unique ");
        } else if ("GLOBAL".equals(indexType)) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "GLOBAL INDEX -> [NULL]");
        } else if ("LOCAL".equals(indexType)) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "LOCAL INDEX -> [NULL]");
        } else if ("GLOBAL UNIQUE".equals(indexType)) {
            sb.append("unique ");
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "GLOBAL INDEX -> [NULL]");
        } else if ("LOCAL UNIQUE".equals(indexType)) {
            sb.append("unique ");
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "LOCAL INDEX -> [NULL]");
        } else if ("FULLTEXT".equals(indexType)) {
            if (!DbType.OBMYSQL_2230.isSubsequent(this.getDbType())) {
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "The FULLTEXT index is disabled v2.2.40+ by default", "alter system set _ENABLE_FULLTEXT_INDEX=true;");
            }
            sb.append(" ").append("FULLTEXT");
        }
        sb.append("index ").append((CharSequence)this.joinIndexColumns());
        ChangeUtils.warn(ObjectType.INDEX, this.getSimpleObjectName(), ChangeInfo.ChangeType.DISCARD, "INDEX ALL is supported in AnalyticDB MySQL");
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), sb.toString())});
    }

    @Override
    public StringBuilder joinIndexColumns() {
        return this.enclose(this.getIndexColumns().stream().map(e -> {
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            String subPart = e.getSubPart();
            if (!"SPATIAL".equals(this.getIndexType()) && StringUtils.isNotBlank((CharSequence)subPart)) {
                columnName = columnName + "(" + subPart + ")";
            }
            return columnName;
        }).collect(Collectors.joining(", ")));
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof AdbMySqlIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

