/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.adbmysql;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.AbstractTableOption;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlCheck;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlColumn;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlForeignKey;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlIndex;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlSchema;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlTableOption;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlUniqueKey;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlConstraint;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTable;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AdbMySqlTable
extends AbstractMySqlTable {
    private AdbMySqlPrimaryKey primaryKey;
    private final Map<String, AdbMySqlColumn> columnMapping = new LinkedHashMap<String, AdbMySqlColumn>();
    private final Map<String, AdbMySqlIndex> indexMapping = new LinkedHashMap<String, AdbMySqlIndex>();
    private final Map<String, AdbMySqlCheck> checkMapping = new LinkedHashMap<String, AdbMySqlCheck>();
    private final Map<String, AdbMySqlUniqueKey> uniqueMapping = new LinkedHashMap<String, AdbMySqlUniqueKey>();
    private final Map<String, AdbMySqlForeignKey> foreignMapping = new LinkedHashMap<String, AdbMySqlForeignKey>();

    public AdbMySqlTable(AdbMySqlSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        Iterator<AbstractMySqlConstraint> option;
        String clusteredKeyGrammar;
        AbstractTableOption tableOption;
        this.primaryKey = this.findAnUniqueAsPrimaryKey();
        StringBuilder sb = new StringBuilder();
        String objectName = super.getGlobal().rename(ObjectType.TABLE, this);
        sb.append("CREATE TABLE ").append(objectName).append("(");
        Collection<AdbMySqlColumn> columns = this.getColumnMapping().values();
        Iterator<AbstractOwnership> iter = columns.iterator();
        while (iter.hasNext()) {
            String characterSetName;
            AdbMySqlColumn column = iter.next();
            String tableCollation = this.getTableCollation();
            if (tableCollation != null && tableCollation.equals(column.getCollationName())) {
                column.setCollationName(null);
            }
            if ((characterSetName = this.getCharacterSetName()) != null && characterSetName.equals(column.getCharacterSetName())) {
                column.setCharacterSetName(null);
            }
            sb.append("\n\t").append((CharSequence)column.buildGrammar());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            for (AdbMySqlIndex index : this.getIndexMapping().values()) {
                Iterator<ObjectDefine> iter2 = index.buildDefinition().iterator();
                while (iter2.hasNext()) {
                    String indexGrammar = iter2.next().getObjectGrammar();
                    if (!StringUtils.isNotBlank((CharSequence)indexGrammar)) continue;
                    ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, indexGrammar + " -> [NULL]");
                }
            }
        }
        if (this.getPrimaryKey() != null) {
            sb.append(",\n\t").append((CharSequence)this.getPrimaryKey().buildGrammar());
        }
        if ((tableOption = super.getGlobal().getTableOption()) != null && tableOption instanceof AdbMySqlTableOption && StringUtils.isNotBlank((CharSequence)(clusteredKeyGrammar = ((AdbMySqlTableOption)((Object)(option = (AdbMySqlTableOption)tableOption))).getClusteredKeyGrammar(this.getObjectName())))) {
            sb.append(",\n\t").append(clusteredKeyGrammar);
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (AdbMySqlCheck check : this.getCheckMapping().values()) {
                sb.append(",\n\t").append((CharSequence)check.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (AdbMySqlUniqueKey unique : this.getUniqueMapping().values()) {
                String uniqueGrammar = unique.buildGrammar().toString();
                if (!StringUtils.isNotBlank((CharSequence)uniqueGrammar)) continue;
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, uniqueGrammar + " -> [NULL]");
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (AdbMySqlForeignKey foreign : this.getForeignMapping().values()) {
                ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, foreign.buildGrammar() + " -> [NULL]");
            }
        }
        sb.append("\n").append(")");
        sb.append((CharSequence)this.appendTableOptions());
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb));
        objectDefine.getChangeInfos().addAll(ChangeUtils.findByKey(ObjectType.TABLE, this.getSchemaObjectName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    @Override
    protected StringBuilder appendTableOptions() throws UnsupportedGrammarException {
        StringBuilder sb = super.appendTableOptions();
        AbstractTableOption tableOption = super.getGlobal().getTableOption();
        if (tableOption == null) {
            return sb;
        }
        String optionGrammar = tableOption.getOptionGrammar(this.getObjectName());
        if (StringUtils.isNotBlank((CharSequence)optionGrammar)) {
            sb.append(optionGrammar);
        }
        return sb;
    }

    private AdbMySqlPrimaryKey findAnUniqueAsPrimaryKey() {
        if (this.primaryKey != null) {
            return this.primaryKey;
        }
        Collection<AdbMySqlUniqueKey> uks = this.uniqueMapping.values();
        if (CollectionUtils.isNotEmpty(uks)) {
            Iterator<AdbMySqlUniqueKey> iterator = uks.iterator();
            AdbMySqlUniqueKey uk = iterator.next();
            iterator.remove();
            AdbMySqlPrimaryKey pk = new AdbMySqlPrimaryKey((AdbMySqlSchema)uk.getSchema());
            pk.setObjectName(uk.getObjectName());
            pk.setComment(uk.getComment());
            pk.setIndexName(uk.getIndexName());
            pk.setConstraintName(uk.getConstraintName());
            pk.getConstraintColumns().addAll(uk.getConstraintColumns());
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "CONSTRAINT " + this.wrapAndEscape(uk.getConstraintName()) + " UNIQUE" + uk.joinConstraintColumns() + " ->  PRIMARY KEY" + pk.joinConstraintColumns());
            return pk;
        }
        return null;
    }

    @Override
    public String getTableCollation() {
        return "";
    }

    @Override
    public String getCharacterSetName() {
        return "";
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof AdbMySqlTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public AdbMySqlPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(AdbMySqlPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Map<String, AdbMySqlColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, AdbMySqlIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, AdbMySqlCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public Map<String, AdbMySqlUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, AdbMySqlForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }
}

