/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.adbmysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.model.AbstractTableOption;
import java.util.HashMap;
import java.util.Map;

public class AdbMySqlTableOption
implements AbstractTableOption {
    private final Map<String, String> clusteredKeyMap = new HashMap<String, String>();
    private final Map<String, String> storagePolicyMap = new HashMap<String, String>();
    private final Map<String, String> tableAttributeMap = new HashMap<String, String>();
    private final Map<String, String> partitionOptionsMap = new HashMap<String, String>();

    public AdbMySqlTableOption setTableAttribute(String tableName, String tableAttributeGrammar) {
        this.tableAttributeMap.put(tableName, tableAttributeGrammar);
        return this;
    }

    public String getTableAttributeGrammar(String tableName) {
        String tableAttrGrammar = this.tableAttributeMap.get(tableName);
        return tableAttrGrammar == null ? "" : tableAttrGrammar;
    }

    public AdbMySqlTableOption setPartitionOptions(String tableName, String partitionOptionsGrammar) {
        this.partitionOptionsMap.put(tableName, partitionOptionsGrammar);
        return this;
    }

    public String getPartitionOptionsGrammar(String tableName) {
        String partitionOptionsGrammar = this.partitionOptionsMap.get(tableName);
        return partitionOptionsGrammar == null ? "" : partitionOptionsGrammar;
    }

    public AdbMySqlTableOption setStoragePolicy(String tableName, String storagePolicyGrammar) {
        this.storagePolicyMap.put(tableName, storagePolicyGrammar);
        return this;
    }

    public String getStoragePolicyGrammar(String tableName) {
        String storagePolicyGrammar = this.storagePolicyMap.get(tableName);
        return storagePolicyGrammar == null ? "" : storagePolicyGrammar;
    }

    public AdbMySqlTableOption setClusteredKey(String tableName, String clusteredKeyGrammar) {
        this.clusteredKeyMap.put(tableName, clusteredKeyGrammar);
        return this;
    }

    public String getClusteredKeyGrammar(String tableName) {
        String clusteredKeyGrammar = this.clusteredKeyMap.get(tableName);
        return clusteredKeyGrammar == null ? "" : clusteredKeyGrammar;
    }

    @Override
    public String getOptionGrammar(String tableName) {
        String partitionOptionsGrammar;
        String storagePolicyGrammar;
        StringBuilder sb = new StringBuilder();
        String tableAttrGrammar = this.getTableAttributeGrammar(tableName);
        if (StringUtils.isNotBlank((CharSequence)tableAttrGrammar)) {
            sb.append("\n").append(tableAttrGrammar);
        }
        if (StringUtils.isNotBlank((CharSequence)(storagePolicyGrammar = this.getStoragePolicyGrammar(tableName)))) {
            sb.append("\n").append(storagePolicyGrammar);
        }
        if (StringUtils.isNotBlank((CharSequence)(partitionOptionsGrammar = this.getPartitionOptionsGrammar(tableName)))) {
            sb.append("\n").append(partitionOptionsGrammar);
        }
        return sb.toString();
    }

    public Map<String, String> getClusteredKeyMap() {
        return this.clusteredKeyMap;
    }

    public Map<String, String> getStoragePolicyMap() {
        return this.storagePolicyMap;
    }

    public Map<String, String> getTableAttributeMap() {
        return this.tableAttributeMap;
    }

    public Map<String, String> getPartitionOptionsMap() {
        return this.partitionOptionsMap;
    }
}

