/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import java.util.stream.Collectors;

public abstract class AbstractDb2Index
extends AbstractIndex {
    private String indexOwner;
    private String uniqueness;
    private Integer columnCount;
    private String indexComment;
    private String indexDefiner;

    public AbstractDb2Index(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder joinIndexColumns() {
        boolean isPriorDb2Luw1050 = this.getDbType().isDb2Type() && this.getDbType().isPrior(DbType.DB2LUW_1050);
        boolean isKeyExprExisted = this.getIndexColumns().stream().anyMatch(KeyColumn::isExpression);
        if (isKeyExprExisted && isPriorDb2Luw1050) {
            return new StringBuilder(0);
        }
        StringBuilder excludes = this.enclose(this.getIndexColumns().stream().filter(e -> !"I".equals(e.getColumnOrder())).map(e -> {
            String columnOrder;
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            if (StringUtils.isNotBlank((CharSequence)(columnOrder = this.getCollationMapping().get(e.getColumnOrder())))) {
                columnName = columnName + columnOrder;
            }
            return columnName;
        }).collect(Collectors.joining(", ")));
        String includes = this.getIndexColumns().stream().filter(e -> "I".equals(e.getColumnOrder())).map(e -> {
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            return columnName;
        }).collect(Collectors.joining(", "));
        StringBuilder sb = new StringBuilder(excludes);
        if (StringUtils.isNotBlank((CharSequence)includes)) {
            sb.append(" INCLUDE").append((CharSequence)this.enclose(includes));
        }
        return sb;
    }

    public String getIndexOwner() {
        return this.indexOwner;
    }

    public void setIndexOwner(String indexOwner) {
        this.indexOwner = indexOwner;
    }

    public String getUniqueness() {
        return this.uniqueness;
    }

    public void setUniqueness(String uniqueness) {
        this.uniqueness = uniqueness;
    }

    public Integer getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(Integer columnCount) {
        this.columnCount = columnCount;
    }

    public String getIndexComment() {
        return this.indexComment;
    }

    public void setIndexComment(String indexComment) {
        this.indexComment = indexComment;
    }

    public String getIndexDefiner() {
        return this.indexDefiner;
    }

    public void setIndexDefiner(String indexDefiner) {
        this.indexDefiner = indexDefiner;
    }
}

