/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2;

import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import java.math.BigDecimal;

public abstract class AbstractDb2Sequence
extends AbstractSequence {
    private String dataType;

    public AbstractDb2Sequence(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildSequenceGrammar() {
        BigDecimal increment;
        StringBuilder sb = new StringBuilder();
        BigDecimal start = this.getStart();
        if (start != null) {
            sb.append(" START WITH ").append(start);
        }
        if ((increment = this.getIncrement()) != null) {
            sb.append(" INCREMENT BY ").append(increment);
        } else {
            sb.append(" INCREMENT BY 1");
        }
        BigDecimal min = this.getMinValue();
        if (min != null) {
            sb.append(" MINVALUE ").append(min);
        } else {
            sb.append(" NOMINVALUE");
        }
        BigDecimal max = this.getMaxValue();
        if (max != null) {
            sb.append(" MAXVALUE ").append(max);
        } else {
            sb.append(" NOMAXVALUE");
        }
        String cycle = this.getCycle();
        if ("Y".equals(cycle) || "YES".equals(cycle)) {
            sb.append(" CYCLE");
        } else {
            sb.append(" NO CYCLE");
        }
        BigDecimal cache = this.getCache();
        if (cache != null && cache.compareTo(BigDecimal.ZERO) > 0) {
            sb.append(" CACHE ").append(cache);
        } else {
            sb.append(" NO CACHE");
        }
        String order = this.getOrder();
        if ("Y".equals(order) || "YES".equals(order)) {
            sb.append(" ORDER");
        } else {
            sb.append(" NO ORDER");
        }
        return sb;
    }

    @Override
    public StringBuilder buildIdentityGrammar() {
        StringBuilder sb = new StringBuilder();
        sb.append(" AS IDENTITY (");
        sb.append(this.buildSequenceGrammar().toString().trim());
        return sb.append(")");
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
}

