/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2;

import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractDb2TablePartition
extends AbstractTablePartition {
    private String partitionType;
    private final Set<Db2TablePartitionItem> partitionItems = new LinkedHashSet<Db2TablePartitionItem>();

    public AbstractDb2TablePartition(AbstractSchema schema) {
        super(schema);
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public Set<Db2TablePartitionItem> getPartitionItems() {
        return this.partitionItems;
    }

    public static class Db2TablePartitionColumn {
        private String name;
        private String dataType;
        private int partitionKeySeq;
        private String partitionExpression;
        private String nullsFirst;
        private String partitionKeyOrdering;

        public Db2TablePartitionColumn(int partitionKeySeq, String partitionExpression, String nullsFirst) {
            this.partitionKeySeq = partitionKeySeq;
            this.partitionExpression = partitionExpression;
            this.nullsFirst = nullsFirst;
        }

        public int hashCode() {
            return Objects.hash(this.partitionExpression, this.partitionKeySeq);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Db2TablePartitionColumn other = (Db2TablePartitionColumn)obj;
            return Objects.deepEquals(other.partitionExpression, this.partitionExpression) && Objects.deepEquals(other.partitionKeySeq, this.partitionKeySeq);
        }

        public Db2TablePartitionColumn() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public int getPartitionKeySeq() {
            return this.partitionKeySeq;
        }

        public void setPartitionKeySeq(int partitionKeySeq) {
            this.partitionKeySeq = partitionKeySeq;
        }

        public String getPartitionExpression() {
            return this.partitionExpression;
        }

        public void setPartitionExpression(String partitionExpression) {
            this.partitionExpression = partitionExpression;
        }

        public String getNullsFirst() {
            return this.nullsFirst;
        }

        public void setNullsFirst(String nullsFirst) {
            this.nullsFirst = nullsFirst;
        }

        public String getPartitionKeyOrdering() {
            return this.partitionKeyOrdering;
        }

        public void setPartitionKeyOrdering(String partitionKeyOrdering) {
            this.partitionKeyOrdering = partitionKeyOrdering;
        }
    }

    public static class Db2TablePartitionItem {
        private String partitionName;
        private Integer partitionNumber;
        private String lowInclusive;
        private String lowValue;
        private String highInclusive;
        private String highValue;
        private BigDecimal hashSpace;

        public int hashCode() {
            return Objects.hash(this.partitionName, this.partitionNumber);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Db2TablePartitionItem other = (Db2TablePartitionItem)obj;
            return Objects.deepEquals(other.partitionName, this.partitionName) && Objects.deepEquals(other.partitionNumber, this.partitionNumber);
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public Integer getPartitionNumber() {
            return this.partitionNumber;
        }

        public void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        public String getLowInclusive() {
            return this.lowInclusive;
        }

        public void setLowInclusive(String lowInclusive) {
            this.lowInclusive = lowInclusive;
        }

        public String getLowValue() {
            return this.lowValue;
        }

        public void setLowValue(String lowValue) {
            this.lowValue = lowValue;
        }

        public String getHighInclusive() {
            return this.highInclusive;
        }

        public void setHighInclusive(String highInclusive) {
            this.highInclusive = highInclusive;
        }

        public String getHighValue() {
            return this.highValue;
        }

        public void setHighValue(String highValue) {
            this.highValue = highValue;
        }

        public BigDecimal getHashSpace() {
            return this.hashSpace;
        }

        public void setHashSpace(BigDecimal hashSpace) {
            this.hashSpace = hashSpace;
        }
    }
}

