/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.ibmi;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Column;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSchema;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSequence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Db2IbmiColumn
extends AbstractDb2Column {
    private String tableOwner;
    private String updatable;
    private String hasDefault;
    private String columnHeading;
    private Integer storage;
    private Integer numericPrecision;
    private Integer ccsid;
    private Integer inlineLength;
    private Integer characterMaximumLength;
    private Integer characterOctetLength;
    private Integer numericPrecisionRadix;
    private Integer datetimePrecision;
    private String columnText;
    private String systemColumnName;
    private String systemTableName;
    private String systemTableSchema;
    private String userDefinedTypeSchema;
    private String userDefinedTypeName;
    private Db2IbmiSequence identityExpr;
    private String identityGeneration;
    private String columnExpression;
    private final Map<String, String> dataTypeMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 6568397954038341136L;
        {
            this.put("VARG", "VARGRAPHIC");
            this.put("VARBIN", "VARBINARY");
            this.put("TIMESTMP", "TIMESTAMP");
        }
    };

    public Db2IbmiColumn(Db2IbmiSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String hasDefault;
        String dataType = this.getDataType();
        if (dataType == null) {
            throw new IllegalArgumentException("DataType is null");
        }
        if ("DATALINK".equals(dataType = dataType.trim())) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The data type: " + dataType + " is unsupported");
        }
        String columnExpression = this.getColumnExpression();
        if (StringUtils.isNotBlank((CharSequence)columnExpression)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The column expression: " + columnExpression + " is unsupported");
        }
        dataType = this.getDataTypeMapping().getOrDefault(dataType, dataType);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGrammarColumnName()).append(" ").append(dataType);
        Long length = this.getDataLength();
        switch (dataType) {
            case "BLOB": 
            case "CLOB": 
            case "NCLOB": 
            case "DBCLOB": {
                if (length == null || length <= 0L) break;
                sb.append("(").append(length).append(")");
                break;
            }
            case "XML": 
            case "TIME": 
            case "DATE": 
            case "ROWID": 
            case "FLOAT": 
            case "BIGINT": 
            case "INTEGER": 
            case "SMALLINT": 
            case "TIMESTAMP": {
                break;
            }
            case "NUMERIC": 
            case "DECIMAL": 
            case "DECFLOAT": {
                sb.append("(").append(this.getNumericPrecision());
                Integer dataScale = this.getDataScale();
                if (dataScale != null && dataScale > 0) {
                    sb.append(",").append(this.getDataScale());
                }
                sb.append(")");
                break;
            }
            default: {
                sb.append("(").append(length).append(")");
                Integer ccsid = this.getCcsid();
                if (("CHARACTER".equals(dataType) || "VARCHAR".equals(dataType)) && ccsid != null && ccsid == 65535) {
                    sb.append(" FOR BIT DATA");
                }
                if (!"CHARACTER".equals(dataType) && !"VARCHAR".equals(dataType) && !"CLOB".equals(dataType)) break;
                if (ccsid != null && ccsid < 4) {
                    sb.append(" FOR SBCS DATA");
                    break;
                }
                if (ccsid == null || ccsid <= 3) break;
                sb.append(" FOR MIXED DATA");
            }
        }
        if ("N".equals(this.getNullable())) {
            sb.append(" NOT NULL");
        }
        if ("Y".equals(hasDefault = this.getHasDefault())) {
            sb.append(" DEFAULT ").append(this.escapeColumnDefault(this.getColumnDefault()));
        } else {
            sb.append(this.getGenerateMapping().getOrDefault(hasDefault, ""));
            if (this.getIdentityExpr() != null) {
                sb.append((CharSequence)this.getIdentityExpr().buildIdentityGrammar());
            }
        }
        if ("P".equals(this.getHidden())) {
            sb.append(" IMPLICITLY HIDDEN");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractColumn other) {
        if (!(other instanceof Db2IbmiColumn)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getTableOwner() {
        return this.tableOwner;
    }

    public void setTableOwner(String tableOwner) {
        this.tableOwner = tableOwner;
    }

    public String getUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(String updatable) {
        this.updatable = updatable;
    }

    public String getHasDefault() {
        return this.hasDefault;
    }

    public void setHasDefault(String hasDefault) {
        this.hasDefault = hasDefault;
    }

    public String getColumnHeading() {
        return this.columnHeading;
    }

    public void setColumnHeading(String columnHeading) {
        this.columnHeading = columnHeading;
    }

    public Integer getStorage() {
        return this.storage;
    }

    public void setStorage(Integer storage) {
        this.storage = storage;
    }

    public Integer getNumericPrecision() {
        return this.numericPrecision;
    }

    public void setNumericPrecision(Integer numericPrecision) {
        this.numericPrecision = numericPrecision;
    }

    public Integer getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(Integer ccsid) {
        this.ccsid = ccsid;
    }

    public Integer getInlineLength() {
        return this.inlineLength;
    }

    public void setInlineLength(Integer inlineLength) {
        this.inlineLength = inlineLength;
    }

    public Integer getCharacterMaximumLength() {
        return this.characterMaximumLength;
    }

    public void setCharacterMaximumLength(Integer characterMaximumLength) {
        this.characterMaximumLength = characterMaximumLength;
    }

    public Integer getCharacterOctetLength() {
        return this.characterOctetLength;
    }

    public void setCharacterOctetLength(Integer characterOctetLength) {
        this.characterOctetLength = characterOctetLength;
    }

    public Integer getNumericPrecisionRadix() {
        return this.numericPrecisionRadix;
    }

    public void setNumericPrecisionRadix(Integer numericPrecisionRadix) {
        this.numericPrecisionRadix = numericPrecisionRadix;
    }

    public Integer getDatetimePrecision() {
        return this.datetimePrecision;
    }

    public void setDatetimePrecision(Integer datetimePrecision) {
        this.datetimePrecision = datetimePrecision;
    }

    public String getColumnText() {
        return this.columnText;
    }

    public void setColumnText(String columnText) {
        this.columnText = columnText;
    }

    public String getSystemColumnName() {
        return this.systemColumnName;
    }

    public void setSystemColumnName(String systemColumnName) {
        this.systemColumnName = systemColumnName;
    }

    public String getSystemTableName() {
        return this.systemTableName;
    }

    public void setSystemTableName(String systemTableName) {
        this.systemTableName = systemTableName;
    }

    public String getSystemTableSchema() {
        return this.systemTableSchema;
    }

    public void setSystemTableSchema(String systemTableSchema) {
        this.systemTableSchema = systemTableSchema;
    }

    public String getUserDefinedTypeSchema() {
        return this.userDefinedTypeSchema;
    }

    public void setUserDefinedTypeSchema(String userDefinedTypeSchema) {
        this.userDefinedTypeSchema = userDefinedTypeSchema;
    }

    public String getUserDefinedTypeName() {
        return this.userDefinedTypeName;
    }

    public void setUserDefinedTypeName(String userDefinedTypeName) {
        this.userDefinedTypeName = userDefinedTypeName;
    }

    public Db2IbmiSequence getIdentityExpr() {
        return this.identityExpr;
    }

    public void setIdentityExpr(Db2IbmiSequence identityExpr) {
        this.identityExpr = identityExpr;
    }

    public String getIdentityGeneration() {
        return this.identityGeneration;
    }

    public void setIdentityGeneration(String identityGeneration) {
        this.identityGeneration = identityGeneration;
    }

    public String getColumnExpression() {
        return this.columnExpression;
    }

    public void setColumnExpression(String columnExpression) {
        this.columnExpression = columnExpression;
    }

    public Map<String, String> getDataTypeMapping() {
        return this.dataTypeMapping;
    }
}

