/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.ibmi;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Index;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSchema;
import java.util.List;

public class Db2IbmiIndex
extends AbstractDb2Index {
    private String tableOwner;
    private String systemIndexName;
    private String systemIndexSchema;
    private String systemTableName;
    private String systemTableSchema;
    private Integer iaspNumber;
    private String indexText;
    private String spanningIndex;
    private String roundingMode;
    private String indexHasSearchCondition;
    private String searchConditionHasUdf;
    private String searchCondition;
    private String systemColumnName;
    private String columnIsExpression;
    private String expressionHasUdf;
    private String keyExpression;

    public Db2IbmiIndex(Db2IbmiSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String spanningIndex;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        sb.append(this.safetyMapping(this.getUniqueRuleMapping(), this.getUniqueness()));
        if (this.getUniqueRuleMapping().containsKey(this.getUniqueness())) {
            this.addUniqueAttribute();
        }
        sb.append(" INDEX ").append(this.getSchemaIndexName()).append(" ON ");
        sb.append(this.getDefinitionSchemaObjectName()).append((CharSequence)this.joinIndexColumns());
        String searchCondition = this.getSearchCondition();
        if (StringUtils.isNotBlank((CharSequence)searchCondition)) {
            sb.append(" ").append(searchCondition);
        }
        if (StringUtils.isNotBlank((CharSequence)(spanningIndex = this.getSpanningIndex())) && !"YES".equals(spanningIndex)) {
            sb.append(" PARTITIONED");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getIndexType(), this.getSimpleIndexName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof Db2IbmiIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getTableOwner() {
        return this.tableOwner;
    }

    public void setTableOwner(String tableOwner) {
        this.tableOwner = tableOwner;
    }

    public String getSystemIndexName() {
        return this.systemIndexName;
    }

    public void setSystemIndexName(String systemIndexName) {
        this.systemIndexName = systemIndexName;
    }

    public String getSystemIndexSchema() {
        return this.systemIndexSchema;
    }

    public void setSystemIndexSchema(String systemIndexSchema) {
        this.systemIndexSchema = systemIndexSchema;
    }

    public String getSystemTableName() {
        return this.systemTableName;
    }

    public void setSystemTableName(String systemTableName) {
        this.systemTableName = systemTableName;
    }

    public String getSystemTableSchema() {
        return this.systemTableSchema;
    }

    public void setSystemTableSchema(String systemTableSchema) {
        this.systemTableSchema = systemTableSchema;
    }

    public Integer getIaspNumber() {
        return this.iaspNumber;
    }

    public void setIaspNumber(Integer iaspNumber) {
        this.iaspNumber = iaspNumber;
    }

    public String getIndexText() {
        return this.indexText;
    }

    public void setIndexText(String indexText) {
        this.indexText = indexText;
    }

    public String getSpanningIndex() {
        return this.spanningIndex;
    }

    public void setSpanningIndex(String spanningIndex) {
        this.spanningIndex = spanningIndex;
    }

    public String getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(String roundingMode) {
        this.roundingMode = roundingMode;
    }

    public String getIndexHasSearchCondition() {
        return this.indexHasSearchCondition;
    }

    public void setIndexHasSearchCondition(String indexHasSearchCondition) {
        this.indexHasSearchCondition = indexHasSearchCondition;
    }

    public String getSearchConditionHasUdf() {
        return this.searchConditionHasUdf;
    }

    public void setSearchConditionHasUdf(String searchConditionHasUdf) {
        this.searchConditionHasUdf = searchConditionHasUdf;
    }

    public String getSearchCondition() {
        return this.searchCondition;
    }

    public void setSearchCondition(String searchCondition) {
        this.searchCondition = searchCondition;
    }

    public String getSystemColumnName() {
        return this.systemColumnName;
    }

    public void setSystemColumnName(String systemColumnName) {
        this.systemColumnName = systemColumnName;
    }

    public String getColumnIsExpression() {
        return this.columnIsExpression;
    }

    public void setColumnIsExpression(String columnIsExpression) {
        this.columnIsExpression = columnIsExpression;
    }

    public String getExpressionHasUdf() {
        return this.expressionHasUdf;
    }

    public void setExpressionHasUdf(String expressionHasUdf) {
        this.expressionHasUdf = expressionHasUdf;
    }

    public String getKeyExpression() {
        return this.keyExpression;
    }

    public void setKeyExpression(String keyExpression) {
        this.keyExpression = keyExpression;
    }
}

