/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.ibmi;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Sequence;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSchema;
import java.math.BigDecimal;
import java.util.List;

public class Db2IbmiSequence
extends AbstractDb2Sequence {
    private String numericPrecision;
    private String userDefinedTypeSchema;
    private String userDefinedTypeName;
    private BigDecimal maxAssignedVal;
    private String sequenceDefiner;
    private String sequenceCreated;
    private String lastAlteredTimestamp;
    private String sequenceText;
    private String longComment;
    private String systemSeqSchema;
    private String systemSeqName;
    private String iaspNumber;

    public Db2IbmiSequence(Db2IbmiSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE SEQUENCE ").append(this.getSchemaObjectName());
        if (StringUtils.isNotBlank((CharSequence)this.getDataType())) {
            sb.append(" AS ").append(this.getDataType());
        }
        sb.append((CharSequence)super.buildSequenceGrammar());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractSequence other) {
        if (!(other instanceof Db2IbmiSequence)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getNumericPrecision() {
        return this.numericPrecision;
    }

    public void setNumericPrecision(String numericPrecision) {
        this.numericPrecision = numericPrecision;
    }

    public String getUserDefinedTypeSchema() {
        return this.userDefinedTypeSchema;
    }

    public void setUserDefinedTypeSchema(String userDefinedTypeSchema) {
        this.userDefinedTypeSchema = userDefinedTypeSchema;
    }

    public String getUserDefinedTypeName() {
        return this.userDefinedTypeName;
    }

    public void setUserDefinedTypeName(String userDefinedTypeName) {
        this.userDefinedTypeName = userDefinedTypeName;
    }

    public BigDecimal getMaxAssignedVal() {
        return this.maxAssignedVal;
    }

    public void setMaxAssignedVal(BigDecimal maxAssignedVal) {
        this.maxAssignedVal = maxAssignedVal;
    }

    public String getSequenceDefiner() {
        return this.sequenceDefiner;
    }

    public void setSequenceDefiner(String sequenceDefiner) {
        this.sequenceDefiner = sequenceDefiner;
    }

    public String getSequenceCreated() {
        return this.sequenceCreated;
    }

    public void setSequenceCreated(String sequenceCreated) {
        this.sequenceCreated = sequenceCreated;
    }

    public String getLastAlteredTimestamp() {
        return this.lastAlteredTimestamp;
    }

    public void setLastAlteredTimestamp(String lastAlteredTimestamp) {
        this.lastAlteredTimestamp = lastAlteredTimestamp;
    }

    public String getSequenceText() {
        return this.sequenceText;
    }

    public void setSequenceText(String sequenceText) {
        this.sequenceText = sequenceText;
    }

    public String getLongComment() {
        return this.longComment;
    }

    public void setLongComment(String longComment) {
        this.longComment = longComment;
    }

    public String getSystemSeqSchema() {
        return this.systemSeqSchema;
    }

    public void setSystemSeqSchema(String systemSeqSchema) {
        this.systemSeqSchema = systemSeqSchema;
    }

    public String getSystemSeqName() {
        return this.systemSeqName;
    }

    public void setSystemSeqName(String systemSeqName) {
        this.systemSeqName = systemSeqName;
    }

    public String getIaspNumber() {
        return this.iaspNumber;
    }

    public void setIaspNumber(String iaspNumber) {
        this.iaspNumber = iaspNumber;
    }
}

