/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.ibmi;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Table;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.AbstractDb2IbmiConstraint;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiCheck;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiColumn;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiForeignKey;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiIndex;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSchema;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiTablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiUniqueKey;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Db2IbmiTable
extends AbstractDb2Table {
    private final Map<String, Db2IbmiColumn> columnMapping = new LinkedHashMap<String, Db2IbmiColumn>();
    private final Map<String, Db2IbmiIndex> indexMapping = new LinkedHashMap<String, Db2IbmiIndex>();
    private final Map<String, Db2IbmiCheck> checkMapping = new LinkedHashMap<String, Db2IbmiCheck>();
    private final Map<String, Db2IbmiUniqueKey> uniqueMapping = new LinkedHashMap<String, Db2IbmiUniqueKey>();
    private final Map<String, Db2IbmiForeignKey> foreignMapping = new LinkedHashMap<String, Db2IbmiForeignKey>();
    private int rowLength;
    private String tableText;
    private Timestamp lastAlteredTimestamp;
    private String systemTableName;
    private String systemTableSchema;
    private String fileType;
    private String baseTableMember;
    private String systemTable;
    private String selectOmit;
    private String isInsertableInto;
    private int iaspNumber;
    private String enabled;
    private String maintenance;
    private String mqtDefinition;
    private String isolation;
    private String partitionTable;
    private String mqtRestoreDeferred;
    private String roundingMode;
    private Db2IbmiPrimaryKey primaryKey;
    private Db2IbmiTablePartition tablePartition;

    public Db2IbmiTable(Db2IbmiSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String objectName = this.getDefinitionSchemaObjectName();
        sb.append("CREATE TABLE ").append(objectName).append(" (");
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        String tableComment = this.getTableComment();
        if (StringUtils.isNotBlank((CharSequence)tableComment)) {
            tableComment = String.format("COMMENT ON TABLE %s IS '%s'", objectName, tableComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, objectName, this.terminate(tableComment)));
        }
        Collection<Db2IbmiColumn> columns = this.getColumnMapping().values();
        Iterator<Db2IbmiColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            String colComment;
            Iterator<AbstractDb2IbmiConstraint> col = iter.next();
            sb.append("\n\t").append((CharSequence)((Db2IbmiColumn)((Object)col)).buildGrammar());
            if (iter.hasNext()) {
                sb.append(",");
            }
            if (!StringUtils.isNotBlank((CharSequence)(colComment = ((AbstractColumn)((Object)col)).getColumnComment()))) continue;
            String wrappedName = ((AbstractColumn)((Object)col)).getWrappedName();
            colComment = String.format("COMMENT ON COLUMN %s.%s IS '%s'", objectName, wrappedName, colComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, wrappedName, this.terminate(colComment)));
        }
        Db2IbmiPrimaryKey primaryKey = this.getPrimaryKey();
        if (primaryKey != null) {
            sb.append(",").append("\n\t").append((CharSequence)primaryKey.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (Db2IbmiUniqueKey uniqueKey : this.getUniqueMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)uniqueKey.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (Db2IbmiForeignKey foreignKey : this.getForeignMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)foreignKey.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (Db2IbmiCheck check : this.getCheckMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)check.buildGrammar());
            }
        }
        sb.append("\n").append(")");
        Db2IbmiTablePartition tablePartition = this.getTablePartition();
        if (tablePartition != null) {
            sb.append((CharSequence)tablePartition.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            for (Db2IbmiIndex index : this.getIndexMapping().values()) {
                subDefines.addAll(index.buildDefinition());
            }
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines)});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof Db2IbmiTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Map<String, Db2IbmiColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, Db2IbmiIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, Db2IbmiCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public Map<String, Db2IbmiUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, Db2IbmiForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public int getRowLength() {
        return this.rowLength;
    }

    public void setRowLength(int rowLength) {
        this.rowLength = rowLength;
    }

    public String getTableText() {
        return this.tableText;
    }

    public void setTableText(String tableText) {
        this.tableText = tableText;
    }

    public Timestamp getLastAlteredTimestamp() {
        return this.lastAlteredTimestamp;
    }

    public void setLastAlteredTimestamp(Timestamp lastAlteredTimestamp) {
        this.lastAlteredTimestamp = lastAlteredTimestamp;
    }

    public String getSystemTableName() {
        return this.systemTableName;
    }

    public void setSystemTableName(String systemTableName) {
        this.systemTableName = systemTableName;
    }

    public String getSystemTableSchema() {
        return this.systemTableSchema;
    }

    public void setSystemTableSchema(String systemTableSchema) {
        this.systemTableSchema = systemTableSchema;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getBaseTableMember() {
        return this.baseTableMember;
    }

    public void setBaseTableMember(String baseTableMember) {
        this.baseTableMember = baseTableMember;
    }

    public String getSystemTable() {
        return this.systemTable;
    }

    public void setSystemTable(String systemTable) {
        this.systemTable = systemTable;
    }

    public String getSelectOmit() {
        return this.selectOmit;
    }

    public void setSelectOmit(String selectOmit) {
        this.selectOmit = selectOmit;
    }

    public String getIsInsertableInto() {
        return this.isInsertableInto;
    }

    public void setIsInsertableInto(String isInsertableInto) {
        this.isInsertableInto = isInsertableInto;
    }

    public int getIaspNumber() {
        return this.iaspNumber;
    }

    public void setIaspNumber(int iaspNumber) {
        this.iaspNumber = iaspNumber;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public String getMaintenance() {
        return this.maintenance;
    }

    public void setMaintenance(String maintenance) {
        this.maintenance = maintenance;
    }

    public String getMqtDefinition() {
        return this.mqtDefinition;
    }

    public void setMqtDefinition(String mqtDefinition) {
        this.mqtDefinition = mqtDefinition;
    }

    public String getIsolation() {
        return this.isolation;
    }

    public void setIsolation(String isolation) {
        this.isolation = isolation;
    }

    public String getPartitionTable() {
        return this.partitionTable;
    }

    public void setPartitionTable(String partitionTable) {
        this.partitionTable = partitionTable;
    }

    public String getMqtRestoreDeferred() {
        return this.mqtRestoreDeferred;
    }

    public void setMqtRestoreDeferred(String mqtRestoreDeferred) {
        this.mqtRestoreDeferred = mqtRestoreDeferred;
    }

    public String getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(String roundingMode) {
        this.roundingMode = roundingMode;
    }

    public Db2IbmiPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Db2IbmiPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Db2IbmiTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(Db2IbmiTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

