/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.ibmi;

import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSchema;
import java.util.Iterator;
import java.util.List;

public class Db2IbmiTablePartition
extends AbstractDb2TablePartition {
    private Integer numberDistributedPartitions;
    private Long maintainedTemporaryIndexSize;
    private Integer numberDistinctIndexes;
    private Long nextIdentityValue;
    private String keepInMemory;
    private String mediaPreference;
    private String systemTableSchema;
    private String systemTableName;
    private String partitioningKeys;
    private String systemTableMember;
    private String aspNumber;
    private String diskType;
    private String diskModel;
    private String unitNumber;
    private String logicalMirroredPairStatus;
    private String mirroredUnitStatus;
    private Long unitMediaCapacity;
    private Long unitSpaceAvailable;
    private Long unitSpaceReservedForSystem;
    private Long unitSpaceUsed;
    private Integer unitTotalAccessTime;
    private Integer unitType;
    private Integer dataSegmentType;

    public Db2IbmiTablePartition(Db2IbmiSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String partitionType = this.getPartitionType();
        if ("D".equals(partitionType)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The partition type: " + partitionType + " is unsupported");
        }
        StringBuilder sb = new StringBuilder();
        partitionType = this.getPartTypeMapping().get(partitionType);
        sb.append(" PARTITION BY ").append(partitionType);
        sb.append((CharSequence)this.enclose(this.getPartitioningKeys()));
        if ("HASH".equals(partitionType)) {
            return sb.append(" INTO ").append(this.getPartitionItems().size()).append(" PARTITIONS");
        }
        if ("RANGE".equals(partitionType)) {
            sb.append("\n").append("(");
            Iterator<AbstractDb2TablePartition.Db2TablePartitionItem> iter = this.getPartitionItems().iterator();
            while (iter.hasNext()) {
                AbstractDb2TablePartition.Db2TablePartitionItem partItem = iter.next();
                sb.append("\n\t");
                sb.append("PARTITION ").append(this.wrap(partItem.getPartitionName()));
                if ("Y".equals(partItem.getLowInclusive())) {
                    sb.append(" STARTING").append((CharSequence)this.enclose(partItem.getLowValue()));
                }
                if ("Y".equals(partItem.getHighInclusive())) {
                    sb.append(" ENDING").append((CharSequence)this.enclose(partItem.getHighValue()));
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            return sb.append("\n").append(")");
        }
        throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The Partition Type: " + partitionType + " is unsupported");
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof Db2IbmiTablePartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Integer getNumberDistributedPartitions() {
        return this.numberDistributedPartitions;
    }

    public void setNumberDistributedPartitions(Integer numberDistributedPartitions) {
        this.numberDistributedPartitions = numberDistributedPartitions;
    }

    public Long getMaintainedTemporaryIndexSize() {
        return this.maintainedTemporaryIndexSize;
    }

    public void setMaintainedTemporaryIndexSize(Long maintainedTemporaryIndexSize) {
        this.maintainedTemporaryIndexSize = maintainedTemporaryIndexSize;
    }

    public Integer getNumberDistinctIndexes() {
        return this.numberDistinctIndexes;
    }

    public void setNumberDistinctIndexes(Integer numberDistinctIndexes) {
        this.numberDistinctIndexes = numberDistinctIndexes;
    }

    public Long getNextIdentityValue() {
        return this.nextIdentityValue;
    }

    public void setNextIdentityValue(Long nextIdentityValue) {
        this.nextIdentityValue = nextIdentityValue;
    }

    public String getKeepInMemory() {
        return this.keepInMemory;
    }

    public void setKeepInMemory(String keepInMemory) {
        this.keepInMemory = keepInMemory;
    }

    public String getMediaPreference() {
        return this.mediaPreference;
    }

    public void setMediaPreference(String mediaPreference) {
        this.mediaPreference = mediaPreference;
    }

    public String getSystemTableSchema() {
        return this.systemTableSchema;
    }

    public void setSystemTableSchema(String systemTableSchema) {
        this.systemTableSchema = systemTableSchema;
    }

    public String getSystemTableName() {
        return this.systemTableName;
    }

    public void setSystemTableName(String systemTableName) {
        this.systemTableName = systemTableName;
    }

    public String getPartitioningKeys() {
        return this.partitioningKeys;
    }

    public void setPartitioningKeys(String partitioningKeys) {
        this.partitioningKeys = partitioningKeys;
    }

    public String getSystemTableMember() {
        return this.systemTableMember;
    }

    public void setSystemTableMember(String systemTableMember) {
        this.systemTableMember = systemTableMember;
    }

    public String getAspNumber() {
        return this.aspNumber;
    }

    public void setAspNumber(String aspNumber) {
        this.aspNumber = aspNumber;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public void setDiskType(String diskType) {
        this.diskType = diskType;
    }

    public String getDiskModel() {
        return this.diskModel;
    }

    public void setDiskModel(String diskModel) {
        this.diskModel = diskModel;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public String getLogicalMirroredPairStatus() {
        return this.logicalMirroredPairStatus;
    }

    public void setLogicalMirroredPairStatus(String logicalMirroredPairStatus) {
        this.logicalMirroredPairStatus = logicalMirroredPairStatus;
    }

    public String getMirroredUnitStatus() {
        return this.mirroredUnitStatus;
    }

    public void setMirroredUnitStatus(String mirroredUnitStatus) {
        this.mirroredUnitStatus = mirroredUnitStatus;
    }

    public Long getUnitMediaCapacity() {
        return this.unitMediaCapacity;
    }

    public void setUnitMediaCapacity(Long unitMediaCapacity) {
        this.unitMediaCapacity = unitMediaCapacity;
    }

    public Long getUnitSpaceAvailable() {
        return this.unitSpaceAvailable;
    }

    public void setUnitSpaceAvailable(Long unitSpaceAvailable) {
        this.unitSpaceAvailable = unitSpaceAvailable;
    }

    public Long getUnitSpaceReservedForSystem() {
        return this.unitSpaceReservedForSystem;
    }

    public void setUnitSpaceReservedForSystem(Long unitSpaceReservedForSystem) {
        this.unitSpaceReservedForSystem = unitSpaceReservedForSystem;
    }

    public Long getUnitSpaceUsed() {
        return this.unitSpaceUsed;
    }

    public void setUnitSpaceUsed(Long unitSpaceUsed) {
        this.unitSpaceUsed = unitSpaceUsed;
    }

    public Integer getUnitTotalAccessTime() {
        return this.unitTotalAccessTime;
    }

    public void setUnitTotalAccessTime(Integer unitTotalAccessTime) {
        this.unitTotalAccessTime = unitTotalAccessTime;
    }

    public Integer getUnitType() {
        return this.unitType;
    }

    public void setUnitType(Integer unitType) {
        this.unitType = unitType;
    }

    public Integer getDataSegmentType() {
        return this.dataSegmentType;
    }

    public void setDataSegmentType(Integer dataSegmentType) {
        this.dataSegmentType = dataSegmentType;
    }
}

