/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.ibmi;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTrigger;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Trigger;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSchema;
import java.util.List;

public class Db2IbmiTrigger
extends AbstractDb2Trigger {
    private String eventManipulation;
    private String eventObjectSchema;
    private String eventObjectTable;
    private String actionOrder;
    private String actionCondition;
    private String actionStatement;
    private String actionOrientation;
    private String actionTiming;
    private String triggerMode;
    private String actionReferenceOldRow;
    private String actionReferenceNewRow;
    private String actionReferenceOldTable;
    private String actionReferenceNewTable;
    private String sqlPath;
    private String created;
    private String triggerProgramName;
    private String triggerProgramLibrary;
    private String operative;
    private String enabled;
    private String threadsafe;
    private String multithreadedJobAction;
    private String allowRepeatedChange;
    private String triggerUpdateCondition;
    private String triggerDefiner;
    private String triggerText;
    private String longComment;
    private String roundingMode;
    private String systemTriggerSchema;
    private String systemEventObjectSchema;
    private String systemEventObjectTable;
    private String eventUpdate;
    private String eventInsert;
    private String eventDelete;

    public Db2IbmiTrigger(Db2IbmiSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE TRIGGER ").append(this.getSchemaObjectName()).append("\n");
        sb.append(this.getActionTiming()).append(" ").append(this.getEventManipulation());
        sb.append(" ON ").append(this.wrap(this.getEventObjectSchema())).append(".").append(this.wrap(this.getEventObjectTable()));
        String actionOrientation = this.getActionOrientation();
        if ("ROW".equals(actionOrientation)) {
            sb.append(" FOR EACH ROW");
        } else if ("STATEMENT".equals(actionOrientation)) {
            sb.append(" FOR EACH STATEMENT");
        }
        String triggerMode = this.getTriggerMode();
        if (StringUtils.isNotBlank((CharSequence)triggerMode)) {
            sb.append(" MODE ").append(triggerMode);
        }
        sb.append("\n").append(this.getActionStatement().trim());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTrigger other) {
        if (!(other instanceof Db2IbmiTrigger)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getEventManipulation() {
        return this.eventManipulation;
    }

    public void setEventManipulation(String eventManipulation) {
        this.eventManipulation = eventManipulation;
    }

    public String getEventObjectSchema() {
        return this.eventObjectSchema;
    }

    public void setEventObjectSchema(String eventObjectSchema) {
        this.eventObjectSchema = eventObjectSchema;
    }

    public String getEventObjectTable() {
        return this.eventObjectTable;
    }

    public void setEventObjectTable(String eventObjectTable) {
        this.eventObjectTable = eventObjectTable;
    }

    public String getActionOrder() {
        return this.actionOrder;
    }

    public void setActionOrder(String actionOrder) {
        this.actionOrder = actionOrder;
    }

    public String getActionCondition() {
        return this.actionCondition;
    }

    public void setActionCondition(String actionCondition) {
        this.actionCondition = actionCondition;
    }

    public String getActionStatement() {
        return this.actionStatement;
    }

    public void setActionStatement(String actionStatement) {
        this.actionStatement = actionStatement;
    }

    public String getActionOrientation() {
        return this.actionOrientation;
    }

    public void setActionOrientation(String actionOrientation) {
        this.actionOrientation = actionOrientation;
    }

    public String getActionTiming() {
        return this.actionTiming;
    }

    public void setActionTiming(String actionTiming) {
        this.actionTiming = actionTiming;
    }

    public String getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(String triggerMode) {
        this.triggerMode = triggerMode;
    }

    public String getActionReferenceOldRow() {
        return this.actionReferenceOldRow;
    }

    public void setActionReferenceOldRow(String actionReferenceOldRow) {
        this.actionReferenceOldRow = actionReferenceOldRow;
    }

    public String getActionReferenceNewRow() {
        return this.actionReferenceNewRow;
    }

    public void setActionReferenceNewRow(String actionReferenceNewRow) {
        this.actionReferenceNewRow = actionReferenceNewRow;
    }

    public String getActionReferenceOldTable() {
        return this.actionReferenceOldTable;
    }

    public void setActionReferenceOldTable(String actionReferenceOldTable) {
        this.actionReferenceOldTable = actionReferenceOldTable;
    }

    public String getActionReferenceNewTable() {
        return this.actionReferenceNewTable;
    }

    public void setActionReferenceNewTable(String actionReferenceNewTable) {
        this.actionReferenceNewTable = actionReferenceNewTable;
    }

    public String getSqlPath() {
        return this.sqlPath;
    }

    public void setSqlPath(String sqlPath) {
        this.sqlPath = sqlPath;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getTriggerProgramName() {
        return this.triggerProgramName;
    }

    public void setTriggerProgramName(String triggerProgramName) {
        this.triggerProgramName = triggerProgramName;
    }

    public String getTriggerProgramLibrary() {
        return this.triggerProgramLibrary;
    }

    public void setTriggerProgramLibrary(String triggerProgramLibrary) {
        this.triggerProgramLibrary = triggerProgramLibrary;
    }

    public String getOperative() {
        return this.operative;
    }

    public void setOperative(String operative) {
        this.operative = operative;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public String getThreadsafe() {
        return this.threadsafe;
    }

    public void setThreadsafe(String threadsafe) {
        this.threadsafe = threadsafe;
    }

    public String getMultithreadedJobAction() {
        return this.multithreadedJobAction;
    }

    public void setMultithreadedJobAction(String multithreadedJobAction) {
        this.multithreadedJobAction = multithreadedJobAction;
    }

    public String getAllowRepeatedChange() {
        return this.allowRepeatedChange;
    }

    public void setAllowRepeatedChange(String allowRepeatedChange) {
        this.allowRepeatedChange = allowRepeatedChange;
    }

    public String getTriggerUpdateCondition() {
        return this.triggerUpdateCondition;
    }

    public void setTriggerUpdateCondition(String triggerUpdateCondition) {
        this.triggerUpdateCondition = triggerUpdateCondition;
    }

    public String getTriggerDefiner() {
        return this.triggerDefiner;
    }

    public void setTriggerDefiner(String triggerDefiner) {
        this.triggerDefiner = triggerDefiner;
    }

    public String getTriggerText() {
        return this.triggerText;
    }

    public void setTriggerText(String triggerText) {
        this.triggerText = triggerText;
    }

    public String getLongComment() {
        return this.longComment;
    }

    public void setLongComment(String longComment) {
        this.longComment = longComment;
    }

    public String getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(String roundingMode) {
        this.roundingMode = roundingMode;
    }

    public String getSystemTriggerSchema() {
        return this.systemTriggerSchema;
    }

    public void setSystemTriggerSchema(String systemTriggerSchema) {
        this.systemTriggerSchema = systemTriggerSchema;
    }

    public String getSystemEventObjectSchema() {
        return this.systemEventObjectSchema;
    }

    public void setSystemEventObjectSchema(String systemEventObjectSchema) {
        this.systemEventObjectSchema = systemEventObjectSchema;
    }

    public String getSystemEventObjectTable() {
        return this.systemEventObjectTable;
    }

    public void setSystemEventObjectTable(String systemEventObjectTable) {
        this.systemEventObjectTable = systemEventObjectTable;
    }

    public String getEventUpdate() {
        return this.eventUpdate;
    }

    public void setEventUpdate(String eventUpdate) {
        this.eventUpdate = eventUpdate;
    }

    public String getEventInsert() {
        return this.eventInsert;
    }

    public void setEventInsert(String eventInsert) {
        this.eventInsert = eventInsert;
    }

    public String getEventDelete() {
        return this.eventDelete;
    }

    public void setEventDelete(String eventDelete) {
        this.eventDelete = eventDelete;
    }
}

