/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.ibmi;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractView;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2View;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSchema;
import java.util.List;

public class Db2IbmiView
extends AbstractDb2View {
    private String isUpdatable;
    private String systemViewName;
    private String systemViewSchema;
    private String isInsertableInto;
    private String iaspNumber;
    private String isDeletable;
    private String roundingMode;

    public Db2IbmiView(Db2IbmiSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE");
        sb.append(" VIEW ").append(this.getDefinitionSchemaObjectName());
        sb.append(" AS ").append(this.getText());
        String checkOption = this.getCheckOption();
        if (!"N".equals(checkOption)) {
            sb.append(this.safetyMapping(this.getCheckOptionMapping(), checkOption));
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractView other) {
        if (!(other instanceof Db2IbmiView)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getIsUpdatable() {
        return this.isUpdatable;
    }

    public void setIsUpdatable(String isUpdatable) {
        this.isUpdatable = isUpdatable;
    }

    public String getSystemViewName() {
        return this.systemViewName;
    }

    public void setSystemViewName(String systemViewName) {
        this.systemViewName = systemViewName;
    }

    public String getSystemViewSchema() {
        return this.systemViewSchema;
    }

    public void setSystemViewSchema(String systemViewSchema) {
        this.systemViewSchema = systemViewSchema;
    }

    public String getIsInsertableInto() {
        return this.isInsertableInto;
    }

    public void setIsInsertableInto(String isInsertableInto) {
        this.isInsertableInto = isInsertableInto;
    }

    public String getIaspNumber() {
        return this.iaspNumber;
    }

    public void setIaspNumber(String iaspNumber) {
        this.iaspNumber = iaspNumber;
    }

    public String getIsDeletable() {
        return this.isDeletable;
    }

    public void setIsDeletable(String isDeletable) {
        this.isDeletable = isDeletable;
    }

    public String getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(String roundingMode) {
        this.roundingMode = roundingMode;
    }
}

