/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.luw;

import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.MapField;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.db2.luw.AbstractDb2LuwConstraint;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql32xCheck;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xCheck;
import java.util.List;

public class Db2LuwCheck
extends AbstractDb2LuwConstraint {
    @MapField(targetClass=ObOracle22xCheck.class, targetField="generated")
    private String ownerType;
    private String colName;
    private String usage;
    private String createTime;
    private String qualifier;
    private String funcPath;
    @MapField(targetClass=ObMySql32xCheck.class, targetField="checkClause")
    private String searchCondition;
    private String percentValid;
    private String collationSchema;
    private String collationName;
    private String collationSchemaOrderBy;
    private String collationNameOrderBy;
    private String envStringUnits;

    public Db2LuwCheck(Db2LuwSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName()));
        sb.append(" CHECK ").append(this.getSearchCondition());
        sb.append(this.safetyMapping(this.getEnforceMapping(), this.getEnforced()));
        sb.append(this.safetyMapping(this.getTrustMapping(), this.getTrusted()));
        return sb.append(this.safetyMapping(this.getQueryOptMapping(), this.getEnableQueryOpt()));
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof Db2LuwCheck)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getFuncPath() {
        return this.funcPath;
    }

    public void setFuncPath(String funcPath) {
        this.funcPath = funcPath;
    }

    public String getSearchCondition() {
        return this.searchCondition;
    }

    public void setSearchCondition(String searchCondition) {
        this.searchCondition = searchCondition;
    }

    public String getPercentValid() {
        return this.percentValid;
    }

    public void setPercentValid(String percentValid) {
        this.percentValid = percentValid;
    }

    public String getCollationSchema() {
        return this.collationSchema;
    }

    public void setCollationSchema(String collationSchema) {
        this.collationSchema = collationSchema;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public String getCollationSchemaOrderBy() {
        return this.collationSchemaOrderBy;
    }

    public void setCollationSchemaOrderBy(String collationSchemaOrderBy) {
        this.collationSchemaOrderBy = collationSchemaOrderBy;
    }

    public String getCollationNameOrderBy() {
        return this.collationNameOrderBy;
    }

    public void setCollationNameOrderBy(String collationNameOrderBy) {
        this.collationNameOrderBy = collationNameOrderBy;
    }

    public String getEnvStringUnits() {
        return this.envStringUnits;
    }

    public void setEnvStringUnits(String envStringUnits) {
        this.envStringUnits = envStringUnits;
    }
}

