/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.luw;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Column;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSequence;
import java.util.List;

public class Db2LuwColumn
extends AbstractDb2Column {
    private String typeSchema;
    private String typeStringUnits;
    private Long stringUnitsLength;
    private int codePage = 1;
    private String collationSchema;
    private String collationName;
    private String logged;
    private String compact;
    private long colCard;
    private String high2Key;
    private String low2Key;
    private String avgColLen;
    private String keySeq;
    private String partKeySeq;
    private String nQuantiles;
    private String nMostFreq;
    private String numNulls;
    private String targetTypeSchema;
    private String targetTypeName;
    private String scopeTabSchema;
    private String scopeTabName;
    private String sourceTabSchema;
    private String sourceTabName;
    private String specialProps;
    private Integer inlineLength;
    private Integer pctInlined;
    private String rowChangeTimestamp;
    private String generated;
    private String text;
    private String compress;
    private String avgDistinctPerpage;
    private String pageVarianceRatio;
    private String subCount;
    private String subDelimLength;
    private String avgColLenChar;
    private String implicitValue;
    private String secLabelName;
    private String rowBegin;
    private String rowEnd;
    private String transactionStartId;
    private Db2LuwSequence identityExpr;

    public Db2LuwColumn(Db2LuwSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String hidden;
        String generated;
        String columnDefault;
        Integer inlineLength;
        String dataType = this.getDataType();
        if (dataType == null) {
            throw new IllegalArgumentException("The data type is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGrammarColumnName()).append(" ").append(dataType);
        Long length = this.getDataLength();
        Integer scale = this.getDataScale();
        switch (dataType) {
            case "BLOB": 
            case "CLOB": 
            case "NCLOB": 
            case "DBCLOB": {
                String typeStringUnits = this.getTypeStringUnits();
                if (length == null || length <= 0L) break;
                sb.append("(").append(length);
                if (StringUtils.isNotBlank((CharSequence)typeStringUnits)) {
                    sb.append(" ").append(typeStringUnits);
                }
                sb.append(")");
                break;
            }
            case "XML": 
            case "TIME": 
            case "DATE": 
            case "REAL": 
            case "BIGINT": 
            case "DOUBLE": 
            case "INTEGER": 
            case "BOOLEAN": 
            case "SMALLINT": {
                break;
            }
            case "TIMESTAMP": {
                if (scale == null || scale == 6) break;
                sb.append("(").append(scale).append(")");
                break;
            }
            case "NUMERIC": 
            case "DECIMAL": {
                if (length == null || length <= 0L) break;
                sb.append("(").append(length);
                if (scale != null && scale > -1) {
                    sb.append(",").append(scale);
                }
                sb.append(")");
                break;
            }
            case "DECFLOAT": {
                if (length == 8L) {
                    sb.append("(16)");
                    break;
                }
                if (length != 16L) break;
                sb.append("(34)");
                break;
            }
            default: {
                boolean isBitDataType;
                String typeStringUnits = this.getTypeStringUnits();
                if (StringUtils.isBlank((CharSequence)typeStringUnits)) {
                    if (length != null && length > 0L) {
                        sb.append("(").append(length).append(")");
                    }
                } else {
                    Long ulength = this.getStringUnitsLength();
                    if (ulength != null && ulength > 0L) {
                        sb.append("(");
                        sb.append(ulength);
                        if (DbType.DB2LUW_1050.isPriorFrom(this.getDbType())) {
                            sb.append(" ").append(typeStringUnits);
                        }
                        sb.append(")");
                    }
                }
                boolean bl = isBitDataType = "CHARACTER".equals(dataType) || "CHAR".equals(dataType) || "VARCHAR".equals(dataType);
                if (this.getCodePage() != 0 || !isBitDataType) break;
                sb.append(" FOR BIT DATA");
                break;
            }
        }
        if ((inlineLength = this.getInlineLength()) != null && inlineLength > 0) {
            sb.append(" INLINE LENGTH ").append(inlineLength);
        }
        if ("N".equals(this.getNullable())) {
            sb.append(" NOT NULL");
        }
        if (StringUtils.contains((String)dataType, (String)"LOB")) {
            if ("N".equals(this.getLogged())) {
                sb.append(" NOT LOGGED");
            }
            if ("Y".equals(this.getCompact())) {
                sb.append(" COMPACT");
            }
        }
        if ((columnDefault = this.getColumnDefault()) != null) {
            sb.append(" DEFAULT ").append(this.escapeColumnDefault(columnDefault));
            if (columnDefault.contains("--")) {
                sb.append("\n");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(generated = this.getGenerated()))) {
            sb.append(this.safetyMapping(this.getGenerateMapping(), generated));
            String generateText = this.getText();
            if (StringUtils.isNotBlank((CharSequence)generateText)) {
                sb.append(" ").append(generateText);
            }
            if (this.getIdentityExpr() != null) {
                sb.append((CharSequence)this.getIdentityExpr().buildIdentityGrammar());
            }
            if ("Y".equals(this.getRowBegin())) {
                sb.append(" AS ROW BEGIN");
            }
            if ("Y".equals(this.getRowEnd())) {
                sb.append(" AS ROW END");
            }
            if ("Y".equals(this.getTransactionStartId())) {
                sb.append(" AS TRANSACTION START ID");
            }
            if ("Y".equals(this.getRowChangeTimestamp())) {
                sb.append(" FOR EACH ROW ON UPDATE AS ROW CHANGE TIMESTAMP");
            }
        }
        if ("I".equals(hidden = this.getHidden())) {
            sb.append(" IMPLICITLY HIDDEN");
        }
        if ("S".equals(this.getCompress())) {
            sb.append(" COMPRESS SYSTEM DEFAULT");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractColumn other) {
        if (!(other instanceof Db2LuwColumn)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getTypeSchema() {
        return this.typeSchema;
    }

    public void setTypeSchema(String typeSchema) {
        this.typeSchema = typeSchema;
    }

    public String getTypeStringUnits() {
        return this.typeStringUnits;
    }

    public void setTypeStringUnits(String typeStringUnits) {
        this.typeStringUnits = typeStringUnits;
    }

    public Long getStringUnitsLength() {
        return this.stringUnitsLength;
    }

    public void setStringUnitsLength(Long stringUnitsLength) {
        this.stringUnitsLength = stringUnitsLength;
    }

    public int getCodePage() {
        return this.codePage;
    }

    public void setCodePage(int codePage) {
        this.codePage = codePage;
    }

    public String getCollationSchema() {
        return this.collationSchema;
    }

    public void setCollationSchema(String collationSchema) {
        this.collationSchema = collationSchema;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public String getLogged() {
        return this.logged;
    }

    public void setLogged(String logged) {
        this.logged = logged;
    }

    public String getCompact() {
        return this.compact;
    }

    public void setCompact(String compact) {
        this.compact = compact;
    }

    public long getColCard() {
        return this.colCard;
    }

    public void setColCard(long colCard) {
        this.colCard = colCard;
    }

    public String getHigh2Key() {
        return this.high2Key;
    }

    public void setHigh2Key(String high2Key) {
        this.high2Key = high2Key;
    }

    public String getLow2Key() {
        return this.low2Key;
    }

    public void setLow2Key(String low2Key) {
        this.low2Key = low2Key;
    }

    public String getAvgColLen() {
        return this.avgColLen;
    }

    public void setAvgColLen(String avgColLen) {
        this.avgColLen = avgColLen;
    }

    public String getKeySeq() {
        return this.keySeq;
    }

    public void setKeySeq(String keySeq) {
        this.keySeq = keySeq;
    }

    public String getPartKeySeq() {
        return this.partKeySeq;
    }

    public void setPartKeySeq(String partKeySeq) {
        this.partKeySeq = partKeySeq;
    }

    public String getNQuantiles() {
        return this.nQuantiles;
    }

    public void setNQuantiles(String nQuantiles) {
        this.nQuantiles = nQuantiles;
    }

    public String getNMostFreq() {
        return this.nMostFreq;
    }

    public void setNMostFreq(String nMostFreq) {
        this.nMostFreq = nMostFreq;
    }

    public String getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(String numNulls) {
        this.numNulls = numNulls;
    }

    public String getTargetTypeSchema() {
        return this.targetTypeSchema;
    }

    public void setTargetTypeSchema(String targetTypeSchema) {
        this.targetTypeSchema = targetTypeSchema;
    }

    public String getTargetTypeName() {
        return this.targetTypeName;
    }

    public void setTargetTypeName(String targetTypeName) {
        this.targetTypeName = targetTypeName;
    }

    public String getScopeTabSchema() {
        return this.scopeTabSchema;
    }

    public void setScopeTabSchema(String scopeTabSchema) {
        this.scopeTabSchema = scopeTabSchema;
    }

    public String getScopeTabName() {
        return this.scopeTabName;
    }

    public void setScopeTabName(String scopeTabName) {
        this.scopeTabName = scopeTabName;
    }

    public String getSourceTabSchema() {
        return this.sourceTabSchema;
    }

    public void setSourceTabSchema(String sourceTabSchema) {
        this.sourceTabSchema = sourceTabSchema;
    }

    public String getSourceTabName() {
        return this.sourceTabName;
    }

    public void setSourceTabName(String sourceTabName) {
        this.sourceTabName = sourceTabName;
    }

    public String getSpecialProps() {
        return this.specialProps;
    }

    public void setSpecialProps(String specialProps) {
        this.specialProps = specialProps;
    }

    public Integer getInlineLength() {
        return this.inlineLength;
    }

    public void setInlineLength(Integer inlineLength) {
        this.inlineLength = inlineLength;
    }

    public Integer getPctInlined() {
        return this.pctInlined;
    }

    public void setPctInlined(Integer pctInlined) {
        this.pctInlined = pctInlined;
    }

    public String getRowChangeTimestamp() {
        return this.rowChangeTimestamp;
    }

    public void setRowChangeTimestamp(String rowChangeTimestamp) {
        this.rowChangeTimestamp = rowChangeTimestamp;
    }

    public String getGenerated() {
        return this.generated;
    }

    public void setGenerated(String generated) {
        this.generated = generated;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getCompress() {
        return this.compress;
    }

    public void setCompress(String compress) {
        this.compress = compress;
    }

    public String getAvgDistinctPerpage() {
        return this.avgDistinctPerpage;
    }

    public void setAvgDistinctPerpage(String avgDistinctPerpage) {
        this.avgDistinctPerpage = avgDistinctPerpage;
    }

    public String getPageVarianceRatio() {
        return this.pageVarianceRatio;
    }

    public void setPageVarianceRatio(String pageVarianceRatio) {
        this.pageVarianceRatio = pageVarianceRatio;
    }

    public String getSubCount() {
        return this.subCount;
    }

    public void setSubCount(String subCount) {
        this.subCount = subCount;
    }

    public String getSubDelimLength() {
        return this.subDelimLength;
    }

    public void setSubDelimLength(String subDelimLength) {
        this.subDelimLength = subDelimLength;
    }

    public String getAvgColLenChar() {
        return this.avgColLenChar;
    }

    public void setAvgColLenChar(String avgColLenChar) {
        this.avgColLenChar = avgColLenChar;
    }

    public String getImplicitValue() {
        return this.implicitValue;
    }

    public void setImplicitValue(String implicitValue) {
        this.implicitValue = implicitValue;
    }

    public String getSecLabelName() {
        return this.secLabelName;
    }

    public void setSecLabelName(String secLabelName) {
        this.secLabelName = secLabelName;
    }

    public String getRowBegin() {
        return this.rowBegin;
    }

    public void setRowBegin(String rowBegin) {
        this.rowBegin = rowBegin;
    }

    public String getRowEnd() {
        return this.rowEnd;
    }

    public void setRowEnd(String rowEnd) {
        this.rowEnd = rowEnd;
    }

    public String getTransactionStartId() {
        return this.transactionStartId;
    }

    public void setTransactionStartId(String transactionStartId) {
        this.transactionStartId = transactionStartId;
    }

    public Db2LuwSequence getIdentityExpr() {
        return this.identityExpr;
    }

    public void setIdentityExpr(Db2LuwSequence identityExpr) {
        this.identityExpr = identityExpr;
    }
}

