/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.luw;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.MapField;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.db2.luw.AbstractDb2LuwConstraint;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xForeignKey;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

public class Db2LuwForeignKey
extends AbstractDb2LuwConstraint {
    @MapField(targetClass=ObOracle22xForeignKey.class, targetField="generated")
    private String ownerType;
    private int colCount;
    private String createTime;

    public Db2LuwForeignKey(Db2LuwSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName()));
        sb.append(" FOREIGN KEY").append((CharSequence)this.joinForeignConstraintColumns());
        sb.append(" REFERENCES ").append(this.getRefOwnerTableName());
        sb.append((CharSequence)this.joinRefConstraintColumns());
        sb.append(this.safetyMapping(DELETE_RULE_MAPPING, this.getDeleteRule()));
        sb.append(this.safetyMapping(UPDATE_RULE_MAPPING, this.getUpdateRule()));
        sb.append(this.safetyMapping(this.getEnforceMapping(), this.getEnforced()));
        sb.append(this.safetyMapping(this.getTrustMapping(), this.getTrusted()));
        sb.append(this.safetyMapping(this.getQueryOptMapping(), this.getEnableQueryOpt()));
        StringBuilder alter = new StringBuilder();
        alter.append("ALTER TABLE ").append(this.getSchemaObjectName());
        alter.append(" ADD ").append((CharSequence)sb);
        ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, sb + " -> [NULL]", alter.toString());
        return new StringBuilder(0);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof Db2LuwForeignKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public int getColCount() {
        return this.colCount;
    }

    public void setColCount(int colCount) {
        this.colCount = colCount;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }
}

