/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.luw;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Index;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwIndexPartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Db2LuwIndex
extends AbstractDb2Index {
    private String ownerType;
    private String madeUnique;
    private String uniqueColCount;
    private String entryType;
    private Integer pctFree;
    private String iid;
    private String nLeaf;
    private String nLevels;
    private String firstKeyCard;
    private String first2KeyCard;
    private String first3KeyCard;
    private String first4KeyCard;
    private String fullKeyCard;
    private String clusterRatio;
    private String clusterFactor;
    private String sequentialPages;
    private String density;
    private String userDefined;
    private String systemRequired;
    private String createTime;
    private String statsTime;
    private String pageFetchPairs;
    private Integer minPctUsed;
    private String reverseScans;
    private String internalFormat;
    private String compression;
    private String ieSchema;
    private String ieName;
    private String ieArguments;
    private String indexObjectId;
    private String numRids;
    private String numRidsDeleted;
    private String numEmptyLeafs;
    private String averageRandomFetchPages;
    private String averageRandomPages;
    private String averageSequenceGap;
    private String averageSequenceFetchGap;
    private String averageSequencePages;
    private String averageSequenceFetchPages;
    private String tbSpace;
    private Integer level2PctFree;
    private String pageSplit;
    private String avgPartitionClusterRatio;
    private String avgPartitionClusterFactor;
    private String avgPartitionPageFetchPairs;
    private String pctPagesSaved;
    private String dataPartitionClusterFactor;
    private String indCard;
    private String avgLeafKeySize;
    private String avgNleafKeySize;
    private String osPtrSize;
    private String collectStatistcs;
    private String lastUsed;
    private String periodName;
    private String periodPolicy;
    private String madeWithoutOverlaps;
    private String nullkeys;
    private String funcPath;
    private String viewSchema;
    private String viewName;
    private String envStringUnits;
    private String collationSchema;
    private String collationName;
    private String pindName;
    private String pindId;
    private String typeModel;
    private String dataType;
    private String hashed;
    private Integer length;
    private Integer scale;
    private String xmlPatternId;
    private String xmlPattern;
    private boolean tablePartitioned;
    private Db2LuwIndexPartition indexPartition;
    private final Map<String, String> pageSplitMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = -7628907154462652588L;
        {
            this.put("L", " PAGE SPLIT LOW");
            this.put("H", " PAGE SPLIT HIGH");
        }
    };
    private final Map<String, String> collectStatistcsMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 871868581512925309L;
        {
            this.put("Y", " COLLECT STATISTICS");
            this.put("S", " COLLECT SAMPLED DETAILED STATISTICS");
            this.put("D", " COLLECT UNSAMPLED DETAILED STATISTICS");
        }
    };

    public Db2LuwIndex(Db2LuwSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        sb.append(this.safetyMapping(this.getUniqueRuleMapping(), this.getUniqueness()));
        if (this.getUniqueRuleMapping().containsKey(this.getUniqueness())) {
            this.addUniqueAttribute();
        }
        String indexName = this.getSchemaIndexName();
        sb.append(" INDEX ").append(indexName).append(" ON ");
        StringBuilder indexColumns = this.joinIndexColumns();
        if (indexColumns.length() == 0) {
            ChangeUtils.warn(ObjectType.TABLE, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "CREATE INDEX " + indexName + " ... -> [NULL]");
            return new ArrayList<ObjectDefine>();
        }
        sb.append(this.getDefinitionSchemaObjectName()).append((CharSequence)indexColumns);
        sb.append((CharSequence)this.appendIndexOptions());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getIndexType(), this.getSimpleIndexName(), this.terminate(sb))});
    }

    protected StringBuilder appendIndexOptions() {
        Integer minPctUsed;
        Integer level2PctFree;
        Integer pctFree;
        String xmlPattern;
        StringBuilder sb = new StringBuilder();
        Db2LuwIndexPartition partition = this.getIndexPartition();
        if (this.isTablePartitioned()) {
            if (partition != null) {
                sb.append(" PARTITIONED");
            } else {
                sb.append(" NOT PARTITIONED");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(xmlPattern = this.getXmlPattern()))) {
            sb.append(" GENERATE KEY USING XMLPATTERN ");
            sb.append("'").append(xmlPattern).append("'");
            sb.append(" AS SQL ").append(this.getDataType());
            Integer length = this.getLength();
            if (length != null && length > 0) {
                sb.append("(").append(length);
                Integer scale = this.getScale();
                if (scale != null && scale > 0) {
                    sb.append(",").append(scale);
                }
                sb.append(")");
            }
        }
        if ("CLUS".equals(this.getIndexType())) {
            sb.append(" CLUSTER");
        }
        if ((pctFree = this.getPctFree()) != null && pctFree > 0) {
            sb.append(" PCTFREE ").append(pctFree);
        }
        if ((level2PctFree = this.getLevel2PctFree()) != null && level2PctFree > 0) {
            sb.append(" LEVEL2 PCTFREE ").append(level2PctFree);
        }
        if ((minPctUsed = this.getMinPctUsed()) != null && minPctUsed > 0) {
            sb.append(" MINPCTUSED ").append(minPctUsed);
        }
        if ("N".equals(this.getReverseScans())) {
            sb.append(" DISALLOW REVERSE SCANS");
        }
        sb.append(this.safetyMapping(this.getPageSplitMapping(), this.getPageSplit()));
        sb.append(this.safetyMapping(this.getCollectStatistcsMapping(), this.getCollectStatistcs()));
        if ("Y".equals(this.getCompression())) {
            sb.append(" COMPRESS YES");
        }
        if ("N".equals(this.getNullkeys())) {
            sb.append(" EXCLUDE NULL KEYS");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof Db2LuwIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getMadeUnique() {
        return this.madeUnique;
    }

    public void setMadeUnique(String madeUnique) {
        this.madeUnique = madeUnique;
    }

    public String getUniqueColCount() {
        return this.uniqueColCount;
    }

    public void setUniqueColCount(String uniqueColCount) {
        this.uniqueColCount = uniqueColCount;
    }

    public String getEntryType() {
        return this.entryType;
    }

    public void setEntryType(String entryType) {
        this.entryType = entryType;
    }

    public Integer getPctFree() {
        return this.pctFree;
    }

    public void setPctFree(Integer pctFree) {
        this.pctFree = pctFree;
    }

    public String getIid() {
        return this.iid;
    }

    public void setIid(String iid) {
        this.iid = iid;
    }

    public String getNLeaf() {
        return this.nLeaf;
    }

    public void setNLeaf(String nLeaf) {
        this.nLeaf = nLeaf;
    }

    public String getNLevels() {
        return this.nLevels;
    }

    public void setNLevels(String nLevels) {
        this.nLevels = nLevels;
    }

    public String getFirstKeyCard() {
        return this.firstKeyCard;
    }

    public void setFirstKeyCard(String firstKeyCard) {
        this.firstKeyCard = firstKeyCard;
    }

    public String getFirst2KeyCard() {
        return this.first2KeyCard;
    }

    public void setFirst2KeyCard(String first2KeyCard) {
        this.first2KeyCard = first2KeyCard;
    }

    public String getFirst3KeyCard() {
        return this.first3KeyCard;
    }

    public void setFirst3KeyCard(String first3KeyCard) {
        this.first3KeyCard = first3KeyCard;
    }

    public String getFirst4KeyCard() {
        return this.first4KeyCard;
    }

    public void setFirst4KeyCard(String first4KeyCard) {
        this.first4KeyCard = first4KeyCard;
    }

    public String getFullKeyCard() {
        return this.fullKeyCard;
    }

    public void setFullKeyCard(String fullKeyCard) {
        this.fullKeyCard = fullKeyCard;
    }

    public String getClusterRatio() {
        return this.clusterRatio;
    }

    public void setClusterRatio(String clusterRatio) {
        this.clusterRatio = clusterRatio;
    }

    public String getClusterFactor() {
        return this.clusterFactor;
    }

    public void setClusterFactor(String clusterFactor) {
        this.clusterFactor = clusterFactor;
    }

    public String getSequentialPages() {
        return this.sequentialPages;
    }

    public void setSequentialPages(String sequentialPages) {
        this.sequentialPages = sequentialPages;
    }

    public String getDensity() {
        return this.density;
    }

    public void setDensity(String density) {
        this.density = density;
    }

    public String getUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(String userDefined) {
        this.userDefined = userDefined;
    }

    public String getSystemRequired() {
        return this.systemRequired;
    }

    public void setSystemRequired(String systemRequired) {
        this.systemRequired = systemRequired;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getStatsTime() {
        return this.statsTime;
    }

    public void setStatsTime(String statsTime) {
        this.statsTime = statsTime;
    }

    public String getPageFetchPairs() {
        return this.pageFetchPairs;
    }

    public void setPageFetchPairs(String pageFetchPairs) {
        this.pageFetchPairs = pageFetchPairs;
    }

    public Integer getMinPctUsed() {
        return this.minPctUsed;
    }

    public void setMinPctUsed(Integer minPctUsed) {
        this.minPctUsed = minPctUsed;
    }

    public String getReverseScans() {
        return this.reverseScans;
    }

    public void setReverseScans(String reverseScans) {
        this.reverseScans = reverseScans;
    }

    public String getInternalFormat() {
        return this.internalFormat;
    }

    public void setInternalFormat(String internalFormat) {
        this.internalFormat = internalFormat;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getIeSchema() {
        return this.ieSchema;
    }

    public void setIeSchema(String ieSchema) {
        this.ieSchema = ieSchema;
    }

    public String getIeName() {
        return this.ieName;
    }

    public void setIeName(String ieName) {
        this.ieName = ieName;
    }

    public String getIeArguments() {
        return this.ieArguments;
    }

    public void setIeArguments(String ieArguments) {
        this.ieArguments = ieArguments;
    }

    public String getIndexObjectId() {
        return this.indexObjectId;
    }

    public void setIndexObjectId(String indexObjectId) {
        this.indexObjectId = indexObjectId;
    }

    public String getNumRids() {
        return this.numRids;
    }

    public void setNumRids(String numRids) {
        this.numRids = numRids;
    }

    public String getNumRidsDeleted() {
        return this.numRidsDeleted;
    }

    public void setNumRidsDeleted(String numRidsDeleted) {
        this.numRidsDeleted = numRidsDeleted;
    }

    public String getNumEmptyLeafs() {
        return this.numEmptyLeafs;
    }

    public void setNumEmptyLeafs(String numEmptyLeafs) {
        this.numEmptyLeafs = numEmptyLeafs;
    }

    public String getAverageRandomFetchPages() {
        return this.averageRandomFetchPages;
    }

    public void setAverageRandomFetchPages(String averageRandomFetchPages) {
        this.averageRandomFetchPages = averageRandomFetchPages;
    }

    public String getAverageRandomPages() {
        return this.averageRandomPages;
    }

    public void setAverageRandomPages(String averageRandomPages) {
        this.averageRandomPages = averageRandomPages;
    }

    public String getAverageSequenceGap() {
        return this.averageSequenceGap;
    }

    public void setAverageSequenceGap(String averageSequenceGap) {
        this.averageSequenceGap = averageSequenceGap;
    }

    public String getAverageSequenceFetchGap() {
        return this.averageSequenceFetchGap;
    }

    public void setAverageSequenceFetchGap(String averageSequenceFetchGap) {
        this.averageSequenceFetchGap = averageSequenceFetchGap;
    }

    public String getAverageSequencePages() {
        return this.averageSequencePages;
    }

    public void setAverageSequencePages(String averageSequencePages) {
        this.averageSequencePages = averageSequencePages;
    }

    public String getAverageSequenceFetchPages() {
        return this.averageSequenceFetchPages;
    }

    public void setAverageSequenceFetchPages(String averageSequenceFetchPages) {
        this.averageSequenceFetchPages = averageSequenceFetchPages;
    }

    public String getTbSpace() {
        return this.tbSpace;
    }

    public void setTbSpace(String tbSpace) {
        this.tbSpace = tbSpace;
    }

    public Integer getLevel2PctFree() {
        return this.level2PctFree;
    }

    public void setLevel2PctFree(Integer level2PctFree) {
        this.level2PctFree = level2PctFree;
    }

    public String getPageSplit() {
        return this.pageSplit;
    }

    public void setPageSplit(String pageSplit) {
        this.pageSplit = pageSplit;
    }

    public String getAvgPartitionClusterRatio() {
        return this.avgPartitionClusterRatio;
    }

    public void setAvgPartitionClusterRatio(String avgPartitionClusterRatio) {
        this.avgPartitionClusterRatio = avgPartitionClusterRatio;
    }

    public String getAvgPartitionClusterFactor() {
        return this.avgPartitionClusterFactor;
    }

    public void setAvgPartitionClusterFactor(String avgPartitionClusterFactor) {
        this.avgPartitionClusterFactor = avgPartitionClusterFactor;
    }

    public String getAvgPartitionPageFetchPairs() {
        return this.avgPartitionPageFetchPairs;
    }

    public void setAvgPartitionPageFetchPairs(String avgPartitionPageFetchPairs) {
        this.avgPartitionPageFetchPairs = avgPartitionPageFetchPairs;
    }

    public String getPctPagesSaved() {
        return this.pctPagesSaved;
    }

    public void setPctPagesSaved(String pctPagesSaved) {
        this.pctPagesSaved = pctPagesSaved;
    }

    public String getDataPartitionClusterFactor() {
        return this.dataPartitionClusterFactor;
    }

    public void setDataPartitionClusterFactor(String dataPartitionClusterFactor) {
        this.dataPartitionClusterFactor = dataPartitionClusterFactor;
    }

    public String getIndCard() {
        return this.indCard;
    }

    public void setIndCard(String indCard) {
        this.indCard = indCard;
    }

    public String getAvgLeafKeySize() {
        return this.avgLeafKeySize;
    }

    public void setAvgLeafKeySize(String avgLeafKeySize) {
        this.avgLeafKeySize = avgLeafKeySize;
    }

    public String getAvgNleafKeySize() {
        return this.avgNleafKeySize;
    }

    public void setAvgNleafKeySize(String avgNleafKeySize) {
        this.avgNleafKeySize = avgNleafKeySize;
    }

    public String getOsPtrSize() {
        return this.osPtrSize;
    }

    public void setOsPtrSize(String osPtrSize) {
        this.osPtrSize = osPtrSize;
    }

    public String getCollectStatistcs() {
        return this.collectStatistcs;
    }

    public void setCollectStatistcs(String collectStatistcs) {
        this.collectStatistcs = collectStatistcs;
    }

    public String getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(String lastUsed) {
        this.lastUsed = lastUsed;
    }

    public String getPeriodName() {
        return this.periodName;
    }

    public void setPeriodName(String periodName) {
        this.periodName = periodName;
    }

    public String getPeriodPolicy() {
        return this.periodPolicy;
    }

    public void setPeriodPolicy(String periodPolicy) {
        this.periodPolicy = periodPolicy;
    }

    public String getMadeWithoutOverlaps() {
        return this.madeWithoutOverlaps;
    }

    public void setMadeWithoutOverlaps(String madeWithoutOverlaps) {
        this.madeWithoutOverlaps = madeWithoutOverlaps;
    }

    public String getNullkeys() {
        return this.nullkeys;
    }

    public void setNullkeys(String nullkeys) {
        this.nullkeys = nullkeys;
    }

    public String getFuncPath() {
        return this.funcPath;
    }

    public void setFuncPath(String funcPath) {
        this.funcPath = funcPath;
    }

    public String getViewSchema() {
        return this.viewSchema;
    }

    public void setViewSchema(String viewSchema) {
        this.viewSchema = viewSchema;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getEnvStringUnits() {
        return this.envStringUnits;
    }

    public void setEnvStringUnits(String envStringUnits) {
        this.envStringUnits = envStringUnits;
    }

    public String getCollationSchema() {
        return this.collationSchema;
    }

    public void setCollationSchema(String collationSchema) {
        this.collationSchema = collationSchema;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public String getPindName() {
        return this.pindName;
    }

    public void setPindName(String pindName) {
        this.pindName = pindName;
    }

    public String getPindId() {
        return this.pindId;
    }

    public void setPindId(String pindId) {
        this.pindId = pindId;
    }

    public String getTypeModel() {
        return this.typeModel;
    }

    public void setTypeModel(String typeModel) {
        this.typeModel = typeModel;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getHashed() {
        return this.hashed;
    }

    public void setHashed(String hashed) {
        this.hashed = hashed;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public String getXmlPatternId() {
        return this.xmlPatternId;
    }

    public void setXmlPatternId(String xmlPatternId) {
        this.xmlPatternId = xmlPatternId;
    }

    public String getXmlPattern() {
        return this.xmlPattern;
    }

    public void setXmlPattern(String xmlPattern) {
        this.xmlPattern = xmlPattern;
    }

    public boolean isTablePartitioned() {
        return this.tablePartitioned;
    }

    public void setTablePartitioned(boolean tablePartitioned) {
        this.tablePartitioned = tablePartitioned;
    }

    public Db2LuwIndexPartition getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(Db2LuwIndexPartition indexPartition) {
        this.indexPartition = indexPartition;
    }

    public Map<String, String> getPageSplitMapping() {
        return this.pageSplitMapping;
    }

    public Map<String, String> getCollectStatistcsMapping() {
        return this.collectStatistcsMapping;
    }
}

