/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.luw;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;

public class Db2LuwSchema
extends AbstractSchema {
    private String owner;
    private String ownerType;
    private String definer;
    private String definerType;
    private String createTime;
    private String remarks;

    public Db2LuwSchema(Global global, DbType dbType, String schemaName) {
        super(global, dbType, schemaName);
    }

    public Db2LuwSchema(Global global, DbType dbType, String catalogName, String schemaName) {
        super(global, dbType, catalogName, schemaName);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE SCHEMA ").append(this.getSchemaName());
        String owner = this.getOwner();
        if (StringUtils.isNotBlank((CharSequence)owner)) {
            sb.append(" AUTHORIZATION ").append(owner);
        }
        return sb;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getDefiner() {
        return this.definer;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public String getDefinerType() {
        return this.definerType;
    }

    public void setDefinerType(String definerType) {
        this.definerType = definerType;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
}

