/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.luw;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Sequence;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import java.math.BigDecimal;
import java.util.List;

public class Db2LuwSequence
extends AbstractDb2Sequence {
    private static final BigDecimal MAX_VALUE = new BigDecimal("999999999999999999999999999");
    private String definer;
    private String definerType;
    private String owner;
    private String ownerType;
    private int seqId;
    private String seqType;
    private String baseSeqSchema;
    private String baseSeqName;
    private BigDecimal nextCacheFirstValue;
    private String sourceTypeId;
    private String createTime;
    private String alterTime;
    private String precision;
    private String origin;
    private String remarks;

    public Db2LuwSequence(Db2LuwSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE SEQUENCE ").append(this.getSchemaObjectName());
        if (StringUtils.isNotBlank((CharSequence)this.getDataType())) {
            sb.append(" AS ").append(this.getDataType());
        }
        sb.append((CharSequence)super.buildSequenceGrammar());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractSequence other) {
        if (!(other instanceof Db2LuwSequence)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    @Override
    public BigDecimal getMaxValue() {
        BigDecimal maxValue = super.getMaxValue();
        if (maxValue != null && maxValue.compareTo(MAX_VALUE) > -1) {
            return MAX_VALUE;
        }
        return maxValue;
    }

    public String getDefiner() {
        return this.definer;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public String getDefinerType() {
        return this.definerType;
    }

    public void setDefinerType(String definerType) {
        this.definerType = definerType;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public int getSeqId() {
        return this.seqId;
    }

    public void setSeqId(int seqId) {
        this.seqId = seqId;
    }

    public String getSeqType() {
        return this.seqType;
    }

    public void setSeqType(String seqType) {
        this.seqType = seqType;
    }

    public String getBaseSeqSchema() {
        return this.baseSeqSchema;
    }

    public void setBaseSeqSchema(String baseSeqSchema) {
        this.baseSeqSchema = baseSeqSchema;
    }

    public String getBaseSeqName() {
        return this.baseSeqName;
    }

    public void setBaseSeqName(String baseSeqName) {
        this.baseSeqName = baseSeqName;
    }

    public BigDecimal getNextCacheFirstValue() {
        return this.nextCacheFirstValue;
    }

    public void setNextCacheFirstValue(BigDecimal nextCacheFirstValue) {
        this.nextCacheFirstValue = nextCacheFirstValue;
    }

    public String getSourceTypeId() {
        return this.sourceTypeId;
    }

    public void setSourceTypeId(String sourceTypeId) {
        this.sourceTypeId = sourceTypeId;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getAlterTime() {
        return this.alterTime;
    }

    public void setAlterTime(String alterTime) {
        this.alterTime = alterTime;
    }

    public String getPrecision() {
        return this.precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
}

