/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.luw;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.MapField;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Table;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwCheck;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwColumn;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwForeignKey;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwIndex;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwTablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwUniqueKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTable;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Db2LuwTable
extends AbstractDb2Table {
    private final Map<String, Db2LuwColumn> columnMapping = new LinkedHashMap<String, Db2LuwColumn>();
    private final Map<String, Db2LuwIndex> indexMapping = new LinkedHashMap<String, Db2LuwIndex>();
    private final Map<String, Db2LuwCheck> checkMapping = new LinkedHashMap<String, Db2LuwCheck>();
    private final Map<String, Db2LuwUniqueKey> uniqueMapping = new LinkedHashMap<String, Db2LuwUniqueKey>();
    private final Map<String, Db2LuwForeignKey> foreignMapping = new LinkedHashMap<String, Db2LuwForeignKey>();
    private final LinkedHashSet<String> dimensionColumns = new LinkedHashSet();
    private final Map<String, String> organizeMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 5328807737961460397L;
        {
            this.put("R", "ORGANIZE BY ROW");
            this.put("C", "ORGANIZE BY COLUMN");
        }
    };
    private String ownerType;
    private String status;
    private String rowTypeSchema;
    private String rowTypeName;
    private String createTime;
    private String alterTime;
    private String invalidateTime;
    private String statsTime;
    private int tableId;
    private String tbSpaceId;
    private String card;
    private String npages;
    private String fpages;
    private String overflow;
    @MapField(targetClass=ObOracle22xTable.class, targetField="tablespaceName")
    private String tbSpace;
    private String indexTbSpace;
    private String longTbSpace;
    private int parents;
    private int children;
    private int selfRefs;
    private Integer keyColumns;
    private Integer keyIndexId;
    private Integer keyUnique;
    private Integer checkCount;
    private String dataCapture;
    private String constChecked;
    private int pmapId;
    private String partitionMode;
    private int pctFree;
    private String appendMode;
    private String lockSize;
    private String volatiled;
    private String rowFormat;
    private String property;
    private String statisticsProfile;
    private String compression;
    private String rowCompMode;
    private String accessMode;
    private String clustered;
    private String activeBlocks;
    private String dropRule;
    private String maxFreeSpaceSearch;
    private String avgCompressedRowSize;
    private String avgRowCompressionRatio;
    private String avgRowSize;
    private String pctRowsCompressed;
    private String logIndexBuild;
    private String codePage;
    private String collationSchema;
    private String collationName;
    private String collationSchemaOrderBy;
    private String collationNameOrderBy;
    private String encodingScheme;
    private String pctPagesSaved;
    private String lastRegenTime;
    private String secPolicyId;
    private String protectionGranularity;
    private String auditPolicyId;
    private String auditPolicyName;
    private String onCommit;
    private String logged;
    private String onRollback;
    private String lastUsed;
    private String control;
    private String temporalType;
    private String tableOrg;
    private String extendedRowSize;
    private String pctExtendedRows;
    private Db2LuwPrimaryKey primaryKey;
    private Db2LuwTablePartition tablePartition;

    public Db2LuwTable(Db2LuwSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        if (StringUtils.isNotBlank((CharSequence)this.getPartitionMode())) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The distribution is unsupported");
        }
        StringBuilder sb = new StringBuilder();
        String objectName = this.getDefinitionSchemaObjectName();
        sb.append("CREATE TABLE ").append(objectName).append(" (");
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        String tableComment = this.getTableComment();
        if (StringUtils.isNotBlank((CharSequence)tableComment)) {
            tableComment = String.format("COMMENT ON TABLE %s IS '%s'", objectName, tableComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, objectName, this.terminate(tableComment)));
        }
        Collection<Db2LuwColumn> columns = this.getColumnMapping().values();
        Iterator<Db2LuwColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            String colComment;
            Iterator<AbstractOwnership> col = iter.next();
            sb.append("\n\t").append((CharSequence)((Db2LuwColumn)((Object)col)).buildGrammar());
            if (iter.hasNext()) {
                sb.append(",");
            }
            if (!StringUtils.isNotBlank((CharSequence)(colComment = ((AbstractColumn)((Object)col)).getColumnComment()))) continue;
            String wrappedName = ((AbstractColumn)((Object)col)).getWrappedName();
            colComment = String.format("COMMENT ON COLUMN %s.%s IS '%s'", objectName, wrappedName, colComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, wrappedName, this.terminate(colComment)));
        }
        Db2LuwPrimaryKey primaryKey = this.getPrimaryKey();
        if (primaryKey != null) {
            sb.append(",").append("\n\t").append((CharSequence)primaryKey.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (Db2LuwUniqueKey uniqueKey : this.getUniqueMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)uniqueKey.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (Db2LuwForeignKey foreignKey : this.getForeignMapping().values()) {
                StringBuilder grammar = foreignKey.buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (Db2LuwCheck check : this.getCheckMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)check.buildGrammar());
            }
        }
        sb.append("\n").append(")").append((CharSequence)this.appendTableOptions());
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            for (Db2LuwIndex index : this.getIndexMapping().values()) {
                index.setTablePartitioned(this.getTablePartition() != null);
                subDefines.addAll(index.buildDefinition());
            }
        }
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines);
        objectDefine.getChangeInfos().addAll(ChangeUtils.findByKey(ObjectType.TABLE, this.getSchemaObjectName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    protected StringBuilder appendTableOptions() throws UnsupportedGrammarException {
        String ecnodingSchema;
        String compression;
        Db2LuwTablePartition tablePartition;
        String longTbSpace;
        String indexTbSpace;
        String tbSpace;
        StringBuilder sb = new StringBuilder("");
        String clustered = this.getClustered();
        if ("T".equals(clustered)) {
            sb.append("\n").append("ORGANIZE BY INSERT TIME");
        } else if ("Y".equals(clustered)) {
            sb.append("\n").append("ORGANIZE BY DIMENSIONS (");
            sb.append(this.getDimensionColumns().stream().map(e -> this.wrap((String)e)).collect(Collectors.joining(",")));
            sb.append(")");
        } else {
            sb.append(this.safetyMapping(this.getOrganizeMapping(), this.getTableOrg()));
        }
        String dataCapture = this.getDataCapture();
        if (StringUtils.isNotBlank((CharSequence)dataCapture) && !"N".equals(dataCapture)) {
            sb.append("\n").append("DATA CAPTURE CHANGES");
        }
        if (StringUtils.isNotBlank((CharSequence)(tbSpace = this.getTbSpace()))) {
            sb.append("\n").append("IN ").append(this.wrap(tbSpace));
        }
        if (StringUtils.isNotBlank((CharSequence)(indexTbSpace = this.getIndexTbSpace()))) {
            sb.append("\n").append("INDEX IN ").append(this.wrap(indexTbSpace));
        }
        if (StringUtils.isNotBlank((CharSequence)(longTbSpace = this.getLongTbSpace()))) {
            sb.append("\n").append("LONG IN ").append(this.wrap(longTbSpace));
        }
        if ((tablePartition = this.getTablePartition()) != null) {
            sb.append((CharSequence)tablePartition.buildGrammar());
        }
        if (StringUtils.isNotBlank((CharSequence)(compression = this.getCompression()))) {
            String rowComMode;
            if ("R".equals(compression) || "B".equals(compression)) {
                sb.append("\n").append("COMPRESS YES");
            }
            if ("S".equals(rowComMode = this.getRowCompMode())) {
                sb.append(" STATIC");
            }
            if ("A".equals(rowComMode)) {
                sb.append(" ADAPTIVE");
            }
            if ("V".equals(compression)) {
                sb.append(" VALUE COMPRESSION");
            }
        }
        if ("R".equals(this.getDropRule())) {
            sb.append("\n").append("WITH RESTRICT ON DROP");
        }
        if ("A".equals(ecnodingSchema = this.getEncodingScheme())) {
            sb.append("\n").append("CCSID ASCII");
        } else if ("U".equals(ecnodingSchema)) {
            sb.append("\n").append("CCSID UNICODE");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof Db2LuwTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Map<String, Db2LuwColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, Db2LuwIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, Db2LuwCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public Map<String, Db2LuwUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, Db2LuwForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public LinkedHashSet<String> getDimensionColumns() {
        return this.dimensionColumns;
    }

    public Map<String, String> getOrganizeMapping() {
        return this.organizeMapping;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRowTypeSchema() {
        return this.rowTypeSchema;
    }

    public void setRowTypeSchema(String rowTypeSchema) {
        this.rowTypeSchema = rowTypeSchema;
    }

    public String getRowTypeName() {
        return this.rowTypeName;
    }

    public void setRowTypeName(String rowTypeName) {
        this.rowTypeName = rowTypeName;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getAlterTime() {
        return this.alterTime;
    }

    public void setAlterTime(String alterTime) {
        this.alterTime = alterTime;
    }

    public String getInvalidateTime() {
        return this.invalidateTime;
    }

    public void setInvalidateTime(String invalidateTime) {
        this.invalidateTime = invalidateTime;
    }

    public String getStatsTime() {
        return this.statsTime;
    }

    public void setStatsTime(String statsTime) {
        this.statsTime = statsTime;
    }

    public int getTableId() {
        return this.tableId;
    }

    public void setTableId(int tableId) {
        this.tableId = tableId;
    }

    public String getTbSpaceId() {
        return this.tbSpaceId;
    }

    public void setTbSpaceId(String tbSpaceId) {
        this.tbSpaceId = tbSpaceId;
    }

    public String getCard() {
        return this.card;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public String getNpages() {
        return this.npages;
    }

    public void setNpages(String npages) {
        this.npages = npages;
    }

    public String getFpages() {
        return this.fpages;
    }

    public void setFpages(String fpages) {
        this.fpages = fpages;
    }

    public String getOverflow() {
        return this.overflow;
    }

    public void setOverflow(String overflow) {
        this.overflow = overflow;
    }

    public String getTbSpace() {
        return this.tbSpace;
    }

    public void setTbSpace(String tbSpace) {
        this.tbSpace = tbSpace;
    }

    public String getIndexTbSpace() {
        return this.indexTbSpace;
    }

    public void setIndexTbSpace(String indexTbSpace) {
        this.indexTbSpace = indexTbSpace;
    }

    public String getLongTbSpace() {
        return this.longTbSpace;
    }

    public void setLongTbSpace(String longTbSpace) {
        this.longTbSpace = longTbSpace;
    }

    public int getParents() {
        return this.parents;
    }

    public void setParents(int parents) {
        this.parents = parents;
    }

    public int getChildren() {
        return this.children;
    }

    public void setChildren(int children) {
        this.children = children;
    }

    public int getSelfRefs() {
        return this.selfRefs;
    }

    public void setSelfRefs(int selfRefs) {
        this.selfRefs = selfRefs;
    }

    public Integer getKeyColumns() {
        return this.keyColumns;
    }

    public void setKeyColumns(Integer keyColumns) {
        this.keyColumns = keyColumns;
    }

    public Integer getKeyIndexId() {
        return this.keyIndexId;
    }

    public void setKeyIndexId(Integer keyIndexId) {
        this.keyIndexId = keyIndexId;
    }

    public Integer getKeyUnique() {
        return this.keyUnique;
    }

    public void setKeyUnique(Integer keyUnique) {
        this.keyUnique = keyUnique;
    }

    public Integer getCheckCount() {
        return this.checkCount;
    }

    public void setCheckCount(Integer checkCount) {
        this.checkCount = checkCount;
    }

    public String getDataCapture() {
        return this.dataCapture;
    }

    public void setDataCapture(String dataCapture) {
        this.dataCapture = dataCapture;
    }

    public String getConstChecked() {
        return this.constChecked;
    }

    public void setConstChecked(String constChecked) {
        this.constChecked = constChecked;
    }

    public int getPmapId() {
        return this.pmapId;
    }

    public void setPmapId(int pmapId) {
        this.pmapId = pmapId;
    }

    public String getPartitionMode() {
        return this.partitionMode;
    }

    public void setPartitionMode(String partitionMode) {
        this.partitionMode = partitionMode;
    }

    public int getPctFree() {
        return this.pctFree;
    }

    public void setPctFree(int pctFree) {
        this.pctFree = pctFree;
    }

    public String getAppendMode() {
        return this.appendMode;
    }

    public void setAppendMode(String appendMode) {
        this.appendMode = appendMode;
    }

    public String getLockSize() {
        return this.lockSize;
    }

    public void setLockSize(String lockSize) {
        this.lockSize = lockSize;
    }

    public String getVolatiled() {
        return this.volatiled;
    }

    public void setVolatiled(String volatiled) {
        this.volatiled = volatiled;
    }

    public String getRowFormat() {
        return this.rowFormat;
    }

    public void setRowFormat(String rowFormat) {
        this.rowFormat = rowFormat;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getStatisticsProfile() {
        return this.statisticsProfile;
    }

    public void setStatisticsProfile(String statisticsProfile) {
        this.statisticsProfile = statisticsProfile;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getRowCompMode() {
        return this.rowCompMode;
    }

    public void setRowCompMode(String rowCompMode) {
        this.rowCompMode = rowCompMode;
    }

    public String getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(String accessMode) {
        this.accessMode = accessMode;
    }

    public String getClustered() {
        return this.clustered;
    }

    public void setClustered(String clustered) {
        this.clustered = clustered;
    }

    public String getActiveBlocks() {
        return this.activeBlocks;
    }

    public void setActiveBlocks(String activeBlocks) {
        this.activeBlocks = activeBlocks;
    }

    public String getDropRule() {
        return this.dropRule;
    }

    public void setDropRule(String dropRule) {
        this.dropRule = dropRule;
    }

    public String getMaxFreeSpaceSearch() {
        return this.maxFreeSpaceSearch;
    }

    public void setMaxFreeSpaceSearch(String maxFreeSpaceSearch) {
        this.maxFreeSpaceSearch = maxFreeSpaceSearch;
    }

    public String getAvgCompressedRowSize() {
        return this.avgCompressedRowSize;
    }

    public void setAvgCompressedRowSize(String avgCompressedRowSize) {
        this.avgCompressedRowSize = avgCompressedRowSize;
    }

    public String getAvgRowCompressionRatio() {
        return this.avgRowCompressionRatio;
    }

    public void setAvgRowCompressionRatio(String avgRowCompressionRatio) {
        this.avgRowCompressionRatio = avgRowCompressionRatio;
    }

    public String getAvgRowSize() {
        return this.avgRowSize;
    }

    public void setAvgRowSize(String avgRowSize) {
        this.avgRowSize = avgRowSize;
    }

    public String getPctRowsCompressed() {
        return this.pctRowsCompressed;
    }

    public void setPctRowsCompressed(String pctRowsCompressed) {
        this.pctRowsCompressed = pctRowsCompressed;
    }

    public String getLogIndexBuild() {
        return this.logIndexBuild;
    }

    public void setLogIndexBuild(String logIndexBuild) {
        this.logIndexBuild = logIndexBuild;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public void setCodePage(String codePage) {
        this.codePage = codePage;
    }

    public String getCollationSchema() {
        return this.collationSchema;
    }

    public void setCollationSchema(String collationSchema) {
        this.collationSchema = collationSchema;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public String getCollationSchemaOrderBy() {
        return this.collationSchemaOrderBy;
    }

    public void setCollationSchemaOrderBy(String collationSchemaOrderBy) {
        this.collationSchemaOrderBy = collationSchemaOrderBy;
    }

    public String getCollationNameOrderBy() {
        return this.collationNameOrderBy;
    }

    public void setCollationNameOrderBy(String collationNameOrderBy) {
        this.collationNameOrderBy = collationNameOrderBy;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public String getPctPagesSaved() {
        return this.pctPagesSaved;
    }

    public void setPctPagesSaved(String pctPagesSaved) {
        this.pctPagesSaved = pctPagesSaved;
    }

    public String getLastRegenTime() {
        return this.lastRegenTime;
    }

    public void setLastRegenTime(String lastRegenTime) {
        this.lastRegenTime = lastRegenTime;
    }

    public String getSecPolicyId() {
        return this.secPolicyId;
    }

    public void setSecPolicyId(String secPolicyId) {
        this.secPolicyId = secPolicyId;
    }

    public String getProtectionGranularity() {
        return this.protectionGranularity;
    }

    public void setProtectionGranularity(String protectionGranularity) {
        this.protectionGranularity = protectionGranularity;
    }

    public String getAuditPolicyId() {
        return this.auditPolicyId;
    }

    public void setAuditPolicyId(String auditPolicyId) {
        this.auditPolicyId = auditPolicyId;
    }

    public String getAuditPolicyName() {
        return this.auditPolicyName;
    }

    public void setAuditPolicyName(String auditPolicyName) {
        this.auditPolicyName = auditPolicyName;
    }

    public String getOnCommit() {
        return this.onCommit;
    }

    public void setOnCommit(String onCommit) {
        this.onCommit = onCommit;
    }

    public String getLogged() {
        return this.logged;
    }

    public void setLogged(String logged) {
        this.logged = logged;
    }

    public String getOnRollback() {
        return this.onRollback;
    }

    public void setOnRollback(String onRollback) {
        this.onRollback = onRollback;
    }

    public String getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(String lastUsed) {
        this.lastUsed = lastUsed;
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        this.control = control;
    }

    public String getTemporalType() {
        return this.temporalType;
    }

    public void setTemporalType(String temporalType) {
        this.temporalType = temporalType;
    }

    public String getTableOrg() {
        return this.tableOrg;
    }

    public void setTableOrg(String tableOrg) {
        this.tableOrg = tableOrg;
    }

    public String getExtendedRowSize() {
        return this.extendedRowSize;
    }

    public void setExtendedRowSize(String extendedRowSize) {
        this.extendedRowSize = extendedRowSize;
    }

    public String getPctExtendedRows() {
        return this.pctExtendedRows;
    }

    public void setPctExtendedRows(String pctExtendedRows) {
        this.pctExtendedRows = pctExtendedRows;
    }

    public Db2LuwPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Db2LuwPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Db2LuwTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(Db2LuwTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

