/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.luw;

import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class Db2LuwTablePartition
extends AbstractDb2TablePartition {
    private String dataPartitionId;
    private String tbSpaceId;
    private String partitionObjectId;
    private String longTbSpaceId;
    private String accessMode;
    private String status;
    private String card;
    private String overFlow;
    private String nPages;
    private String fPages;
    private String activeBlocks;
    private String indexTbspaceId;
    private String avgRowSize;
    private String pctRowsCompressed;
    private String pctPageSaved;
    private String avgCompressedRowSize;
    private String avgRowCompressionRatio;
    private String statsTime;
    private String lastUsed;
    private final Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> partitionColumns = new LinkedHashSet<AbstractDb2TablePartition.Db2TablePartitionColumn>();

    public Db2LuwTablePartition(Db2LuwSchema schema) {
        super(schema);
        this.setPartitionType("RANGE");
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PARTITION BY RANGE");
        sb.append(" (");
        Iterator<Object> iter = this.getPartitionColumns().iterator();
        while (iter.hasNext()) {
            AbstractDb2TablePartition.Db2TablePartitionColumn col = iter.next();
            sb.append(this.wrap(col.getPartitionExpression()));
            if ("Y".equals(col.getNullsFirst())) {
                sb.append(" NULLS FIRST");
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        sb.append("\n").append("(");
        iter = this.getPartitionItems().iterator();
        while (iter.hasNext()) {
            AbstractDb2TablePartition.Db2TablePartitionItem item = (AbstractDb2TablePartition.Db2TablePartitionItem)iter.next();
            sb.append("\n\t");
            sb.append("PARTITION ").append(this.wrap(item.getPartitionName()));
            sb.append(" STARTING").append((CharSequence)this.enclose(item.getLowValue()));
            if ("Y".equals(item.getLowInclusive())) {
                sb.append(" INCLUSIVE");
            } else {
                sb.append(" EXCLUSIVE");
            }
            sb.append(" ENDING").append((CharSequence)this.enclose(item.getHighValue()));
            if ("Y".equals(item.getHighInclusive())) {
                sb.append(" INCLUSIVE");
            } else {
                sb.append(" EXCLUSIVE");
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof Db2LuwTablePartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getDataPartitionId() {
        return this.dataPartitionId;
    }

    public void setDataPartitionId(String dataPartitionId) {
        this.dataPartitionId = dataPartitionId;
    }

    public String getTbSpaceId() {
        return this.tbSpaceId;
    }

    public void setTbSpaceId(String tbSpaceId) {
        this.tbSpaceId = tbSpaceId;
    }

    public String getPartitionObjectId() {
        return this.partitionObjectId;
    }

    public void setPartitionObjectId(String partitionObjectId) {
        this.partitionObjectId = partitionObjectId;
    }

    public String getLongTbSpaceId() {
        return this.longTbSpaceId;
    }

    public void setLongTbSpaceId(String longTbSpaceId) {
        this.longTbSpaceId = longTbSpaceId;
    }

    public String getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(String accessMode) {
        this.accessMode = accessMode;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCard() {
        return this.card;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public String getOverFlow() {
        return this.overFlow;
    }

    public void setOverFlow(String overFlow) {
        this.overFlow = overFlow;
    }

    public String getNPages() {
        return this.nPages;
    }

    public void setNPages(String nPages) {
        this.nPages = nPages;
    }

    public String getFPages() {
        return this.fPages;
    }

    public void setFPages(String fPages) {
        this.fPages = fPages;
    }

    public String getActiveBlocks() {
        return this.activeBlocks;
    }

    public void setActiveBlocks(String activeBlocks) {
        this.activeBlocks = activeBlocks;
    }

    public String getIndexTbspaceId() {
        return this.indexTbspaceId;
    }

    public void setIndexTbspaceId(String indexTbspaceId) {
        this.indexTbspaceId = indexTbspaceId;
    }

    public String getAvgRowSize() {
        return this.avgRowSize;
    }

    public void setAvgRowSize(String avgRowSize) {
        this.avgRowSize = avgRowSize;
    }

    public String getPctRowsCompressed() {
        return this.pctRowsCompressed;
    }

    public void setPctRowsCompressed(String pctRowsCompressed) {
        this.pctRowsCompressed = pctRowsCompressed;
    }

    public String getPctPageSaved() {
        return this.pctPageSaved;
    }

    public void setPctPageSaved(String pctPageSaved) {
        this.pctPageSaved = pctPageSaved;
    }

    public String getAvgCompressedRowSize() {
        return this.avgCompressedRowSize;
    }

    public void setAvgCompressedRowSize(String avgCompressedRowSize) {
        this.avgCompressedRowSize = avgCompressedRowSize;
    }

    public String getAvgRowCompressionRatio() {
        return this.avgRowCompressionRatio;
    }

    public void setAvgRowCompressionRatio(String avgRowCompressionRatio) {
        this.avgRowCompressionRatio = avgRowCompressionRatio;
    }

    public String getStatsTime() {
        return this.statsTime;
    }

    public void setStatsTime(String statsTime) {
        this.statsTime = statsTime;
    }

    public String getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(String lastUsed) {
        this.lastUsed = lastUsed;
    }

    public Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> getPartitionColumns() {
        return this.partitionColumns;
    }
}

