/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.luw;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablespace;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Tablespace;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import java.util.List;

public class Db2LuwTablespace
extends AbstractDb2Tablespace {
    private String owner;
    private String ownerType;
    private String createTime;
    private int tbSpaceId;
    private String tbSpaceType;
    private String dataType;
    private long extentSize;
    private long prefetchSize;
    private double overhead;
    private double transferRate;
    private String writeOverhead;
    private String writeTransferRate;
    private long pageSize;
    private String dbPgName;
    private int bufferPoolId;
    private String dropRecovery;
    private String ngName;
    private String definer;
    private int dataTag;
    private String sgName;
    private String sgId;
    private String effectivePrefetchSize;
    private String cachingTier;
    private String remarks;

    public Db2LuwTablespace(Db2LuwSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        long prefetchSize;
        String tbSpaceType;
        long pageSize;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        String dataType = this.getDataType();
        if ("A".equals(dataType)) {
            sb.append(" REGULAR");
        } else if ("L".equals(dataType)) {
            sb.append(" LARGE");
        } else if ("T".equals(dataType)) {
            sb.append(" SYSTEM TEMPORARY");
        } else if ("U".equals(dataType)) {
            sb.append(" USER TEMPORARY");
        }
        String objectName = this.getObjectName();
        sb.append(" TABLESPACE ").append(objectName);
        String dbPgName = this.getDbPgName();
        if (StringUtils.isNotBlank((CharSequence)dbPgName)) {
            sb.append("\n").append("IN DATABASE PARTITION GROUP ").append(dbPgName);
        }
        if ((pageSize = this.getPageSize()) > 0L) {
            sb.append("\n").append("PAGESIZE ").append(pageSize);
        }
        if ("D".equals(tbSpaceType = this.getTbSpaceType())) {
            sb.append("\n").append("MANAGED BY DATABASE");
        } else if ("S".equals(tbSpaceType)) {
            sb.append("\n").append("MANAGED BY SYSTEM");
        } else {
            sb.append("\n").append("MANAGED BY AUTOMATIC STORAGE");
            String sgName = this.getSgName();
            if (StringUtils.isNotBlank((CharSequence)sgName)) {
                sb.append(" USING STOGROUP ").append(sgName);
            }
        }
        long extentSize = this.getExtentSize();
        if (extentSize > 0L) {
            sb.append("\n").append("EXTENTSIZE ").append(extentSize);
        }
        if ((prefetchSize = this.getPrefetchSize()) == -1L) {
            sb.append("\n").append("AUTOMATIC");
        } else if (prefetchSize > 0L) {
            sb.append("\n").append("PREFETCHSIZE ").append(prefetchSize);
        }
        double overhead = this.getOverhead();
        if (overhead == -1.0) {
            sb.append("\n").append("OVERHEAD INHERIT");
        } else if (overhead > 0.0) {
            sb.append("\n").append("OVERHEAD ").append(overhead);
        }
        double transferRate = this.getTransferRate();
        if (transferRate == -1.0) {
            sb.append("\n").append("TRANSFERRATE INHERIT");
        } else if (transferRate == 0.0) {
            sb.append("\n").append("TRANSFERRATE OFF");
        } else if (transferRate > 0.0) {
            sb.append("\n").append("TRANSFERRATE ").append(transferRate);
        }
        int dataTag = this.getDataTag();
        if (dataTag == 0) {
            sb.append("\n").append("DATA TAG NONE");
        } else if (dataTag == -1) {
            sb.append("\n").append("DATA TAG INHERIT");
        } else if (dataTag > 0) {
            sb.append("\n").append("DATA TAG ").append(dataTag);
        }
        String dropRecovery = this.getDropRecovery();
        if ("Y".equals(dropRecovery)) {
            sb.append("\n").append("DROPPED TABLE RECOVERY ON");
        } else if ("N".equals(dropRecovery)) {
            sb.append("\n").append("DROPPED TABLE RECOVERY OFF");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLESPACE, objectName, this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablespace other) {
        if (!(other instanceof Db2LuwTablespace)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public int getTbSpaceId() {
        return this.tbSpaceId;
    }

    public void setTbSpaceId(int tbSpaceId) {
        this.tbSpaceId = tbSpaceId;
    }

    public String getTbSpaceType() {
        return this.tbSpaceType;
    }

    public void setTbSpaceType(String tbSpaceType) {
        this.tbSpaceType = tbSpaceType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public long getExtentSize() {
        return this.extentSize;
    }

    public void setExtentSize(long extentSize) {
        this.extentSize = extentSize;
    }

    public long getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(long prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public double getOverhead() {
        return this.overhead;
    }

    public void setOverhead(double overhead) {
        this.overhead = overhead;
    }

    public double getTransferRate() {
        return this.transferRate;
    }

    public void setTransferRate(double transferRate) {
        this.transferRate = transferRate;
    }

    public String getWriteOverhead() {
        return this.writeOverhead;
    }

    public void setWriteOverhead(String writeOverhead) {
        this.writeOverhead = writeOverhead;
    }

    public String getWriteTransferRate() {
        return this.writeTransferRate;
    }

    public void setWriteTransferRate(String writeTransferRate) {
        this.writeTransferRate = writeTransferRate;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public String getDbPgName() {
        return this.dbPgName;
    }

    public void setDbPgName(String dbPgName) {
        this.dbPgName = dbPgName;
    }

    public int getBufferPoolId() {
        return this.bufferPoolId;
    }

    public void setBufferPoolId(int bufferPoolId) {
        this.bufferPoolId = bufferPoolId;
    }

    public String getDropRecovery() {
        return this.dropRecovery;
    }

    public void setDropRecovery(String dropRecovery) {
        this.dropRecovery = dropRecovery;
    }

    public String getNgName() {
        return this.ngName;
    }

    public void setNgName(String ngName) {
        this.ngName = ngName;
    }

    public String getDefiner() {
        return this.definer;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public int getDataTag() {
        return this.dataTag;
    }

    public void setDataTag(int dataTag) {
        this.dataTag = dataTag;
    }

    public String getSgName() {
        return this.sgName;
    }

    public void setSgName(String sgName) {
        this.sgName = sgName;
    }

    public String getSgId() {
        return this.sgId;
    }

    public void setSgId(String sgId) {
        this.sgId = sgId;
    }

    public String getEffectivePrefetchSize() {
        return this.effectivePrefetchSize;
    }

    public void setEffectivePrefetchSize(String effectivePrefetchSize) {
        this.effectivePrefetchSize = effectivePrefetchSize;
    }

    public String getCachingTier() {
        return this.cachingTier;
    }

    public void setCachingTier(String cachingTier) {
        this.cachingTier = cachingTier;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
}

