/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSynonym;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Alias;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import java.util.List;

public class Db2ZosAlias
extends AbstractDb2Alias {
    public Db2ZosAlias(Db2ZosSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE ALIAS ").append(this.getSchemaObjectName());
        sb.append(" FOR ");
        if (StringUtils.isNotBlank((CharSequence)this.getTableOwner())) {
            sb.append(this.wrap(this.getTableOwner())).append(".");
        }
        sb.append(this.wrap(this.getTableName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.ALIAS, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractSynonym other) {
        if (!(other instanceof Db2ZosAlias)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

