/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Column;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSequence;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Db2ZosColumn
extends AbstractDb2Column {
    private final Map<String, String> subtypeMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = -3523914600755663534L;
        {
            this.put("B", " FOR BIT DATA");
            this.put("S", " FOR SBCS DATA");
            this.put("M", " FOR MIXED DATA");
        }
    };
    @Deprecated
    private int colCard;
    private String high2Key;
    private String low2Key;
    private String updates;
    private String ibmreqd;
    private String remarks;
    private String defaultType;
    private int keySeq;
    private String foreignKey;
    private String fldProc;
    private String label;
    private Timestamp statsTime;
    private BigDecimal colCardf;
    private String colStatus;
    private int length2;
    private int dataTypeId;
    private int sourceTypeId;
    private String typeSchema;
    private String typeName;
    private Timestamp createdTs;
    private String statsFormat;
    private int partKeyColSeq;
    private String partKeyOrdering;
    private Timestamp alteredTs;
    private int ccsid;
    private String relCreated;
    private int controlId;
    private int xmlTypeModId;
    private String period;
    private String generatedAttr;
    private int hashKeyColSeq;
    private Db2ZosSequence identityExpr;

    public Db2ZosColumn(Db2ZosSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String defaultType;
        String dataType = this.getDataType();
        if (dataType == null) {
            throw new IllegalArgumentException("DataType is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGrammarColumnName()).append(" ").append(dataType);
        Long length = this.getDataLength();
        Integer scale = this.getDataScale();
        switch (dataType) {
            case "BLOB": 
            case "CLOB": 
            case "NCLOB": 
            case "DBCLOB": {
                if (length == null || length <= 0L || length == 0x100000L) break;
                sb.append("(").append(length).append(")");
                break;
            }
            case "XML": 
            case "TIME": 
            case "DATE": 
            case "REAL": 
            case "ROWID": 
            case "BIGINT": 
            case "DOUBLE": 
            case "INTEGER": 
            case "BOOLEAN": 
            case "SMALLINT": {
                break;
            }
            case "TIMESTAMP": {
                if (scale == null || scale == 6) break;
                sb.append("(").append(scale).append(")");
                break;
            }
            case "DECIMAL": {
                sb.append("(").append(length);
                if (scale != null && scale > 0) {
                    sb.append(",").append(scale);
                }
                sb.append(")");
                break;
            }
            case "DECFLOAT": {
                if (length == 8L) {
                    sb.append("(16)");
                    break;
                }
                if (length != 16L) break;
                sb.append("(34)");
                break;
            }
            default: {
                sb.append("(");
                sb.append(length);
                sb.append(this.getSubtypeMapping().getOrDefault(this.getForeignKey(), ""));
                sb.append(")");
            }
        }
        if ("N".equals(this.getNullable())) {
            sb.append(" NOT NULL");
        }
        if ("B".equals(defaultType = this.getDefaultType())) {
            sb.append(this.defaultValueDependsOnDataType());
        } else if ("I".equals(defaultType)) {
            Db2ZosSequence identityExpr = this.getIdentityExpr();
            if (identityExpr != null) {
                sb.append(" GENERATED ALWAYS ").append((CharSequence)identityExpr.buildIdentityGrammar());
            }
        } else if ("J".equals(defaultType)) {
            Db2ZosSequence identityExpr = this.getIdentityExpr();
            if (identityExpr != null) {
                sb.append(" GENERATED BY DEFAULT ").append((CharSequence)identityExpr.buildIdentityGrammar());
            }
        } else if ("Y".equals(defaultType)) {
            if ("Y".equals(this.getNullable())) {
                sb.append(" DEFAULT NULL");
            } else if ("N".equals(this.getNullable())) {
                sb.append(" DEFAULT ").append(this.escapeColumnDefault(this.getColumnDefault()));
            }
        } else {
            sb.append(this.getGenerateMapping().getOrDefault(defaultType, ""));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getFldProc())) {
            sb.append(" FIELDPROC ").append(this.getFldProc());
        }
        if ("P".equals(this.getHidden())) {
            sb.append(" IMPLICITLY HIDDEN");
        }
        return sb;
    }

    private String defaultValueDependsOnDataType() {
        return this.getColumnDefault();
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractColumn other) {
        if (!(other instanceof Db2ZosColumn)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Map<String, String> getSubtypeMapping() {
        return this.subtypeMapping;
    }

    @Deprecated
    public int getColCard() {
        return this.colCard;
    }

    @Deprecated
    public void setColCard(int colCard) {
        this.colCard = colCard;
    }

    public String getHigh2Key() {
        return this.high2Key;
    }

    public void setHigh2Key(String high2Key) {
        this.high2Key = high2Key;
    }

    public String getLow2Key() {
        return this.low2Key;
    }

    public void setLow2Key(String low2Key) {
        this.low2Key = low2Key;
    }

    public String getUpdates() {
        return this.updates;
    }

    public void setUpdates(String updates) {
        this.updates = updates;
    }

    public String getIbmreqd() {
        return this.ibmreqd;
    }

    public void setIbmreqd(String ibmreqd) {
        this.ibmreqd = ibmreqd;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    public void setDefaultType(String defaultType) {
        this.defaultType = defaultType;
    }

    public int getKeySeq() {
        return this.keySeq;
    }

    public void setKeySeq(int keySeq) {
        this.keySeq = keySeq;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    public String getFldProc() {
        return this.fldProc;
    }

    public void setFldProc(String fldProc) {
        this.fldProc = fldProc;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Timestamp getStatsTime() {
        return this.statsTime;
    }

    public void setStatsTime(Timestamp statsTime) {
        this.statsTime = statsTime;
    }

    public BigDecimal getColCardf() {
        return this.colCardf;
    }

    public void setColCardf(BigDecimal colCardf) {
        this.colCardf = colCardf;
    }

    public String getColStatus() {
        return this.colStatus;
    }

    public void setColStatus(String colStatus) {
        this.colStatus = colStatus;
    }

    public int getLength2() {
        return this.length2;
    }

    public void setLength2(int length2) {
        this.length2 = length2;
    }

    public int getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(int dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    public int getSourceTypeId() {
        return this.sourceTypeId;
    }

    public void setSourceTypeId(int sourceTypeId) {
        this.sourceTypeId = sourceTypeId;
    }

    public String getTypeSchema() {
        return this.typeSchema;
    }

    public void setTypeSchema(String typeSchema) {
        this.typeSchema = typeSchema;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Timestamp getCreatedTs() {
        return this.createdTs;
    }

    public void setCreatedTs(Timestamp createdTs) {
        this.createdTs = createdTs;
    }

    public String getStatsFormat() {
        return this.statsFormat;
    }

    public void setStatsFormat(String statsFormat) {
        this.statsFormat = statsFormat;
    }

    public int getPartKeyColSeq() {
        return this.partKeyColSeq;
    }

    public void setPartKeyColSeq(int partKeyColSeq) {
        this.partKeyColSeq = partKeyColSeq;
    }

    public String getPartKeyOrdering() {
        return this.partKeyOrdering;
    }

    public void setPartKeyOrdering(String partKeyOrdering) {
        this.partKeyOrdering = partKeyOrdering;
    }

    public Timestamp getAlteredTs() {
        return this.alteredTs;
    }

    public void setAlteredTs(Timestamp alteredTs) {
        this.alteredTs = alteredTs;
    }

    public int getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(int ccsid) {
        this.ccsid = ccsid;
    }

    public String getRelCreated() {
        return this.relCreated;
    }

    public void setRelCreated(String relCreated) {
        this.relCreated = relCreated;
    }

    public int getControlId() {
        return this.controlId;
    }

    public void setControlId(int controlId) {
        this.controlId = controlId;
    }

    public int getXmlTypeModId() {
        return this.xmlTypeModId;
    }

    public void setXmlTypeModId(int xmlTypeModId) {
        this.xmlTypeModId = xmlTypeModId;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String getGeneratedAttr() {
        return this.generatedAttr;
    }

    public void setGeneratedAttr(String generatedAttr) {
        this.generatedAttr = generatedAttr;
    }

    public int getHashKeyColSeq() {
        return this.hashKeyColSeq;
    }

    public void setHashKeyColSeq(int hashKeyColSeq) {
        this.hashKeyColSeq = hashKeyColSeq;
    }

    public Db2ZosSequence getIdentityExpr() {
        return this.identityExpr;
    }

    public void setIdentityExpr(Db2ZosSequence identityExpr) {
        this.identityExpr = identityExpr;
    }
}

