/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Index;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosIndexPartition;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class Db2ZosIndex
extends AbstractDb2Index {
    private Integer colCount;
    private String clustering;
    private String clustered;
    private Integer dbId;
    private Integer obId;
    private Integer isobId;
    private String dbName;
    private String indexSpace;
    private Integer nLeaf;
    private Integer nLevels;
    private String bPool;
    private String pgSize;
    private String eraseRule;
    private String closeRule;
    private Integer space;
    private String ibmreqd;
    private Integer clusterRatio;
    private String createdBy;
    private String statsTime;
    private BigDecimal firstKeyCardf;
    private BigDecimal fullKeyCardf;
    private Timestamp createdTs;
    private Timestamp alteredTs;
    private Integer pieceSize;
    private String copy;
    private String copyLrsn;
    private BigDecimal clusterRatiof;
    private BigDecimal spacef;
    private String remarks;
    private String padded;
    private Integer version;
    private Integer oldestVersion;
    private Integer currentVersion;
    private String relCreated;
    private String avgKeyLen;
    private Integer keyTargetCount;
    private Integer uniqueCount;
    private String ixExtensionType;
    private String compress;
    private String owner;
    private String ownerType;
    private BigDecimal dataRepeatFactorf;
    private Integer envId;
    private String hash;
    private String sparse;
    private Integer dsSize;
    private Integer pageNum;
    @Deprecated
    private Integer partKeyColnum;
    @Deprecated
    private String status;
    private String indexStatus;
    private Integer partitions;
    private Integer pqty;
    private String storType;
    private String storName;
    private String vcatName;
    private Integer freePage;
    private Integer pctFree;
    private String gbpCache;
    private Integer secqtyi;
    private String enforcedCons;
    private String implicit;
    private Timestamp reGenerateTs;
    private boolean tablePartitioned;
    private Db2ZosIndexPartition indexPartition;

    public Db2ZosIndex(Db2ZosSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String indexName = this.getSchemaIndexName();
        sb.append("CREATE");
        String uniqueness = this.getUniqueness();
        if ("U".equals(uniqueness)) {
            sb.append(" UNIQUE");
            this.addUniqueAttribute();
        } else if ("N".equals(uniqueness)) {
            sb.append(" UNIQUE WHERE NOT NULL");
            this.addUniqueAttribute();
        }
        sb.append(" INDEX ").append(indexName).append(" ON ");
        sb.append(this.getSchemaObjectName()).append((CharSequence)this.joinIndexColumns());
        sb.append((CharSequence)this.appendIndexOptions());
        String comment = String.format("COMMENT ON INDEX %s IS '%s'", indexName, this.getRemarks());
        CreateObjectDefine commentDefine = new CreateObjectDefine(ObjectType.COMMENT, indexName, comment);
        ArrayList subDefines = Lists.newArrayList((Object[])new ObjectDefine[]{commentDefine});
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getIndexType(), this.getSimpleIndexName(), this.terminate(sb), (List<ObjectDefine>)subDefines)});
    }

    protected StringBuilder appendIndexOptions() throws UnsupportedGrammarException {
        String copy;
        String closeRule;
        Integer pctFree;
        String padded;
        StringBuilder sb = new StringBuilder();
        String clustering = this.getClustering();
        if ("NO".equals(clustering)) {
            sb.append(" NOT CLUSTER");
        } else if ("YES".equals(clustering)) {
            sb.append(" CLUSTER");
        }
        if ("D".equals(this.getIndexType())) {
            sb.append(" PARTITIONED");
        }
        if ("Y".equals(padded = this.getPadded())) {
            sb.append(" PADDED");
        } else if ("N".equals(padded)) {
            sb.append(" NOT PADDED");
        }
        String vcatName = this.getVcatName();
        if (StringUtils.isNotBlank((CharSequence)vcatName)) {
            sb.append(" VCAT ").append(vcatName);
        } else {
            Integer sqty;
            sb.append(" STOGROUP ").append(this.getStorType());
            Integer pqty = this.getPqty();
            if (pqty != null && pqty > 0) {
                sb.append(" PRIQTY ").append(pqty);
            }
            if ((sqty = this.getSecqtyi()) != null && sqty > 0) {
                sb.append(" SECQTY ").append(sqty);
            }
        }
        Integer freePage = this.getFreePage();
        if (freePage != null && freePage > 0) {
            sb.append(" FREEPAGE ").append(freePage);
        }
        if ((pctFree = this.getPctFree()) != null && pctFree > 0) {
            sb.append(" PCTFREE ").append(pctFree);
        }
        if ("A".equals(this.getGbpCache())) {
            sb.append(" GBPCACHE CHANGED");
        } else if ("N".equals(this.getGbpCache())) {
            sb.append(" NONE");
        } else {
            sb.append(" GBPCACHE ALL");
        }
        String compress = this.getCompress();
        if ("Y".equals(compress)) {
            sb.append(" COMPRESS YES");
        } else if ("N".equals(compress)) {
            sb.append(" COMPRESS NO");
        }
        Db2ZosIndexPartition indexPartition = this.getIndexPartition();
        if (indexPartition != null) {
            sb.append((CharSequence)indexPartition.buildGrammar());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBPool())) {
            sb.append(" BUFFERPOOL ").append(this.getBPool());
        }
        if ("NO".equals(closeRule = this.getCloseRule())) {
            sb.append(" CLOSE NO");
        } else if ("YES".equals(closeRule)) {
            sb.append(" CLOSE YES");
        }
        Integer pieceSize = this.getPieceSize();
        if (pieceSize != null && pieceSize > 0) {
            sb.append(" PIECESIZE ").append(pieceSize);
        }
        if ("Y".equals(copy = this.getCopy())) {
            sb.append(" COPY YES");
        } else if ("N".equals(copy)) {
            sb.append(" COPY NO");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof Db2ZosIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Integer getColCount() {
        return this.colCount;
    }

    public void setColCount(Integer colCount) {
        this.colCount = colCount;
    }

    public String getClustering() {
        return this.clustering;
    }

    public void setClustering(String clustering) {
        this.clustering = clustering;
    }

    public String getClustered() {
        return this.clustered;
    }

    public void setClustered(String clustered) {
        this.clustered = clustered;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public Integer getObId() {
        return this.obId;
    }

    public void setObId(Integer obId) {
        this.obId = obId;
    }

    public Integer getIsobId() {
        return this.isobId;
    }

    public void setIsobId(Integer isobId) {
        this.isobId = isobId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getIndexSpace() {
        return this.indexSpace;
    }

    public void setIndexSpace(String indexSpace) {
        this.indexSpace = indexSpace;
    }

    public Integer getNLeaf() {
        return this.nLeaf;
    }

    public void setNLeaf(Integer nLeaf) {
        this.nLeaf = nLeaf;
    }

    public Integer getNLevels() {
        return this.nLevels;
    }

    public void setNLevels(Integer nLevels) {
        this.nLevels = nLevels;
    }

    public String getBPool() {
        return this.bPool;
    }

    public void setBPool(String bPool) {
        this.bPool = bPool;
    }

    public String getPgSize() {
        return this.pgSize;
    }

    public void setPgSize(String pgSize) {
        this.pgSize = pgSize;
    }

    public String getEraseRule() {
        return this.eraseRule;
    }

    public void setEraseRule(String eraseRule) {
        this.eraseRule = eraseRule;
    }

    public String getCloseRule() {
        return this.closeRule;
    }

    public void setCloseRule(String closeRule) {
        this.closeRule = closeRule;
    }

    public Integer getSpace() {
        return this.space;
    }

    public void setSpace(Integer space) {
        this.space = space;
    }

    public String getIbmreqd() {
        return this.ibmreqd;
    }

    public void setIbmreqd(String ibmreqd) {
        this.ibmreqd = ibmreqd;
    }

    public Integer getClusterRatio() {
        return this.clusterRatio;
    }

    public void setClusterRatio(Integer clusterRatio) {
        this.clusterRatio = clusterRatio;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getStatsTime() {
        return this.statsTime;
    }

    public void setStatsTime(String statsTime) {
        this.statsTime = statsTime;
    }

    public BigDecimal getFirstKeyCardf() {
        return this.firstKeyCardf;
    }

    public void setFirstKeyCardf(BigDecimal firstKeyCardf) {
        this.firstKeyCardf = firstKeyCardf;
    }

    public BigDecimal getFullKeyCardf() {
        return this.fullKeyCardf;
    }

    public void setFullKeyCardf(BigDecimal fullKeyCardf) {
        this.fullKeyCardf = fullKeyCardf;
    }

    public Timestamp getCreatedTs() {
        return this.createdTs;
    }

    public void setCreatedTs(Timestamp createdTs) {
        this.createdTs = createdTs;
    }

    public Timestamp getAlteredTs() {
        return this.alteredTs;
    }

    public void setAlteredTs(Timestamp alteredTs) {
        this.alteredTs = alteredTs;
    }

    public Integer getPieceSize() {
        return this.pieceSize;
    }

    public void setPieceSize(Integer pieceSize) {
        this.pieceSize = pieceSize;
    }

    public String getCopy() {
        return this.copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public String getCopyLrsn() {
        return this.copyLrsn;
    }

    public void setCopyLrsn(String copyLrsn) {
        this.copyLrsn = copyLrsn;
    }

    public BigDecimal getClusterRatiof() {
        return this.clusterRatiof;
    }

    public void setClusterRatiof(BigDecimal clusterRatiof) {
        this.clusterRatiof = clusterRatiof;
    }

    public BigDecimal getSpacef() {
        return this.spacef;
    }

    public void setSpacef(BigDecimal spacef) {
        this.spacef = spacef;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getPadded() {
        return this.padded;
    }

    public void setPadded(String padded) {
        this.padded = padded;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getOldestVersion() {
        return this.oldestVersion;
    }

    public void setOldestVersion(Integer oldestVersion) {
        this.oldestVersion = oldestVersion;
    }

    public Integer getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(Integer currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getRelCreated() {
        return this.relCreated;
    }

    public void setRelCreated(String relCreated) {
        this.relCreated = relCreated;
    }

    public String getAvgKeyLen() {
        return this.avgKeyLen;
    }

    public void setAvgKeyLen(String avgKeyLen) {
        this.avgKeyLen = avgKeyLen;
    }

    public Integer getKeyTargetCount() {
        return this.keyTargetCount;
    }

    public void setKeyTargetCount(Integer keyTargetCount) {
        this.keyTargetCount = keyTargetCount;
    }

    public Integer getUniqueCount() {
        return this.uniqueCount;
    }

    public void setUniqueCount(Integer uniqueCount) {
        this.uniqueCount = uniqueCount;
    }

    public String getIxExtensionType() {
        return this.ixExtensionType;
    }

    public void setIxExtensionType(String ixExtensionType) {
        this.ixExtensionType = ixExtensionType;
    }

    public String getCompress() {
        return this.compress;
    }

    public void setCompress(String compress) {
        this.compress = compress;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public BigDecimal getDataRepeatFactorf() {
        return this.dataRepeatFactorf;
    }

    public void setDataRepeatFactorf(BigDecimal dataRepeatFactorf) {
        this.dataRepeatFactorf = dataRepeatFactorf;
    }

    public Integer getEnvId() {
        return this.envId;
    }

    public void setEnvId(Integer envId) {
        this.envId = envId;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getSparse() {
        return this.sparse;
    }

    public void setSparse(String sparse) {
        this.sparse = sparse;
    }

    public Integer getDsSize() {
        return this.dsSize;
    }

    public void setDsSize(Integer dsSize) {
        this.dsSize = dsSize;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    @Deprecated
    public Integer getPartKeyColnum() {
        return this.partKeyColnum;
    }

    @Deprecated
    public void setPartKeyColnum(Integer partKeyColnum) {
        this.partKeyColnum = partKeyColnum;
    }

    @Deprecated
    public String getStatus() {
        return this.status;
    }

    @Deprecated
    public void setStatus(String status) {
        this.status = status;
    }

    public String getIndexStatus() {
        return this.indexStatus;
    }

    public void setIndexStatus(String indexStatus) {
        this.indexStatus = indexStatus;
    }

    public Integer getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Integer partitions) {
        this.partitions = partitions;
    }

    public Integer getPqty() {
        return this.pqty;
    }

    public void setPqty(Integer pqty) {
        this.pqty = pqty;
    }

    public String getStorType() {
        return this.storType;
    }

    public void setStorType(String storType) {
        this.storType = storType;
    }

    public String getStorName() {
        return this.storName;
    }

    public void setStorName(String storName) {
        this.storName = storName;
    }

    public String getVcatName() {
        return this.vcatName;
    }

    public void setVcatName(String vcatName) {
        this.vcatName = vcatName;
    }

    public Integer getFreePage() {
        return this.freePage;
    }

    public void setFreePage(Integer freePage) {
        this.freePage = freePage;
    }

    public Integer getPctFree() {
        return this.pctFree;
    }

    public void setPctFree(Integer pctFree) {
        this.pctFree = pctFree;
    }

    public String getGbpCache() {
        return this.gbpCache;
    }

    public void setGbpCache(String gbpCache) {
        this.gbpCache = gbpCache;
    }

    public Integer getSecqtyi() {
        return this.secqtyi;
    }

    public void setSecqtyi(Integer secqtyi) {
        this.secqtyi = secqtyi;
    }

    public String getEnforcedCons() {
        return this.enforcedCons;
    }

    public void setEnforcedCons(String enforcedCons) {
        this.enforcedCons = enforcedCons;
    }

    public String getImplicit() {
        return this.implicit;
    }

    public void setImplicit(String implicit) {
        this.implicit = implicit;
    }

    public Timestamp getReGenerateTs() {
        return this.reGenerateTs;
    }

    public void setReGenerateTs(Timestamp reGenerateTs) {
        this.reGenerateTs = reGenerateTs;
    }

    public boolean isTablePartitioned() {
        return this.tablePartitioned;
    }

    public void setTablePartitioned(boolean tablePartitioned) {
        this.tablePartitioned = tablePartitioned;
    }

    public Db2ZosIndexPartition getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(Db2ZosIndexPartition indexPartition) {
        this.indexPartition = indexPartition;
    }
}

