/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndexPartition;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class Db2ZosIndexPartition
extends AbstractIndexPartition {
    private final transient Collection<Db2ZosIndexPartitionItem> partitionItems = new LinkedHashSet<Db2ZosIndexPartitionItem>();

    public Db2ZosIndexPartition(Db2ZosSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append(" PARTITION BY RANGE (").append("\n");
        Iterator<Db2ZosIndexPartitionItem> iter = this.getPartitionItems().iterator();
        while (iter.hasNext()) {
            Integer pctFree;
            Integer freePage;
            Db2ZosIndexPartitionItem item = iter.next();
            sb.append("\t").append("PARTITION ").append(item.getPartition());
            sb.append(" ENDING AT ('").append(item.getLimitKey()).append("')");
            String vcatName = item.getVcatName();
            if (StringUtils.isNotBlank((CharSequence)vcatName)) {
                sb.append(" VCAT ").append(vcatName);
            }
            String storType = item.getStorType();
            if (StringUtils.isNotBlank((CharSequence)vcatName)) {
                Integer sqty;
                sb.append(" STOGROUP ").append(storType);
                Integer pqty = item.getPqty();
                if (pqty != null && pqty > 0) {
                    sb.append(" PRIQTY ").append(pqty);
                }
                if ((sqty = item.getSqty()) != null && sqty > 0) {
                    sb.append(" SECQTY ").append(sqty);
                }
            }
            if ((freePage = item.getFreePage()) != null && freePage > 0) {
                sb.append(" FREEPAGE ").append(freePage);
            }
            if ((pctFree = item.getPctFree()) != null && pctFree > 0) {
                sb.append(" PCTFREE ").append(pctFree);
            }
            if ("A".equals(item.getGbpCache())) {
                sb.append(" GBPCACHE CHANGED");
            } else if ("N".equals(item.getGbpCache())) {
                sb.append(" NONE");
            } else {
                sb.append(" GBPCACHE ALL");
            }
            if (!iter.hasNext()) continue;
            sb.append(",").append("\n");
        }
        return sb.append("\n").append(")");
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndexPartition other) {
        if (!(other instanceof Db2ZosIndexPartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Collection<Db2ZosIndexPartitionItem> getPartitionItems() {
        return this.partitionItems;
    }

    public static class Db2ZosIndexPartitionItem {
        private Integer partition;
        private String ixName;
        private String ixCreator;
        private Integer pqty;
        private Integer sqty;
        private String storType;
        private String storName;
        private String vcatName;
        @Deprecated
        private Integer card;
        @Deprecated
        private Integer farOffPos;
        private Integer leafDist;
        @Deprecated
        private Integer nearOffPos;
        private String ibmreqd;
        private String limitKey;
        private Integer freePage;
        private Integer pctFree;
        private Integer space;
        private Timestamp statsTime;
        @Deprecated
        private String indexType;
        private String gbpCache;
        private BigDecimal farOffPosf;
        private BigDecimal nearOffPosf;
        private BigDecimal cardf;
        private Integer secqtyi;
        private String iprefix;
        private Timestamp alteredTs;
        private BigDecimal spacef;
        private Integer dsNum;
        private Integer extents;
        private Integer pseudoDelEntries;
        private String leafNear;
        private Integer leafFar;
        private Integer oldestVersion;
        private Timestamp createdTs;
        private Integer avgKeyLen;
        private String rbaFormat;
        private Integer dsSize;
        private String pageNum;
        private String limitKeyExternal;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Db2ZosIndexPartitionItem)) {
                return false;
            }
            Db2ZosIndexPartitionItem other = (Db2ZosIndexPartitionItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$partition = this.getPartition();
            Integer other$partition = other.getPartition();
            if (this$partition == null ? other$partition != null : !((Object)this$partition).equals(other$partition)) {
                return false;
            }
            Integer this$pqty = this.getPqty();
            Integer other$pqty = other.getPqty();
            if (this$pqty == null ? other$pqty != null : !((Object)this$pqty).equals(other$pqty)) {
                return false;
            }
            Integer this$sqty = this.getSqty();
            Integer other$sqty = other.getSqty();
            if (this$sqty == null ? other$sqty != null : !((Object)this$sqty).equals(other$sqty)) {
                return false;
            }
            Integer this$card = this.getCard();
            Integer other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            Integer this$farOffPos = this.getFarOffPos();
            Integer other$farOffPos = other.getFarOffPos();
            if (this$farOffPos == null ? other$farOffPos != null : !((Object)this$farOffPos).equals(other$farOffPos)) {
                return false;
            }
            Integer this$leafDist = this.getLeafDist();
            Integer other$leafDist = other.getLeafDist();
            if (this$leafDist == null ? other$leafDist != null : !((Object)this$leafDist).equals(other$leafDist)) {
                return false;
            }
            Integer this$nearOffPos = this.getNearOffPos();
            Integer other$nearOffPos = other.getNearOffPos();
            if (this$nearOffPos == null ? other$nearOffPos != null : !((Object)this$nearOffPos).equals(other$nearOffPos)) {
                return false;
            }
            Integer this$freePage = this.getFreePage();
            Integer other$freePage = other.getFreePage();
            if (this$freePage == null ? other$freePage != null : !((Object)this$freePage).equals(other$freePage)) {
                return false;
            }
            Integer this$pctFree = this.getPctFree();
            Integer other$pctFree = other.getPctFree();
            if (this$pctFree == null ? other$pctFree != null : !((Object)this$pctFree).equals(other$pctFree)) {
                return false;
            }
            Integer this$space = this.getSpace();
            Integer other$space = other.getSpace();
            if (this$space == null ? other$space != null : !((Object)this$space).equals(other$space)) {
                return false;
            }
            Integer this$secqtyi = this.getSecqtyi();
            Integer other$secqtyi = other.getSecqtyi();
            if (this$secqtyi == null ? other$secqtyi != null : !((Object)this$secqtyi).equals(other$secqtyi)) {
                return false;
            }
            Integer this$dsNum = this.getDsNum();
            Integer other$dsNum = other.getDsNum();
            if (this$dsNum == null ? other$dsNum != null : !((Object)this$dsNum).equals(other$dsNum)) {
                return false;
            }
            Integer this$extents = this.getExtents();
            Integer other$extents = other.getExtents();
            if (this$extents == null ? other$extents != null : !((Object)this$extents).equals(other$extents)) {
                return false;
            }
            Integer this$pseudoDelEntries = this.getPseudoDelEntries();
            Integer other$pseudoDelEntries = other.getPseudoDelEntries();
            if (this$pseudoDelEntries == null ? other$pseudoDelEntries != null : !((Object)this$pseudoDelEntries).equals(other$pseudoDelEntries)) {
                return false;
            }
            Integer this$leafFar = this.getLeafFar();
            Integer other$leafFar = other.getLeafFar();
            if (this$leafFar == null ? other$leafFar != null : !((Object)this$leafFar).equals(other$leafFar)) {
                return false;
            }
            Integer this$oldestVersion = this.getOldestVersion();
            Integer other$oldestVersion = other.getOldestVersion();
            if (this$oldestVersion == null ? other$oldestVersion != null : !((Object)this$oldestVersion).equals(other$oldestVersion)) {
                return false;
            }
            Integer this$avgKeyLen = this.getAvgKeyLen();
            Integer other$avgKeyLen = other.getAvgKeyLen();
            if (this$avgKeyLen == null ? other$avgKeyLen != null : !((Object)this$avgKeyLen).equals(other$avgKeyLen)) {
                return false;
            }
            Integer this$dsSize = this.getDsSize();
            Integer other$dsSize = other.getDsSize();
            if (this$dsSize == null ? other$dsSize != null : !((Object)this$dsSize).equals(other$dsSize)) {
                return false;
            }
            String this$ixName = this.getIxName();
            String other$ixName = other.getIxName();
            if (this$ixName == null ? other$ixName != null : !this$ixName.equals(other$ixName)) {
                return false;
            }
            String this$ixCreator = this.getIxCreator();
            String other$ixCreator = other.getIxCreator();
            if (this$ixCreator == null ? other$ixCreator != null : !this$ixCreator.equals(other$ixCreator)) {
                return false;
            }
            String this$storType = this.getStorType();
            String other$storType = other.getStorType();
            if (this$storType == null ? other$storType != null : !this$storType.equals(other$storType)) {
                return false;
            }
            String this$storName = this.getStorName();
            String other$storName = other.getStorName();
            if (this$storName == null ? other$storName != null : !this$storName.equals(other$storName)) {
                return false;
            }
            String this$vcatName = this.getVcatName();
            String other$vcatName = other.getVcatName();
            if (this$vcatName == null ? other$vcatName != null : !this$vcatName.equals(other$vcatName)) {
                return false;
            }
            String this$ibmreqd = this.getIbmreqd();
            String other$ibmreqd = other.getIbmreqd();
            if (this$ibmreqd == null ? other$ibmreqd != null : !this$ibmreqd.equals(other$ibmreqd)) {
                return false;
            }
            String this$limitKey = this.getLimitKey();
            String other$limitKey = other.getLimitKey();
            if (this$limitKey == null ? other$limitKey != null : !this$limitKey.equals(other$limitKey)) {
                return false;
            }
            Timestamp this$statsTime = this.getStatsTime();
            Timestamp other$statsTime = other.getStatsTime();
            if (this$statsTime == null ? other$statsTime != null : !((Object)this$statsTime).equals(other$statsTime)) {
                return false;
            }
            String this$indexType = this.getIndexType();
            String other$indexType = other.getIndexType();
            if (this$indexType == null ? other$indexType != null : !this$indexType.equals(other$indexType)) {
                return false;
            }
            String this$gbpCache = this.getGbpCache();
            String other$gbpCache = other.getGbpCache();
            if (this$gbpCache == null ? other$gbpCache != null : !this$gbpCache.equals(other$gbpCache)) {
                return false;
            }
            BigDecimal this$farOffPosf = this.getFarOffPosf();
            BigDecimal other$farOffPosf = other.getFarOffPosf();
            if (this$farOffPosf == null ? other$farOffPosf != null : !((Object)this$farOffPosf).equals(other$farOffPosf)) {
                return false;
            }
            BigDecimal this$nearOffPosf = this.getNearOffPosf();
            BigDecimal other$nearOffPosf = other.getNearOffPosf();
            if (this$nearOffPosf == null ? other$nearOffPosf != null : !((Object)this$nearOffPosf).equals(other$nearOffPosf)) {
                return false;
            }
            BigDecimal this$cardf = this.getCardf();
            BigDecimal other$cardf = other.getCardf();
            if (this$cardf == null ? other$cardf != null : !((Object)this$cardf).equals(other$cardf)) {
                return false;
            }
            String this$iprefix = this.getIprefix();
            String other$iprefix = other.getIprefix();
            if (this$iprefix == null ? other$iprefix != null : !this$iprefix.equals(other$iprefix)) {
                return false;
            }
            Timestamp this$alteredTs = this.getAlteredTs();
            Timestamp other$alteredTs = other.getAlteredTs();
            if (this$alteredTs == null ? other$alteredTs != null : !((Object)this$alteredTs).equals(other$alteredTs)) {
                return false;
            }
            BigDecimal this$spacef = this.getSpacef();
            BigDecimal other$spacef = other.getSpacef();
            if (this$spacef == null ? other$spacef != null : !((Object)this$spacef).equals(other$spacef)) {
                return false;
            }
            String this$leafNear = this.getLeafNear();
            String other$leafNear = other.getLeafNear();
            if (this$leafNear == null ? other$leafNear != null : !this$leafNear.equals(other$leafNear)) {
                return false;
            }
            Timestamp this$createdTs = this.getCreatedTs();
            Timestamp other$createdTs = other.getCreatedTs();
            if (this$createdTs == null ? other$createdTs != null : !((Object)this$createdTs).equals(other$createdTs)) {
                return false;
            }
            String this$rbaFormat = this.getRbaFormat();
            String other$rbaFormat = other.getRbaFormat();
            if (this$rbaFormat == null ? other$rbaFormat != null : !this$rbaFormat.equals(other$rbaFormat)) {
                return false;
            }
            String this$pageNum = this.getPageNum();
            String other$pageNum = other.getPageNum();
            if (this$pageNum == null ? other$pageNum != null : !this$pageNum.equals(other$pageNum)) {
                return false;
            }
            String this$limitKeyExternal = this.getLimitKeyExternal();
            String other$limitKeyExternal = other.getLimitKeyExternal();
            return !(this$limitKeyExternal == null ? other$limitKeyExternal != null : !this$limitKeyExternal.equals(other$limitKeyExternal));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Db2ZosIndexPartitionItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $partition = this.getPartition();
            result = result * 59 + ($partition == null ? 43 : ((Object)$partition).hashCode());
            Integer $pqty = this.getPqty();
            result = result * 59 + ($pqty == null ? 43 : ((Object)$pqty).hashCode());
            Integer $sqty = this.getSqty();
            result = result * 59 + ($sqty == null ? 43 : ((Object)$sqty).hashCode());
            Integer $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            Integer $farOffPos = this.getFarOffPos();
            result = result * 59 + ($farOffPos == null ? 43 : ((Object)$farOffPos).hashCode());
            Integer $leafDist = this.getLeafDist();
            result = result * 59 + ($leafDist == null ? 43 : ((Object)$leafDist).hashCode());
            Integer $nearOffPos = this.getNearOffPos();
            result = result * 59 + ($nearOffPos == null ? 43 : ((Object)$nearOffPos).hashCode());
            Integer $freePage = this.getFreePage();
            result = result * 59 + ($freePage == null ? 43 : ((Object)$freePage).hashCode());
            Integer $pctFree = this.getPctFree();
            result = result * 59 + ($pctFree == null ? 43 : ((Object)$pctFree).hashCode());
            Integer $space = this.getSpace();
            result = result * 59 + ($space == null ? 43 : ((Object)$space).hashCode());
            Integer $secqtyi = this.getSecqtyi();
            result = result * 59 + ($secqtyi == null ? 43 : ((Object)$secqtyi).hashCode());
            Integer $dsNum = this.getDsNum();
            result = result * 59 + ($dsNum == null ? 43 : ((Object)$dsNum).hashCode());
            Integer $extents = this.getExtents();
            result = result * 59 + ($extents == null ? 43 : ((Object)$extents).hashCode());
            Integer $pseudoDelEntries = this.getPseudoDelEntries();
            result = result * 59 + ($pseudoDelEntries == null ? 43 : ((Object)$pseudoDelEntries).hashCode());
            Integer $leafFar = this.getLeafFar();
            result = result * 59 + ($leafFar == null ? 43 : ((Object)$leafFar).hashCode());
            Integer $oldestVersion = this.getOldestVersion();
            result = result * 59 + ($oldestVersion == null ? 43 : ((Object)$oldestVersion).hashCode());
            Integer $avgKeyLen = this.getAvgKeyLen();
            result = result * 59 + ($avgKeyLen == null ? 43 : ((Object)$avgKeyLen).hashCode());
            Integer $dsSize = this.getDsSize();
            result = result * 59 + ($dsSize == null ? 43 : ((Object)$dsSize).hashCode());
            String $ixName = this.getIxName();
            result = result * 59 + ($ixName == null ? 43 : $ixName.hashCode());
            String $ixCreator = this.getIxCreator();
            result = result * 59 + ($ixCreator == null ? 43 : $ixCreator.hashCode());
            String $storType = this.getStorType();
            result = result * 59 + ($storType == null ? 43 : $storType.hashCode());
            String $storName = this.getStorName();
            result = result * 59 + ($storName == null ? 43 : $storName.hashCode());
            String $vcatName = this.getVcatName();
            result = result * 59 + ($vcatName == null ? 43 : $vcatName.hashCode());
            String $ibmreqd = this.getIbmreqd();
            result = result * 59 + ($ibmreqd == null ? 43 : $ibmreqd.hashCode());
            String $limitKey = this.getLimitKey();
            result = result * 59 + ($limitKey == null ? 43 : $limitKey.hashCode());
            Timestamp $statsTime = this.getStatsTime();
            result = result * 59 + ($statsTime == null ? 43 : ((Object)$statsTime).hashCode());
            String $indexType = this.getIndexType();
            result = result * 59 + ($indexType == null ? 43 : $indexType.hashCode());
            String $gbpCache = this.getGbpCache();
            result = result * 59 + ($gbpCache == null ? 43 : $gbpCache.hashCode());
            BigDecimal $farOffPosf = this.getFarOffPosf();
            result = result * 59 + ($farOffPosf == null ? 43 : ((Object)$farOffPosf).hashCode());
            BigDecimal $nearOffPosf = this.getNearOffPosf();
            result = result * 59 + ($nearOffPosf == null ? 43 : ((Object)$nearOffPosf).hashCode());
            BigDecimal $cardf = this.getCardf();
            result = result * 59 + ($cardf == null ? 43 : ((Object)$cardf).hashCode());
            String $iprefix = this.getIprefix();
            result = result * 59 + ($iprefix == null ? 43 : $iprefix.hashCode());
            Timestamp $alteredTs = this.getAlteredTs();
            result = result * 59 + ($alteredTs == null ? 43 : ((Object)$alteredTs).hashCode());
            BigDecimal $spacef = this.getSpacef();
            result = result * 59 + ($spacef == null ? 43 : ((Object)$spacef).hashCode());
            String $leafNear = this.getLeafNear();
            result = result * 59 + ($leafNear == null ? 43 : $leafNear.hashCode());
            Timestamp $createdTs = this.getCreatedTs();
            result = result * 59 + ($createdTs == null ? 43 : ((Object)$createdTs).hashCode());
            String $rbaFormat = this.getRbaFormat();
            result = result * 59 + ($rbaFormat == null ? 43 : $rbaFormat.hashCode());
            String $pageNum = this.getPageNum();
            result = result * 59 + ($pageNum == null ? 43 : $pageNum.hashCode());
            String $limitKeyExternal = this.getLimitKeyExternal();
            result = result * 59 + ($limitKeyExternal == null ? 43 : $limitKeyExternal.hashCode());
            return result;
        }

        public Integer getPartition() {
            return this.partition;
        }

        public void setPartition(Integer partition) {
            this.partition = partition;
        }

        public String getIxName() {
            return this.ixName;
        }

        public void setIxName(String ixName) {
            this.ixName = ixName;
        }

        public String getIxCreator() {
            return this.ixCreator;
        }

        public void setIxCreator(String ixCreator) {
            this.ixCreator = ixCreator;
        }

        public Integer getPqty() {
            return this.pqty;
        }

        public void setPqty(Integer pqty) {
            this.pqty = pqty;
        }

        public Integer getSqty() {
            return this.sqty;
        }

        public void setSqty(Integer sqty) {
            this.sqty = sqty;
        }

        public String getStorType() {
            return this.storType;
        }

        public void setStorType(String storType) {
            this.storType = storType;
        }

        public String getStorName() {
            return this.storName;
        }

        public void setStorName(String storName) {
            this.storName = storName;
        }

        public String getVcatName() {
            return this.vcatName;
        }

        public void setVcatName(String vcatName) {
            this.vcatName = vcatName;
        }

        @Deprecated
        public Integer getCard() {
            return this.card;
        }

        @Deprecated
        public void setCard(Integer card) {
            this.card = card;
        }

        @Deprecated
        public Integer getFarOffPos() {
            return this.farOffPos;
        }

        @Deprecated
        public void setFarOffPos(Integer farOffPos) {
            this.farOffPos = farOffPos;
        }

        public Integer getLeafDist() {
            return this.leafDist;
        }

        public void setLeafDist(Integer leafDist) {
            this.leafDist = leafDist;
        }

        @Deprecated
        public Integer getNearOffPos() {
            return this.nearOffPos;
        }

        @Deprecated
        public void setNearOffPos(Integer nearOffPos) {
            this.nearOffPos = nearOffPos;
        }

        public String getIbmreqd() {
            return this.ibmreqd;
        }

        public void setIbmreqd(String ibmreqd) {
            this.ibmreqd = ibmreqd;
        }

        public String getLimitKey() {
            return this.limitKey;
        }

        public void setLimitKey(String limitKey) {
            this.limitKey = limitKey;
        }

        public Integer getFreePage() {
            return this.freePage;
        }

        public void setFreePage(Integer freePage) {
            this.freePage = freePage;
        }

        public Integer getPctFree() {
            return this.pctFree;
        }

        public void setPctFree(Integer pctFree) {
            this.pctFree = pctFree;
        }

        public Integer getSpace() {
            return this.space;
        }

        public void setSpace(Integer space) {
            this.space = space;
        }

        public Timestamp getStatsTime() {
            return this.statsTime;
        }

        public void setStatsTime(Timestamp statsTime) {
            this.statsTime = statsTime;
        }

        @Deprecated
        public String getIndexType() {
            return this.indexType;
        }

        @Deprecated
        public void setIndexType(String indexType) {
            this.indexType = indexType;
        }

        public String getGbpCache() {
            return this.gbpCache;
        }

        public void setGbpCache(String gbpCache) {
            this.gbpCache = gbpCache;
        }

        public BigDecimal getFarOffPosf() {
            return this.farOffPosf;
        }

        public void setFarOffPosf(BigDecimal farOffPosf) {
            this.farOffPosf = farOffPosf;
        }

        public BigDecimal getNearOffPosf() {
            return this.nearOffPosf;
        }

        public void setNearOffPosf(BigDecimal nearOffPosf) {
            this.nearOffPosf = nearOffPosf;
        }

        public BigDecimal getCardf() {
            return this.cardf;
        }

        public void setCardf(BigDecimal cardf) {
            this.cardf = cardf;
        }

        public Integer getSecqtyi() {
            return this.secqtyi;
        }

        public void setSecqtyi(Integer secqtyi) {
            this.secqtyi = secqtyi;
        }

        public String getIprefix() {
            return this.iprefix;
        }

        public void setIprefix(String iprefix) {
            this.iprefix = iprefix;
        }

        public Timestamp getAlteredTs() {
            return this.alteredTs;
        }

        public void setAlteredTs(Timestamp alteredTs) {
            this.alteredTs = alteredTs;
        }

        public BigDecimal getSpacef() {
            return this.spacef;
        }

        public void setSpacef(BigDecimal spacef) {
            this.spacef = spacef;
        }

        public Integer getDsNum() {
            return this.dsNum;
        }

        public void setDsNum(Integer dsNum) {
            this.dsNum = dsNum;
        }

        public Integer getExtents() {
            return this.extents;
        }

        public void setExtents(Integer extents) {
            this.extents = extents;
        }

        public Integer getPseudoDelEntries() {
            return this.pseudoDelEntries;
        }

        public void setPseudoDelEntries(Integer pseudoDelEntries) {
            this.pseudoDelEntries = pseudoDelEntries;
        }

        public String getLeafNear() {
            return this.leafNear;
        }

        public void setLeafNear(String leafNear) {
            this.leafNear = leafNear;
        }

        public Integer getLeafFar() {
            return this.leafFar;
        }

        public void setLeafFar(Integer leafFar) {
            this.leafFar = leafFar;
        }

        public Integer getOldestVersion() {
            return this.oldestVersion;
        }

        public void setOldestVersion(Integer oldestVersion) {
            this.oldestVersion = oldestVersion;
        }

        public Timestamp getCreatedTs() {
            return this.createdTs;
        }

        public void setCreatedTs(Timestamp createdTs) {
            this.createdTs = createdTs;
        }

        public Integer getAvgKeyLen() {
            return this.avgKeyLen;
        }

        public void setAvgKeyLen(Integer avgKeyLen) {
            this.avgKeyLen = avgKeyLen;
        }

        public String getRbaFormat() {
            return this.rbaFormat;
        }

        public void setRbaFormat(String rbaFormat) {
            this.rbaFormat = rbaFormat;
        }

        public Integer getDsSize() {
            return this.dsSize;
        }

        public void setDsSize(Integer dsSize) {
            this.dsSize = dsSize;
        }

        public String getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(String pageNum) {
            this.pageNum = pageNum;
        }

        public String getLimitKeyExternal() {
            return this.limitKeyExternal;
        }

        public void setLimitKeyExternal(String limitKeyExternal) {
            this.limitKeyExternal = limitKeyExternal;
        }
    }
}

