/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class Db2ZosSchema
extends AbstractSchema {
    private String name;
    private String creator;
    private String stGroup;
    private String bPool;
    private Integer dbId;
    private String ibmReqd;
    private String createdBy;
    private String type;
    private String groupMember;
    private Timestamp createDts;
    private Timestamp altereDts;
    private String encodingScheme;
    private Integer sbcsCcsid;
    private Integer dbcsCcsid;
    private Integer mixedCcsid;
    private String indexBp;
    private String implicit;
    private String creatorType;
    private String relCreated;
    private final Map<String, String> encodingSchemeMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 8880739036190048294L;
        {
            this.put("E", " EBCDIC");
            this.put("A", " ASCII");
            this.put("U", " UNICODE");
        }
    };

    public Db2ZosSchema(Global global, DbType dbType, String schemaName) {
        super(global, dbType, schemaName);
    }

    public Db2ZosSchema(Global global, DbType dbType, String catalogName, String schemaName) {
        super(global, dbType, catalogName, schemaName);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String encodingSchema;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE DATABASE ").append(this.getSchemaName());
        if (StringUtils.isNotBlank((CharSequence)this.getBPool())) {
            sb.append(" BUFFERPOOL ").append(this.getBPool());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getIndexBp())) {
            sb.append(" INDEXBP ").append(this.getIndexBp());
        }
        if ("W".equals(this.getType())) {
            sb.append(" AS WORKFILE");
            if (StringUtils.isNotBlank((CharSequence)this.getGroupMember())) {
                sb.append(" FOR ").append(this.getGroupMember());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.getStGroup())) {
            sb.append(" STOGROUP ").append(this.getStGroup());
        }
        if (StringUtils.isNotBlank((CharSequence)(encodingSchema = this.getEncodingScheme()))) {
            sb.append(" CCSID").append(this.getEncodingSchemeMapping().get(encodingSchema));
        }
        return sb;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getStGroup() {
        return this.stGroup;
    }

    public void setStGroup(String stGroup) {
        this.stGroup = stGroup;
    }

    public String getBPool() {
        return this.bPool;
    }

    public void setBPool(String bPool) {
        this.bPool = bPool;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public String getIbmReqd() {
        return this.ibmReqd;
    }

    public void setIbmReqd(String ibmReqd) {
        this.ibmReqd = ibmReqd;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGroupMember() {
        return this.groupMember;
    }

    public void setGroupMember(String groupMember) {
        this.groupMember = groupMember;
    }

    public Timestamp getCreateDts() {
        return this.createDts;
    }

    public void setCreateDts(Timestamp createDts) {
        this.createDts = createDts;
    }

    public Timestamp getAltereDts() {
        return this.altereDts;
    }

    public void setAltereDts(Timestamp altereDts) {
        this.altereDts = altereDts;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public Integer getSbcsCcsid() {
        return this.sbcsCcsid;
    }

    public void setSbcsCcsid(Integer sbcsCcsid) {
        this.sbcsCcsid = sbcsCcsid;
    }

    public Integer getDbcsCcsid() {
        return this.dbcsCcsid;
    }

    public void setDbcsCcsid(Integer dbcsCcsid) {
        this.dbcsCcsid = dbcsCcsid;
    }

    public Integer getMixedCcsid() {
        return this.mixedCcsid;
    }

    public void setMixedCcsid(Integer mixedCcsid) {
        this.mixedCcsid = mixedCcsid;
    }

    public String getIndexBp() {
        return this.indexBp;
    }

    public void setIndexBp(String indexBp) {
        this.indexBp = indexBp;
    }

    public String getImplicit() {
        return this.implicit;
    }

    public void setImplicit(String implicit) {
        this.implicit = implicit;
    }

    public String getCreatorType() {
        return this.creatorType;
    }

    public void setCreatorType(String creatorType) {
        this.creatorType = creatorType;
    }

    public String getRelCreated() {
        return this.relCreated;
    }

    public void setRelCreated(String relCreated) {
        this.relCreated = relCreated;
    }

    public Map<String, String> getEncodingSchemeMapping() {
        return this.encodingSchemeMapping;
    }
}

