/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Sequence;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class Db2ZosSequence
extends AbstractDb2Sequence {
    private String seqType;
    private Integer sequenceId;
    private String createdBy;
    private Integer dataTypeId;
    private Integer sourceTypeId;
    private Timestamp createDts;
    private Timestamp altereDts;
    private BigDecimal maxAssignedVal;
    private String ibmreqd;
    private String remarks;
    private Integer precision;
    private BigDecimal restartWith;
    private String ownerType;
    private String relCreated;

    public Db2ZosSequence(Db2ZosSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String objectName = this.getSchemaObjectName();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE SEQUENCE ").append(objectName);
        if (StringUtils.isNotBlank((CharSequence)this.getDataType())) {
            sb.append(" AS ").append(this.getDataType());
            if (this.getPrecision() != null && this.getPrecision() > 0) {
                sb.append("(").append(this.getPrecision()).append(")");
            }
        }
        sb.append((CharSequence)super.buildSequenceGrammar());
        String comment = String.format("COMMENT ON SEQUENCE %s IS '%s'", objectName, this.getRemarks());
        CreateObjectDefine commentDefine = new CreateObjectDefine(ObjectType.COMMENT, objectName, comment);
        ArrayList subDefines = Lists.newArrayList((Object[])new ObjectDefine[]{commentDefine});
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), this.terminate(sb), subDefines)});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractSequence other) {
        if (!(other instanceof Db2ZosSequence)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getSeqType() {
        return this.seqType;
    }

    public void setSeqType(String seqType) {
        this.seqType = seqType;
    }

    public Integer getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(Integer sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Integer getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Integer dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    public Integer getSourceTypeId() {
        return this.sourceTypeId;
    }

    public void setSourceTypeId(Integer sourceTypeId) {
        this.sourceTypeId = sourceTypeId;
    }

    public Timestamp getCreateDts() {
        return this.createDts;
    }

    public void setCreateDts(Timestamp createDts) {
        this.createDts = createDts;
    }

    public Timestamp getAltereDts() {
        return this.altereDts;
    }

    public void setAltereDts(Timestamp altereDts) {
        this.altereDts = altereDts;
    }

    public BigDecimal getMaxAssignedVal() {
        return this.maxAssignedVal;
    }

    public void setMaxAssignedVal(BigDecimal maxAssignedVal) {
        this.maxAssignedVal = maxAssignedVal;
    }

    public String getIbmreqd() {
        return this.ibmreqd;
    }

    public void setIbmreqd(String ibmreqd) {
        this.ibmreqd = ibmreqd;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public BigDecimal getRestartWith() {
        return this.restartWith;
    }

    public void setRestartWith(BigDecimal restartWith) {
        this.restartWith = restartWith;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getRelCreated() {
        return this.relCreated;
    }

    public void setRelCreated(String relCreated) {
        this.relCreated = relCreated;
    }
}

