/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSynonym;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Synonym;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import java.sql.Timestamp;
import java.util.List;

public class Db2ZosSynonym
extends AbstractDb2Synonym {
    private String ibmreqd;
    private String createdBy;
    private Timestamp createdTs;
    private String creatorType;
    private String relCreated;

    public Db2ZosSynonym(Db2ZosSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE SYNONYM ").append(this.getSchemaObjectName());
        sb.append(" FOR ");
        if (StringUtils.isNotBlank((CharSequence)this.getTableOwner())) {
            sb.append(this.wrap(this.getTableOwner())).append(".");
        }
        sb.append(this.wrap(this.getTableName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SYNONYM, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractSynonym other) {
        if (!(other instanceof Db2ZosSynonym)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getIbmreqd() {
        return this.ibmreqd;
    }

    public void setIbmreqd(String ibmreqd) {
        this.ibmreqd = ibmreqd;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Timestamp getCreatedTs() {
        return this.createdTs;
    }

    public void setCreatedTs(Timestamp createdTs) {
        this.createdTs = createdTs;
    }

    public String getCreatorType() {
        return this.creatorType;
    }

    public void setCreatorType(String creatorType) {
        this.creatorType = creatorType;
    }

    public String getRelCreated() {
        return this.relCreated;
    }

    public void setRelCreated(String relCreated) {
        this.relCreated = relCreated;
    }
}

