/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosCheck;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosColumn;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosForeignKey;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosIndex;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosTablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosUniqueKey;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Db2ZosTable
extends AbstractTable {
    private final Map<String, Db2ZosColumn> columnMapping = new LinkedHashMap<String, Db2ZosColumn>();
    private final Map<String, Db2ZosIndex> indexMapping = new LinkedHashMap<String, Db2ZosIndex>();
    private final Map<String, Db2ZosCheck> checkMapping = new LinkedHashMap<String, Db2ZosCheck>();
    private final Map<String, Db2ZosUniqueKey> uniqueMapping = new LinkedHashMap<String, Db2ZosUniqueKey>();
    private final Map<String, Db2ZosForeignKey> foreignMapping = new LinkedHashMap<String, Db2ZosForeignKey>();
    private String name;
    private String creator;
    private String type;
    private String dbName;
    private String tsName;
    private Integer dbId;
    private Integer obId;
    private Integer colCount;
    private String edProc;
    private String valProc;
    private String clusterType;
    @Deprecated
    private Integer clusterRid;
    @Deprecated
    private Integer card;
    private Integer npages;
    private Integer pctPages;
    private String ibmreqd;
    private String remarks;
    private Integer parents;
    private Integer children;
    private Integer keyColumns;
    private Integer recLength;
    private String status;
    private Integer keyObId;
    private String label;
    private String checkFlag;
    private String checkRid;
    private String auditing;
    private String createdBy;
    private String location;
    private String tbCreator;
    private String tbName;
    private Timestamp createdTs;
    private Timestamp alteredTs;
    private String dataCapture;
    private String rba1;
    private String rba2;
    private Integer pctRowComp;
    private Timestamp statsTime;
    private Integer checks;
    private BigDecimal cardf;
    private String checkRid5b;
    private String encodingScheme;
    private String tableStatus;
    private BigDecimal nPagesf;
    private BigDecimal spacef;
    private Integer avgRowLen;
    private String relCreated;
    private Integer numDepMqts;
    private Integer version;
    private Integer partKeyColNum;
    private String splitRows;
    private String securityLabel;
    private String owner;
    private String append;
    private String ownerType;
    private String control;
    private String versioningSchema;
    private String versioningTable;
    private Integer hashKeyColumns;
    private Db2ZosPrimaryKey primaryKey;
    private String partitionType;
    private Db2ZosTablePartition tablePartition;

    public Db2ZosTable(Db2ZosSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String objectName = this.getDefinitionSchemaObjectName();
        sb.append("CREATE TABLE ").append(objectName).append(" (");
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        String tableComment = this.getTableComment();
        if (StringUtils.isNotBlank((CharSequence)tableComment)) {
            tableComment = String.format("COMMENT ON TABLE %s IS '%s'", objectName, tableComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, objectName, this.terminate(tableComment)));
        }
        Collection<Db2ZosColumn> columns = this.getColumnMapping().values();
        Iterator<Db2ZosColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            String colComment;
            Db2ZosColumn col = iter.next();
            sb.append("\n\t").append((CharSequence)col.buildGrammar());
            if (iter.hasNext()) {
                sb.append(",");
            }
            if (!StringUtils.isNotBlank((CharSequence)(colComment = col.getColumnComment()))) continue;
            String wrappedName = col.getWrappedName();
            colComment = String.format("COMMENT ON COLUMN %s.%s IS '%s'", objectName, wrappedName, colComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, wrappedName, this.terminate(colComment)));
        }
        Db2ZosPrimaryKey primaryKey = this.getPrimaryKey();
        if (primaryKey != null) {
            sb.append(",").append("\n\t").append((CharSequence)primaryKey.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (Db2ZosUniqueKey uniqueKey : this.getUniqueMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)uniqueKey.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (Db2ZosForeignKey foreignKey : this.getForeignMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)foreignKey.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (Db2ZosCheck check : this.getCheckMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)check.buildGrammar());
            }
        }
        sb.append("\n").append(")").append((CharSequence)this.appendTableOptions());
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            for (Db2ZosIndex index : this.getIndexMapping().values()) {
                index.setTablePartitioned(this.getTablePartition() != null);
                subDefines.addAll(index.buildDefinition());
            }
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines)});
    }

    private StringBuilder appendTableOptions() throws UnsupportedGrammarException {
        String encodingSchema;
        String dataCapture;
        String auditing;
        String valProc;
        String edProc;
        StringBuilder sb = new StringBuilder();
        String wrapSchemaName = this.wrap(this.getSchemaName());
        String tbsName = this.getTsName();
        if (StringUtils.isNotBlank((CharSequence)tbsName)) {
            sb.append(" IN ").append(wrapSchemaName).append(".").append(this.wrap(tbsName));
        }
        sb.append(" IN DATABASE ").append(wrapSchemaName);
        Db2ZosTablePartition partition = this.getTablePartition();
        if (partition != null) {
            sb.append((CharSequence)partition.buildGrammar());
        }
        if (StringUtils.isNotBlank((CharSequence)(edProc = this.getEdProc()))) {
            sb.append(" EDITPROC ").append(edProc);
            if ("FFFFFF00".equals(this.getCheckRid())) {
                sb.append(" WITHOUT ROW ATTRIBUTES");
            } else {
                sb.append(" WITH ROW ATTRIBUTES");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(valProc = this.getValProc()))) {
            sb.append(" VALIDPROC ").append(valProc);
        }
        if ("A".equals(auditing = this.getAuditing())) {
            sb.append(" AUDIT ALL");
        } else if ("C".equals(auditing)) {
            sb.append(" AUDIT CHANGE");
        } else {
            sb.append(" AUDIT NONE");
        }
        Integer obid = this.getObId();
        if (obid != null && obid > 0) {
            sb.append(" OBID ").append(obid);
        }
        if ("Y".equals(dataCapture = this.getDataCapture())) {
            sb.append(" DATA CAPTURE CHANGES");
        } else {
            sb.append(" DATA CAPTURE NONE");
        }
        if ("Y".equals(this.getClusterType())) {
            sb.append(" WITH RESTRICT ON DROP");
        }
        if (StringUtils.isNotBlank((CharSequence)(encodingSchema = this.getEncodingScheme()))) {
            Db2ZosSchema schema = (Db2ZosSchema)this.getSchema();
            sb.append(" CCSID ").append(schema.getEncodingSchemeMapping().get(encodingSchema));
        }
        if ("Y".equals(this.getSplitRows())) {
            sb.append(" VOLATILE CARDINALITY");
        } else {
            sb.append(" NOT VOLATILE");
        }
        String append = this.getAppend();
        if ("Y".equals(append)) {
            sb.append(" APPEND YES");
        } else {
            sb.append(" APPEND NO");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof Db2ZosTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Map<String, Db2ZosColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, Db2ZosIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, Db2ZosCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public Map<String, Db2ZosUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, Db2ZosForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTsName() {
        return this.tsName;
    }

    public void setTsName(String tsName) {
        this.tsName = tsName;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public Integer getObId() {
        return this.obId;
    }

    public void setObId(Integer obId) {
        this.obId = obId;
    }

    public Integer getColCount() {
        return this.colCount;
    }

    public void setColCount(Integer colCount) {
        this.colCount = colCount;
    }

    public String getEdProc() {
        return this.edProc;
    }

    public void setEdProc(String edProc) {
        this.edProc = edProc;
    }

    public String getValProc() {
        return this.valProc;
    }

    public void setValProc(String valProc) {
        this.valProc = valProc;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    @Deprecated
    public Integer getClusterRid() {
        return this.clusterRid;
    }

    @Deprecated
    public void setClusterRid(Integer clusterRid) {
        this.clusterRid = clusterRid;
    }

    @Deprecated
    public Integer getCard() {
        return this.card;
    }

    @Deprecated
    public void setCard(Integer card) {
        this.card = card;
    }

    public Integer getNpages() {
        return this.npages;
    }

    public void setNpages(Integer npages) {
        this.npages = npages;
    }

    public Integer getPctPages() {
        return this.pctPages;
    }

    public void setPctPages(Integer pctPages) {
        this.pctPages = pctPages;
    }

    public String getIbmreqd() {
        return this.ibmreqd;
    }

    public void setIbmreqd(String ibmreqd) {
        this.ibmreqd = ibmreqd;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Integer getParents() {
        return this.parents;
    }

    public void setParents(Integer parents) {
        this.parents = parents;
    }

    public Integer getChildren() {
        return this.children;
    }

    public void setChildren(Integer children) {
        this.children = children;
    }

    public Integer getKeyColumns() {
        return this.keyColumns;
    }

    public void setKeyColumns(Integer keyColumns) {
        this.keyColumns = keyColumns;
    }

    public Integer getRecLength() {
        return this.recLength;
    }

    public void setRecLength(Integer recLength) {
        this.recLength = recLength;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getKeyObId() {
        return this.keyObId;
    }

    public void setKeyObId(Integer keyObId) {
        this.keyObId = keyObId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCheckFlag() {
        return this.checkFlag;
    }

    public void setCheckFlag(String checkFlag) {
        this.checkFlag = checkFlag;
    }

    public String getCheckRid() {
        return this.checkRid;
    }

    public void setCheckRid(String checkRid) {
        this.checkRid = checkRid;
    }

    public String getAuditing() {
        return this.auditing;
    }

    public void setAuditing(String auditing) {
        this.auditing = auditing;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getTbCreator() {
        return this.tbCreator;
    }

    public void setTbCreator(String tbCreator) {
        this.tbCreator = tbCreator;
    }

    public String getTbName() {
        return this.tbName;
    }

    public void setTbName(String tbName) {
        this.tbName = tbName;
    }

    public Timestamp getCreatedTs() {
        return this.createdTs;
    }

    public void setCreatedTs(Timestamp createdTs) {
        this.createdTs = createdTs;
    }

    public Timestamp getAlteredTs() {
        return this.alteredTs;
    }

    public void setAlteredTs(Timestamp alteredTs) {
        this.alteredTs = alteredTs;
    }

    public String getDataCapture() {
        return this.dataCapture;
    }

    public void setDataCapture(String dataCapture) {
        this.dataCapture = dataCapture;
    }

    public String getRba1() {
        return this.rba1;
    }

    public void setRba1(String rba1) {
        this.rba1 = rba1;
    }

    public String getRba2() {
        return this.rba2;
    }

    public void setRba2(String rba2) {
        this.rba2 = rba2;
    }

    public Integer getPctRowComp() {
        return this.pctRowComp;
    }

    public void setPctRowComp(Integer pctRowComp) {
        this.pctRowComp = pctRowComp;
    }

    public Timestamp getStatsTime() {
        return this.statsTime;
    }

    public void setStatsTime(Timestamp statsTime) {
        this.statsTime = statsTime;
    }

    public Integer getChecks() {
        return this.checks;
    }

    public void setChecks(Integer checks) {
        this.checks = checks;
    }

    public BigDecimal getCardf() {
        return this.cardf;
    }

    public void setCardf(BigDecimal cardf) {
        this.cardf = cardf;
    }

    public String getCheckRid5b() {
        return this.checkRid5b;
    }

    public void setCheckRid5b(String checkRid5b) {
        this.checkRid5b = checkRid5b;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public String getTableStatus() {
        return this.tableStatus;
    }

    public void setTableStatus(String tableStatus) {
        this.tableStatus = tableStatus;
    }

    public BigDecimal getNPagesf() {
        return this.nPagesf;
    }

    public void setNPagesf(BigDecimal nPagesf) {
        this.nPagesf = nPagesf;
    }

    public BigDecimal getSpacef() {
        return this.spacef;
    }

    public void setSpacef(BigDecimal spacef) {
        this.spacef = spacef;
    }

    public Integer getAvgRowLen() {
        return this.avgRowLen;
    }

    public void setAvgRowLen(Integer avgRowLen) {
        this.avgRowLen = avgRowLen;
    }

    public String getRelCreated() {
        return this.relCreated;
    }

    public void setRelCreated(String relCreated) {
        this.relCreated = relCreated;
    }

    public Integer getNumDepMqts() {
        return this.numDepMqts;
    }

    public void setNumDepMqts(Integer numDepMqts) {
        this.numDepMqts = numDepMqts;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getPartKeyColNum() {
        return this.partKeyColNum;
    }

    public void setPartKeyColNum(Integer partKeyColNum) {
        this.partKeyColNum = partKeyColNum;
    }

    public String getSplitRows() {
        return this.splitRows;
    }

    public void setSplitRows(String splitRows) {
        this.splitRows = splitRows;
    }

    public String getSecurityLabel() {
        return this.securityLabel;
    }

    public void setSecurityLabel(String securityLabel) {
        this.securityLabel = securityLabel;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getAppend() {
        return this.append;
    }

    public void setAppend(String append) {
        this.append = append;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        this.control = control;
    }

    public String getVersioningSchema() {
        return this.versioningSchema;
    }

    public void setVersioningSchema(String versioningSchema) {
        this.versioningSchema = versioningSchema;
    }

    public String getVersioningTable() {
        return this.versioningTable;
    }

    public void setVersioningTable(String versioningTable) {
        this.versioningTable = versioningTable;
    }

    public Integer getHashKeyColumns() {
        return this.hashKeyColumns;
    }

    public void setHashKeyColumns(Integer hashKeyColumns) {
        this.hashKeyColumns = hashKeyColumns;
    }

    public Db2ZosPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Db2ZosPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public Db2ZosTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(Db2ZosTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

