/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class Db2ZosTablePartition
extends AbstractDb2TablePartition {
    private String type;
    private Integer dsSize;
    private final Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> partitionColumns = new LinkedHashSet<AbstractDb2TablePartition.Db2TablePartitionColumn>();

    public Db2ZosTablePartition(Db2ZosSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PARTITION BY");
        String partitionType = this.getPartitionType();
        if ("G".equals(partitionType)) {
            return sb.append(" SIZE ").append(this.getDsSize());
        }
        if ("R".equals(partitionType)) {
            sb.append(" RANGE (");
            Iterator<Object> iter = this.getPartitionColumns().iterator();
            while (iter.hasNext()) {
                AbstractDb2TablePartition.Db2TablePartitionColumn col = iter.next();
                sb.append(this.wrap(col.getPartitionExpression()));
                sb.append(" NULLS LAST");
                String partKeyOrdering = col.getPartitionKeyOrdering();
                if ("ASC".equals(partKeyOrdering)) {
                    sb.append(" ASC");
                } else if ("DESC".equals(partKeyOrdering)) {
                    sb.append(" DESC");
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append(")");
            sb.append("\n").append("(");
            iter = this.getPartitionItems().iterator();
            while (iter.hasNext()) {
                AbstractDb2TablePartition.Db2TablePartitionItem item = (AbstractDb2TablePartition.Db2TablePartitionItem)iter.next();
                sb.append("\n\t");
                sb.append("PARTITION ").append(this.wrap(item.getPartitionName()));
                sb.append(" ENDING AT").append((CharSequence)this.enclose(item.getHighValue()));
                BigDecimal hashSpace = item.getHashSpace();
                if (hashSpace != null) {
                    sb.append(" HASH SPACE ").append(hashSpace);
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            return sb.append("\n").append(")");
        }
        return new StringBuilder();
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof Db2ZosTablePartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getDsSize() {
        return this.dsSize;
    }

    public void setDsSize(Integer dsSize) {
        this.dsSize = dsSize;
    }

    public Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> getPartitionColumns() {
        return this.partitionColumns;
    }
}

