/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTablespace;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Tablespace;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class Db2ZosTablespace
extends AbstractDb2Tablespace {
    private static final String XML_LOG_ATTR = "X";
    private final Map<String, String> lockRuleMapping = new HashMap<String, String>(){
        private static final long serialVersionUID = 601560632428386895L;
        {
            this.put("A", "ANY");
            this.put("R", "ROW");
            this.put("L", "LOB");
            this.put("P", "PAGE");
            this.put("T", "TABLE");
            this.put("S", "TABLESPACE");
        }
    };
    private String name;
    private String creator;
    private String dbName;
    private Integer dbId;
    private Integer obId;
    private Integer psId;
    private String bpool;
    private Integer partitions;
    private String lockRule;
    private Integer pgSize;
    private String eraseRule;
    private String status;
    private String implicit;
    private Integer ntables;
    private Integer nactive;
    private String closeRule;
    private Integer space;
    private String ibmreqd;
    private Integer segSize;
    private String createdBy;
    private Timestamp statsTime;
    private Integer lockMax;
    private String type;
    private Timestamp createdTs;
    private Timestamp alteredTs;
    private String encodingScheme;
    private Integer sbcsCcsid;
    private Integer dbcsCcsid;
    private Integer mixedCcsid;
    private Integer maxRows;
    private String log;
    private BigDecimal nactivef;
    private Integer dsSize;
    private Integer oldestVersion;
    private Integer currentVersion;
    private Integer avgRowLen;
    private BigDecimal spacef;
    private String creatorType;
    private String relCreated;
    private Integer instance;
    private String clone;
    private Integer maxPartitions;
    private String memberCluster;
    private String organizationType;
    private BigDecimal hashSpace;
    private BigDecimal hashDataPages;
    private String pageNum;
    private Integer insertAlg;
    private Integer pqty;
    private String storType;
    private String storName;
    private String vcatName;
    private Integer freePage;
    private Integer pctFree;
    private String compress;
    private String gbpCache;
    private String trackMod;
    private Integer secqtyi;
    private Integer pctFreeUpd;
    private Integer pctFreeUpdCalc;
    private Integer compressRatio;
    private final LinkedHashSet<AbstractDb2TablePartition.Db2TablePartitionItem> partitionItems = new LinkedHashSet();

    public Db2ZosTablespace(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String storName;
        Integer segSize;
        String gbpCache;
        Integer pctFree;
        Integer freePage;
        String encodingSchema;
        String objectName = this.getObjectName();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        if ("O".equals(this.getType())) {
            sb.append(" LOB");
        }
        sb.append(" TABLESPACE ").append(objectName);
        if (StringUtils.isNotBlank((CharSequence)this.getDbName())) {
            sb.append(" IN ").append(this.getDbName());
        }
        Integer partitions = this.getPartitions();
        Integer maxPartitions = this.getMaxPartitions();
        if ("G".equals(this.getType()) && maxPartitions != null && maxPartitions > 0) {
            sb.append(" MAXPARTITIONS ").append(maxPartitions);
        }
        if (partitions != null && partitions > 0) {
            sb.append(" NUMPARTS ").append(partitions);
        }
        if ("R".equals(this.getType()) && CollectionUtils.isNotEmpty(this.getPartitionItems())) {
            AbstractDb2TablePartition.Db2TablePartitionItem item;
            Integer partitionNum;
            sb.append(" (");
            Iterator iter = this.getPartitionItems().iterator();
            while (iter.hasNext() && (partitionNum = (item = (AbstractDb2TablePartition.Db2TablePartitionItem)iter.next()).getPartitionNumber()) != null && partitionNum != 0) {
                sb.append("\n\t").append("PARTITION ").append(partitionNum);
                if (!iter.hasNext()) continue;
                sb.append(",").append("\n");
            }
            sb.append(")").append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getMemberCluster())) {
            sb.append(" MEMBER CLUSTER");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBpool())) {
            sb.append(" BUFFERPOOL ").append(this.getBpool());
        }
        if (StringUtils.isNotBlank((CharSequence)(encodingSchema = this.getEncodingScheme()))) {
            Db2ZosSchema schema = (Db2ZosSchema)this.getSchema();
            sb.append(" CCSID ").append(schema.getEncodingSchemeMapping().get(encodingSchema));
        }
        if ("Y".equals(this.getCloseRule())) {
            sb.append(" CLOSE YES");
        } else {
            sb.append(" CLOSE NO");
        }
        if ("Y".equals(this.getCompress())) {
            sb.append(" COMPRESS YES");
        } else {
            sb.append(" COMPRESS NO");
        }
        Integer dsSize = this.getDsSize();
        if (dsSize != null && dsSize > 0) {
            sb.append(" DSSIZE ").append(dsSize);
        }
        if ((freePage = this.getFreePage()) != null && freePage > 0) {
            sb.append(" FREEPAGE ").append(freePage);
        }
        if ((pctFree = this.getPctFree()) != null && pctFree > 0) {
            sb.append(" PCTFREE ").append(pctFree);
        }
        if ("A".equals(gbpCache = this.getGbpCache())) {
            sb.append(" GBPCACHE ALL");
        } else if ("N".equals(gbpCache)) {
            sb.append(" GBPCACHE NONE");
        } else if ("S".equals(gbpCache)) {
            sb.append(" GBPCACHE SYSTEM");
        } else {
            sb.append(" GBPCACHE CHANGED");
        }
        Integer lockMax = this.getLockMax();
        if (lockMax != null && lockMax > 0) {
            sb.append(" LOCKMAX ").append(lockMax);
        }
        if (lockMax != null && lockMax == -1) {
            sb.append(" LOCKMAX SYSTEM");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getLockRule())) {
            sb.append(" LOCKSIZE ").append(this.getLockRuleMapping().get(this.getLockRule()));
        }
        if ("Y".equals(this.getLog())) {
            sb.append(" LOGGED");
        } else if ("N".equals(this.getLog())) {
            sb.append(" NOT LOGGED");
        } else if (XML_LOG_ATTR.equals(this.getLog())) {
            sb.append("");
        }
        Integer maxRows = this.getMaxRows();
        if (maxRows != null && maxRows > 0) {
            sb.append(" MAXROWS ").append(maxRows);
        }
        if ((segSize = this.getSegSize()) != null && segSize > 0) {
            sb.append(" SEGSIZE ").append(segSize);
        }
        if ("N".equals(this.getTrackMod())) {
            sb.append(" TRACKMOD NO");
        } else {
            sb.append(" TRACKMOD YES");
        }
        String vcatName = this.getVcatName();
        if (StringUtils.isNotBlank((CharSequence)vcatName)) {
            sb.append(" USING VCAT ").append(vcatName);
        }
        if (StringUtils.isNotBlank((CharSequence)(storName = this.getStorName()))) {
            String eraseRule;
            Integer secqtyi;
            sb.append(" USING STOGROUP ").append(storName);
            Integer pgty = this.getPqty();
            if (pgty != null && pgty > 0) {
                sb.append(" PRIQTY ").append(pgty);
            }
            if ((secqtyi = this.getSecqtyi()) != null && secqtyi > 0) {
                sb.append(" SECQTY ").append(secqtyi);
            }
            if ("Y".equals(eraseRule = this.getEraseRule())) {
                sb.append(" ERASE YES");
            } else if ("N".equals(eraseRule)) {
                sb.append(" ERASE NO");
            }
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLESPACE, objectName, this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablespace other) {
        if (!(other instanceof Db2ZosTablespace)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Map<String, String> getLockRuleMapping() {
        return this.lockRuleMapping;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public Integer getObId() {
        return this.obId;
    }

    public void setObId(Integer obId) {
        this.obId = obId;
    }

    public Integer getPsId() {
        return this.psId;
    }

    public void setPsId(Integer psId) {
        this.psId = psId;
    }

    public String getBpool() {
        return this.bpool;
    }

    public void setBpool(String bpool) {
        this.bpool = bpool;
    }

    public Integer getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Integer partitions) {
        this.partitions = partitions;
    }

    public String getLockRule() {
        return this.lockRule;
    }

    public void setLockRule(String lockRule) {
        this.lockRule = lockRule;
    }

    public Integer getPgSize() {
        return this.pgSize;
    }

    public void setPgSize(Integer pgSize) {
        this.pgSize = pgSize;
    }

    public String getEraseRule() {
        return this.eraseRule;
    }

    public void setEraseRule(String eraseRule) {
        this.eraseRule = eraseRule;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getImplicit() {
        return this.implicit;
    }

    public void setImplicit(String implicit) {
        this.implicit = implicit;
    }

    public Integer getNtables() {
        return this.ntables;
    }

    public void setNtables(Integer ntables) {
        this.ntables = ntables;
    }

    public Integer getNactive() {
        return this.nactive;
    }

    public void setNactive(Integer nactive) {
        this.nactive = nactive;
    }

    public String getCloseRule() {
        return this.closeRule;
    }

    public void setCloseRule(String closeRule) {
        this.closeRule = closeRule;
    }

    public Integer getSpace() {
        return this.space;
    }

    public void setSpace(Integer space) {
        this.space = space;
    }

    public String getIbmreqd() {
        return this.ibmreqd;
    }

    public void setIbmreqd(String ibmreqd) {
        this.ibmreqd = ibmreqd;
    }

    public Integer getSegSize() {
        return this.segSize;
    }

    public void setSegSize(Integer segSize) {
        this.segSize = segSize;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Timestamp getStatsTime() {
        return this.statsTime;
    }

    public void setStatsTime(Timestamp statsTime) {
        this.statsTime = statsTime;
    }

    public Integer getLockMax() {
        return this.lockMax;
    }

    public void setLockMax(Integer lockMax) {
        this.lockMax = lockMax;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Timestamp getCreatedTs() {
        return this.createdTs;
    }

    public void setCreatedTs(Timestamp createdTs) {
        this.createdTs = createdTs;
    }

    public Timestamp getAlteredTs() {
        return this.alteredTs;
    }

    public void setAlteredTs(Timestamp alteredTs) {
        this.alteredTs = alteredTs;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public Integer getSbcsCcsid() {
        return this.sbcsCcsid;
    }

    public void setSbcsCcsid(Integer sbcsCcsid) {
        this.sbcsCcsid = sbcsCcsid;
    }

    public Integer getDbcsCcsid() {
        return this.dbcsCcsid;
    }

    public void setDbcsCcsid(Integer dbcsCcsid) {
        this.dbcsCcsid = dbcsCcsid;
    }

    public Integer getMixedCcsid() {
        return this.mixedCcsid;
    }

    public void setMixedCcsid(Integer mixedCcsid) {
        this.mixedCcsid = mixedCcsid;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public BigDecimal getNactivef() {
        return this.nactivef;
    }

    public void setNactivef(BigDecimal nactivef) {
        this.nactivef = nactivef;
    }

    public Integer getDsSize() {
        return this.dsSize;
    }

    public void setDsSize(Integer dsSize) {
        this.dsSize = dsSize;
    }

    public Integer getOldestVersion() {
        return this.oldestVersion;
    }

    public void setOldestVersion(Integer oldestVersion) {
        this.oldestVersion = oldestVersion;
    }

    public Integer getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(Integer currentVersion) {
        this.currentVersion = currentVersion;
    }

    public Integer getAvgRowLen() {
        return this.avgRowLen;
    }

    public void setAvgRowLen(Integer avgRowLen) {
        this.avgRowLen = avgRowLen;
    }

    public BigDecimal getSpacef() {
        return this.spacef;
    }

    public void setSpacef(BigDecimal spacef) {
        this.spacef = spacef;
    }

    public String getCreatorType() {
        return this.creatorType;
    }

    public void setCreatorType(String creatorType) {
        this.creatorType = creatorType;
    }

    public String getRelCreated() {
        return this.relCreated;
    }

    public void setRelCreated(String relCreated) {
        this.relCreated = relCreated;
    }

    public Integer getInstance() {
        return this.instance;
    }

    public void setInstance(Integer instance) {
        this.instance = instance;
    }

    public String getClone() {
        return this.clone;
    }

    public void setClone(String clone) {
        this.clone = clone;
    }

    public Integer getMaxPartitions() {
        return this.maxPartitions;
    }

    public void setMaxPartitions(Integer maxPartitions) {
        this.maxPartitions = maxPartitions;
    }

    public String getMemberCluster() {
        return this.memberCluster;
    }

    public void setMemberCluster(String memberCluster) {
        this.memberCluster = memberCluster;
    }

    public String getOrganizationType() {
        return this.organizationType;
    }

    public void setOrganizationType(String organizationType) {
        this.organizationType = organizationType;
    }

    public BigDecimal getHashSpace() {
        return this.hashSpace;
    }

    public void setHashSpace(BigDecimal hashSpace) {
        this.hashSpace = hashSpace;
    }

    public BigDecimal getHashDataPages() {
        return this.hashDataPages;
    }

    public void setHashDataPages(BigDecimal hashDataPages) {
        this.hashDataPages = hashDataPages;
    }

    public String getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(String pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getInsertAlg() {
        return this.insertAlg;
    }

    public void setInsertAlg(Integer insertAlg) {
        this.insertAlg = insertAlg;
    }

    public Integer getPqty() {
        return this.pqty;
    }

    public void setPqty(Integer pqty) {
        this.pqty = pqty;
    }

    public String getStorType() {
        return this.storType;
    }

    public void setStorType(String storType) {
        this.storType = storType;
    }

    public String getStorName() {
        return this.storName;
    }

    public void setStorName(String storName) {
        this.storName = storName;
    }

    public String getVcatName() {
        return this.vcatName;
    }

    public void setVcatName(String vcatName) {
        this.vcatName = vcatName;
    }

    public Integer getFreePage() {
        return this.freePage;
    }

    public void setFreePage(Integer freePage) {
        this.freePage = freePage;
    }

    public Integer getPctFree() {
        return this.pctFree;
    }

    public void setPctFree(Integer pctFree) {
        this.pctFree = pctFree;
    }

    public String getCompress() {
        return this.compress;
    }

    public void setCompress(String compress) {
        this.compress = compress;
    }

    public String getGbpCache() {
        return this.gbpCache;
    }

    public void setGbpCache(String gbpCache) {
        this.gbpCache = gbpCache;
    }

    public String getTrackMod() {
        return this.trackMod;
    }

    public void setTrackMod(String trackMod) {
        this.trackMod = trackMod;
    }

    public Integer getSecqtyi() {
        return this.secqtyi;
    }

    public void setSecqtyi(Integer secqtyi) {
        this.secqtyi = secqtyi;
    }

    public Integer getPctFreeUpd() {
        return this.pctFreeUpd;
    }

    public void setPctFreeUpd(Integer pctFreeUpd) {
        this.pctFreeUpd = pctFreeUpd;
    }

    public Integer getPctFreeUpdCalc() {
        return this.pctFreeUpdCalc;
    }

    public void setPctFreeUpdCalc(Integer pctFreeUpdCalc) {
        this.pctFreeUpdCalc = pctFreeUpdCalc;
    }

    public Integer getCompressRatio() {
        return this.compressRatio;
    }

    public void setCompressRatio(Integer compressRatio) {
        this.compressRatio = compressRatio;
    }

    public LinkedHashSet<AbstractDb2TablePartition.Db2TablePartitionItem> getPartitionItems() {
        return this.partitionItems;
    }
}

