/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.MapField;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTrigger;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Trigger;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTrigger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class Db2ZosTrigger
extends AbstractDb2Trigger {
    private Integer dbId;
    private Integer obId;
    private String owner;
    private String createdBy;
    private String tbName;
    private String tbOwner;
    private String trigTime;
    private String trigEvent;
    private String granularity;
    private Timestamp createDts;
    private String ibmreqd;
    private String remarks;
    @Deprecated
    private String trigName;
    private String ownerType;
    private Integer envId;
    private String relCreated;
    private String secure;
    private Timestamp altereDts;
    private String rowId;
    @MapField(targetClass=ObOracle22xTrigger.class, targetField="text")
    private String statement;

    public Db2ZosTrigger(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStatement());
        String objectName = this.getSchemaObjectName();
        String comment = String.format("COMMENT ON TRIGGER %s IS '%s'", objectName, this.getRemarks());
        CreateObjectDefine commentDefine = new CreateObjectDefine(ObjectType.COMMENT, objectName, comment);
        ArrayList subDefines = Lists.newArrayList((Object[])new ObjectDefine[]{commentDefine});
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), this.terminate(sb), subDefines)});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTrigger other) {
        if (!(other instanceof Db2ZosTrigger)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public Integer getObId() {
        return this.obId;
    }

    public void setObId(Integer obId) {
        this.obId = obId;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getTbName() {
        return this.tbName;
    }

    public void setTbName(String tbName) {
        this.tbName = tbName;
    }

    public String getTbOwner() {
        return this.tbOwner;
    }

    public void setTbOwner(String tbOwner) {
        this.tbOwner = tbOwner;
    }

    public String getTrigTime() {
        return this.trigTime;
    }

    public void setTrigTime(String trigTime) {
        this.trigTime = trigTime;
    }

    public String getTrigEvent() {
        return this.trigEvent;
    }

    public void setTrigEvent(String trigEvent) {
        this.trigEvent = trigEvent;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public Timestamp getCreateDts() {
        return this.createDts;
    }

    public void setCreateDts(Timestamp createDts) {
        this.createDts = createDts;
    }

    public String getIbmreqd() {
        return this.ibmreqd;
    }

    public void setIbmreqd(String ibmreqd) {
        this.ibmreqd = ibmreqd;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Deprecated
    public String getTrigName() {
        return this.trigName;
    }

    @Deprecated
    public void setTrigName(String trigName) {
        this.trigName = trigName;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public Integer getEnvId() {
        return this.envId;
    }

    public void setEnvId(Integer envId) {
        this.envId = envId;
    }

    public String getRelCreated() {
        return this.relCreated;
    }

    public void setRelCreated(String relCreated) {
        this.relCreated = relCreated;
    }

    public String getSecure() {
        return this.secure;
    }

    public void setSecure(String secure) {
        this.secure = secure;
    }

    public Timestamp getAltereDts() {
        return this.altereDts;
    }

    public void setAltereDts(Timestamp altereDts) {
        this.altereDts = altereDts;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }
}

