/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.db2.zos;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractType;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class Db2ZosType
extends AbstractDb2Type {
    private String owner;
    private String name;
    private String createdBy;
    private String sourceSchema;
    private String sourceType;
    private String metaType;
    private Integer dataTypeId;
    private Integer sourceTypeId;
    private Integer length;
    private Integer scale;
    private String subType;
    private Timestamp createdTs;
    private String encodingScheme;
    private String ibmreqd;
    private String remarks;
    private String ownerType;
    private String relCreated;
    private Integer inlineLength;
    private Integer arrayLength;
    private Integer arrayIndexTypeId;
    private Integer arrayIndexTypeLen;
    private String arrayIndexSubType;

    public Db2ZosType(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String objectName = this.getSchemaObjectName();
        sb.append("CREATE TYPE ").append(objectName).append(" AS ");
        sb.append(this.getSourceType());
        Integer length = this.getLength();
        if (length != null && length > 0) {
            sb.append(" (").append(length);
            Integer scale = this.getScale();
            if (scale != null && scale > 0) {
                sb.append(",").append(scale);
            }
            sb.append(")");
        }
        if ("A".equals(this.getMetaType()) || "L".equals(this.getMetaType())) {
            sb.append(" ARRAY [");
            Integer arrayLength = this.getArrayLength();
            if (arrayLength != null && arrayLength > 0) {
                sb.append(arrayLength);
            }
            String subType = this.getSubType();
            String arrayIndexSubType = this.getArrayIndexSubType();
            if (StringUtils.isNotBlank((CharSequence)subType)) {
                sb.append(arrayIndexSubType);
                Integer arrayIndexTypeLen = this.getArrayIndexTypeLen();
                if (arrayIndexTypeLen != null && arrayIndexTypeLen > 0) {
                    sb.append("(").append(arrayIndexTypeLen).append(")");
                }
            }
            sb.append("]");
        }
        Integer inlineLength = this.getInlineLength();
        if ("T".equals(this.getMetaType()) && inlineLength != null && inlineLength > 0) {
            sb.append(" INLINE LENGTH ").append(inlineLength);
        }
        String comment = String.format("COMMENT ON TYPE %s IS '%s'", objectName, this.getRemarks());
        CreateObjectDefine commentDefine = new CreateObjectDefine(ObjectType.COMMENT, objectName, comment);
        ArrayList subDefines = Lists.newArrayList((Object[])new ObjectDefine[]{commentDefine});
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TYPE, this.getSimpleObjectName(), this.terminate(sb), subDefines)});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractType other) {
        if (!(other instanceof Db2ZosType)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getSourceSchema() {
        return this.sourceSchema;
    }

    public void setSourceSchema(String sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getMetaType() {
        return this.metaType;
    }

    public void setMetaType(String metaType) {
        this.metaType = metaType;
    }

    public Integer getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Integer dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    public Integer getSourceTypeId() {
        return this.sourceTypeId;
    }

    public void setSourceTypeId(Integer sourceTypeId) {
        this.sourceTypeId = sourceTypeId;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public Timestamp getCreatedTs() {
        return this.createdTs;
    }

    public void setCreatedTs(Timestamp createdTs) {
        this.createdTs = createdTs;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public String getIbmreqd() {
        return this.ibmreqd;
    }

    public void setIbmreqd(String ibmreqd) {
        this.ibmreqd = ibmreqd;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getRelCreated() {
        return this.relCreated;
    }

    public void setRelCreated(String relCreated) {
        this.relCreated = relCreated;
    }

    public Integer getInlineLength() {
        return this.inlineLength;
    }

    public void setInlineLength(Integer inlineLength) {
        this.inlineLength = inlineLength;
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    public void setArrayLength(Integer arrayLength) {
        this.arrayLength = arrayLength;
    }

    public Integer getArrayIndexTypeId() {
        return this.arrayIndexTypeId;
    }

    public void setArrayIndexTypeId(Integer arrayIndexTypeId) {
        this.arrayIndexTypeId = arrayIndexTypeId;
    }

    public Integer getArrayIndexTypeLen() {
        return this.arrayIndexTypeLen;
    }

    public void setArrayIndexTypeLen(Integer arrayIndexTypeLen) {
        this.arrayIndexTypeLen = arrayIndexTypeLen;
    }

    public String getArrayIndexSubType() {
        return this.arrayIndexSubType;
    }

    public void setArrayIndexSubType(String arrayIndexSubType) {
        this.arrayIndexSubType = arrayIndexSubType;
    }
}

