/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.drds;

import com.google.common.collect.Sets;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsSchema;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AbstractDrdsPartition
extends AbstractTablePartition {
    private static final Set<String> SUPPORTED_DB_PARTITION_METHODS = Sets.newHashSet();
    private static final Set<String> SUPPORTED_TABLE_PARTITION_METHODS;
    private Partition dbPartition;
    private Partition tablePartition;

    public AbstractDrdsPartition(DrdsSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String partitionMethod;
        StringBuilder sb = new StringBuilder();
        if (this.getDbPartition() != null) {
            Partition dbPartition = this.getDbPartition();
            partitionMethod = dbPartition.getPartitionMethod();
            sb.append(" DBPARTITION BY ").append(dbPartition.getPartitionPolicy());
            if (!"RANGE_HASH".equals(partitionMethod) && !"RIGHT_SHIFT".equals(partitionMethod)) {
                sb.append((CharSequence)this.enclose(this.joinPartitionColumns(dbPartition.getPartitionColumns())));
            }
        }
        if (this.getTablePartition() != null) {
            Partition tablePartition = this.getTablePartition();
            partitionMethod = tablePartition.getPartitionMethod();
            sb.append(" TBPARTITION BY ").append(tablePartition.getPartitionPolicy());
            if (!"RANGE_HASH".equals(partitionMethod) && !"RIGHT_SHIFT".equals(partitionMethod)) {
                sb.append((CharSequence)this.enclose(this.joinPartitionColumns(tablePartition.getPartitionColumns())));
            }
            sb.append(" tbpartitions ").append(tablePartition.getPartitionNum());
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof AbstractDrdsPartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public boolean isComposite() {
        return this.dbPartition != null && this.tablePartition != null;
    }

    private String joinPartitionColumns(List<String> list) {
        return list.stream().map(e -> this.wrap((String)e)).collect(Collectors.joining(", "));
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    public Partition getDbPartition() {
        return this.dbPartition;
    }

    public void setDbPartition(Partition dbPartition) {
        this.dbPartition = dbPartition;
    }

    public Partition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(Partition tablePartition) {
        this.tablePartition = tablePartition;
    }

    static {
        SUPPORTED_DB_PARTITION_METHODS.add("HASH");
        SUPPORTED_DB_PARTITION_METHODS.add("YYYYMM");
        SUPPORTED_DB_PARTITION_METHODS.add("YYYYWEEK");
        SUPPORTED_DB_PARTITION_METHODS.add("YYYYDD");
        SUPPORTED_DB_PARTITION_METHODS.add("YYYYMM_OPT");
        SUPPORTED_DB_PARTITION_METHODS.add("YYYYWEEK_OPT");
        SUPPORTED_DB_PARTITION_METHODS.add("YYYYDD_OPT");
        SUPPORTED_DB_PARTITION_METHODS.add("UNI_HASH");
        SUPPORTED_DB_PARTITION_METHODS.add("RIGHT_SHIFT");
        SUPPORTED_DB_PARTITION_METHODS.add("RANGE_HASH");
        SUPPORTED_TABLE_PARTITION_METHODS = Sets.newHashSet();
        SUPPORTED_TABLE_PARTITION_METHODS.add("HASH");
        SUPPORTED_TABLE_PARTITION_METHODS.add("MM");
        SUPPORTED_TABLE_PARTITION_METHODS.add("DD");
        SUPPORTED_TABLE_PARTITION_METHODS.add("WEEK");
        SUPPORTED_TABLE_PARTITION_METHODS.add("MMDD");
        SUPPORTED_TABLE_PARTITION_METHODS.add("YYYYMM");
        SUPPORTED_TABLE_PARTITION_METHODS.add("YYYYWEEK");
        SUPPORTED_TABLE_PARTITION_METHODS.add("YYYYDD");
        SUPPORTED_TABLE_PARTITION_METHODS.add("YYYYMM_OPT");
        SUPPORTED_TABLE_PARTITION_METHODS.add("YYYYWEEK_OPT");
        SUPPORTED_TABLE_PARTITION_METHODS.add("YYYYDD_OPT");
        SUPPORTED_TABLE_PARTITION_METHODS.add("UNI_HASH");
        SUPPORTED_TABLE_PARTITION_METHODS.add("RIGHT_SHIFT");
        SUPPORTED_TABLE_PARTITION_METHODS.add("RANGE_HASH");
    }

    public static class Partition {
        private String partitionPolicy;
        private String partitionMethod;
        private List<String> partitionColumns;
        private int partitionNum;
        private String namePattern;
        private String rulesStr;
        private String partitionExpress;

        public Partition(String partitionMethod, List<String> partitionColumns, int partitionNum) {
            this.partitionMethod = partitionMethod;
            this.partitionColumns = partitionColumns;
            this.partitionNum = partitionNum;
        }

        public String getPartitionPolicy() {
            return this.partitionPolicy;
        }

        public void setPartitionPolicy(String partitionPolicy) {
            this.partitionPolicy = partitionPolicy;
        }

        public String getPartitionMethod() {
            return this.partitionMethod;
        }

        public void setPartitionMethod(String partitionMethod) {
            this.partitionMethod = partitionMethod;
        }

        public List<String> getPartitionColumns() {
            return this.partitionColumns;
        }

        public void setPartitionColumns(List<String> partitionColumns) {
            this.partitionColumns = partitionColumns;
        }

        public int getPartitionNum() {
            return this.partitionNum;
        }

        public void setPartitionNum(int partitionNum) {
            this.partitionNum = partitionNum;
        }

        public String getNamePattern() {
            return this.namePattern;
        }

        public void setNamePattern(String namePattern) {
            this.namePattern = namePattern;
        }

        public String getRulesStr() {
            return this.rulesStr;
        }

        public void setRulesStr(String rulesStr) {
            this.rulesStr = rulesStr;
        }

        public String getPartitionExpress() {
            return this.partitionExpress;
        }

        public void setPartitionExpress(String partitionExpress) {
            this.partitionExpress = partitionExpress;
        }
    }
}

