/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.drds;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsIndexPartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsSchema;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DrdsIndex
extends AbstractMySqlIndex {
    private boolean isGlobal;
    private DrdsIndexPartition indexPartition;
    private final List<KeyColumn> coveringColumns = new ArrayList<KeyColumn>();

    public DrdsIndex(DrdsSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String indexComment;
        String visible;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        if (this.getNonunique() == 0) {
            sb.append(" ").append((Object)ObjectType.UNIQUE);
        }
        if ("GLOBAL".equals(this.getIndexType())) {
            sb.append(" GLOBAL");
        }
        sb.append(" INDEX ").append(this.getWrappedIndexName()).append(" ON ");
        sb.append(this.getDefinitionSchemaObjectName()).append((CharSequence)this.joinIndexColumns());
        List<KeyColumn> coveringColumns = this.getCoveringColumns();
        if (CollectionUtils.isNotEmpty(coveringColumns)) {
            sb.append(" COVERING ").append((CharSequence)this.joinCoveringColumns()).append(" ");
        }
        if (this.getIndexPartition() != null) {
            sb.append((CharSequence)this.getIndexPartition().buildGrammar());
        }
        if (StringUtils.isNotBlank((CharSequence)(visible = this.getVisible())) && "NO".equals(visible)) {
            sb.append(" invisible");
        }
        if (StringUtils.isNotBlank((CharSequence)(indexComment = this.getIndexComment()))) {
            sb.append(" COMMENT \"").append(indexComment).append("\"");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getIndexType(), this.getSimpleIndexName(), this.terminate(sb))});
    }

    public StringBuilder joinCoveringColumns() {
        return this.enclose(this.getCoveringColumns().stream().map(e -> this.wrapAndCase(e.getColumnName(), "columnCase")).collect(Collectors.joining(", ")));
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof DrdsIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String indexComment;
        String visible;
        StringBuilder sb = new StringBuilder();
        if (this.getNonunique() == 0) {
            sb.append(" ").append((Object)ObjectType.UNIQUE);
        }
        if ("GLOBAL".equals(this.getIndexType())) {
            sb.append(" GLOBAL");
        }
        sb.append(" INDEX ").append(this.getWrappedIndexName()).append((CharSequence)this.joinIndexColumns());
        List<KeyColumn> coveringColumns = this.getCoveringColumns();
        if (CollectionUtils.isNotEmpty(coveringColumns)) {
            sb.append(" COVERING ").append((CharSequence)this.joinCoveringColumns()).append(" ");
        }
        if (this.getIndexPartition() != null) {
            sb.append((CharSequence)this.getIndexPartition().buildGrammar());
        }
        if (StringUtils.isNotBlank((CharSequence)(visible = this.getVisible())) && "NO".equals(visible)) {
            sb.append(" invisible");
        }
        if (StringUtils.isNotBlank((CharSequence)(indexComment = this.getIndexComment()))) {
            sb.append(" COMMENT \"").append(indexComment).append("\"");
        }
        return sb;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public DrdsIndexPartition getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(DrdsIndexPartition indexPartition) {
        this.indexPartition = indexPartition;
    }

    public List<KeyColumn> getCoveringColumns() {
        return this.coveringColumns;
    }

    public static class Partition {
        private String partitionMethod;
        private List<String> partitionColumns;
        private int partitionNum;
        private String namePattern;
        private String rulesStr;

        public Partition(String partitionMethod, List<String> partitionColumns, int partitionNum) {
            this.partitionMethod = partitionMethod;
            this.partitionColumns = partitionColumns;
            this.partitionNum = partitionNum;
        }

        public String getPartitionMethod() {
            return this.partitionMethod;
        }

        public void setPartitionMethod(String partitionMethod) {
            this.partitionMethod = partitionMethod;
        }

        public List<String> getPartitionColumns() {
            return this.partitionColumns;
        }

        public void setPartitionColumns(List<String> partitionColumns) {
            this.partitionColumns = partitionColumns;
        }

        public int getPartitionNum() {
            return this.partitionNum;
        }

        public void setPartitionNum(int partitionNum) {
            this.partitionNum = partitionNum;
        }

        public String getNamePattern() {
            return this.namePattern;
        }

        public void setNamePattern(String namePattern) {
            this.namePattern = namePattern;
        }

        public String getRulesStr() {
            return this.rulesStr;
        }

        public void setRulesStr(String rulesStr) {
            this.rulesStr = rulesStr;
        }
    }
}

