/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.drds;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.AntlrGrammarException;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsColumn;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsIndex;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsSchema;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsTablePartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsUniqueKey;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTable;
import com.oceanbase.obtools.dbdiff.resolver.drds.DRDSTableMetaResolver;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DrdsTable
extends AbstractMySqlTable {
    private final Map<String, DrdsColumn> columnMapping = new LinkedHashMap<String, DrdsColumn>();
    private final Map<String, DrdsIndex> indexMapping = new LinkedHashMap<String, DrdsIndex>();
    private final Map<String, DrdsUniqueKey> uniqueMapping = new LinkedHashMap<String, DrdsUniqueKey>();
    private DrdsPrimaryKey primaryKey;
    private DrdsTablePartition tablePartition;

    public DrdsTable(DrdsSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("create table if not exists ").append(this.getDefinitionSchemaObjectName()).append(" (");
        Collection<DrdsColumn> columns = this.getColumnMapping().values();
        Iterator<DrdsColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            String characterSetName;
            DrdsColumn column = iter.next();
            String string = this.getTableCollation();
            if (string != null && string.equals(column.getCollationName())) {
                column.setCollationName(null);
            }
            if ((characterSetName = this.getCharacterSetName()) != null && characterSetName.equals(column.getCharacterSetName())) {
                column.setCharacterSetName(null);
            }
            sb.append("\n\t").append((CharSequence)column.buildGrammar());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        DrdsPrimaryKey primaryKey = this.getPrimaryKey();
        if (primaryKey != null) {
            sb.append(",\n\t").append((CharSequence)primaryKey.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (DrdsUniqueKey drdsUniqueKey : this.getUniqueMapping().values()) {
                sb.append(",\n\t").append((CharSequence)drdsUniqueKey.buildGrammar());
            }
        }
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            for (DrdsIndex index : this.getIndexMapping().values()) {
                sb.append(",\n\t").append((CharSequence)index.buildGrammar());
            }
        }
        sb.append("\n").append(")");
        sb.append((CharSequence)this.appendTableOptions());
        DrdsTablePartition drdsTablePartition = this.getTablePartition();
        if (drdsTablePartition != null) {
            sb.append((CharSequence)drdsTablePartition.buildGrammar());
        }
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines);
        objectDefine.getChangeInfos().addAll(ChangeUtils.findByKey(ObjectType.TABLE, this.getSimpleObjectName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof DrdsTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    @Override
    public void loadMetaFromDDL(String sql) throws AntlrGrammarException {
        DRDSTableMetaResolver resolver = new DRDSTableMetaResolver(this);
        resolver.resolveMetaData(sql);
    }

    public Map<String, DrdsColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, DrdsIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, DrdsUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public DrdsPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(DrdsPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public DrdsTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(DrdsTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

