/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.drds;

import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.drds.AbstractDrdsPartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsColumn;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsSchema;
import java.util.List;
import java.util.Map;

public class DrdsTablePartition
extends AbstractDrdsPartition {
    private Map<String, DrdsColumn> columnMapping;
    private Integer isBroadcast;

    public DrdsTablePartition(DrdsSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (this.getIsBroadcast() == 1) {
            sb.append(" BROADCAST");
        }
        sb.append((CharSequence)super.buildGrammar());
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof DrdsTablePartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Map<String, DrdsColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public void setColumnMapping(Map<String, DrdsColumn> columnMapping) {
        this.columnMapping = columnMapping;
    }

    public Integer getIsBroadcast() {
        return this.isBroadcast;
    }

    public void setIsBroadcast(Integer isBroadcast) {
        this.isBroadcast = isBroadcast;
    }
}

