/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.drds;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractView;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsSchema;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlView;
import java.util.List;

public class DrdsView
extends AbstractMySqlView {
    public DrdsView(DrdsSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String securityType;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE");
        String definer = this.getDefiner();
        if (StringUtils.isNotBlank((CharSequence)definer)) {
            sb.append(" DEFINER = ").append(definer);
        }
        if (StringUtils.isNotBlank((CharSequence)(securityType = this.getSecurityType()))) {
            sb.append(" SQL SECURITY ").append(securityType);
        }
        sb.append(" VIEW ").append(this.getDefinitionSchemaObjectName());
        sb.append(" AS ").append(this.getText());
        String checkOption = this.getCheckOption();
        if (StringUtils.isNotBlank((CharSequence)checkOption) && !"NONE".equals(checkOption)) {
            sb.append(" WITH ").append(checkOption).append(" CHECK OPTION");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractView other) {
        if (!(other instanceof DrdsView)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

