/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.lindorm.hbase;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LindormHbaseTable
extends AbstractTable {
    private final List<ColumnFamily> columnFamilies = new ArrayList<ColumnFamily>();

    public LindormHbaseTable(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        return null;
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("create ");
        sb.append(this.wrap(this.getObjectName()));
        if (CollectionUtils.isNotEmpty(this.columnFamilies)) {
            sb.append(",");
            String columnFamilyDefine = this.columnFamilies.stream().map(cf -> this.wrap(cf.getColumnFamilyName())).collect(Collectors.joining(","));
            sb.append(columnFamilyDefine);
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), sb.toString())});
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("drop ");
        sb.append(this.wrap(this.getObjectName()));
        return new DropObjectDefine(ObjectType.TABLE, this.getObjectName(), sb.toString());
    }

    @Override
    public String getQuotaCharacter() {
        return "'";
    }

    public List<ColumnFamily> getColumnFamilies() {
        return this.columnFamilies;
    }

    public static class ColumnFamily {
        private final String columnFamilyName;
        private Integer ttl;
        private Integer maxVersion;
        private Integer minVersion;

        public ColumnFamily(String columnFamilyName) {
            this.columnFamilyName = columnFamilyName;
        }

        public String getColumnFamilyName() {
            return this.columnFamilyName;
        }

        public void setTtl(Integer ttl) {
            this.ttl = ttl;
        }

        public Integer getTtl() {
            return this.ttl;
        }

        public void setMaxVersion(Integer maxVersion) {
            this.maxVersion = maxVersion;
        }

        public Integer getMaxVersion() {
            return this.maxVersion;
        }

        public Integer getMinVersion() {
            return this.minVersion;
        }

        public void setMinVersion(Integer minVersion) {
            this.minVersion = minVersion;
        }
    }
}

