/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql;

import com.google.common.collect.Sets;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public abstract class AbstractMySqlColumn
extends AbstractColumn {
    protected static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    protected static final String ON_UPDATE_CURRENT_TIMESTAMP = "on update current_timestamp";
    private static final String IDENTITY_DEFAULT_SUFFIX = ".nextval";
    private static final Set<String> CHARACTER_DATA_TYPES = Sets.newHashSet((Object[])new String[]{"char", "varchar", "tinytext", "text", "mediumtext", "longtext", "enum", "set", "CHAR", "VARCHAR", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "ENUM", "SET"});
    private boolean defaultUdt = false;
    private Long characterMaximumLength;
    private Long characterOctetLength;
    private Integer numericPrecision;
    private Integer numericScale;
    private Integer dateTimePrecision;
    private String characterSetName;
    private String collationName;
    private String columnType;
    private String columnKey;
    private String extra;
    private String privileges;
    private Integer srid;
    private String generationExpression;
    private BigDecimal autoIncrement;
    private final List<String> typeValues = new ArrayList<String>();
    private boolean signed;
    private boolean unsigned;
    private boolean zerofill;
    private boolean binary;
    private boolean ascii;
    private boolean unicode;
    private boolean isByte;

    public AbstractMySqlColumn(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    @Override
    public String escapeColumnDefault(String colDefault) {
        return colDefault.replace("'", "''");
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String columnComment;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGrammarColumnName()).append(" ");
        String columnType = this.getColumnType();
        String dataType = this.getDataType().toUpperCase(Locale.getDefault());
        if (columnType == null) {
            Integer datetimePrecision;
            sb.append(this.getDataType());
            Integer numericScale = this.getNumericScale();
            Integer numericPrecision = this.getNumericPrecision();
            if ("DECIMAL".equals(dataType)) {
                sb.append("(").append(numericPrecision);
                if (numericScale != null && numericScale > 0) {
                    sb.append(",").append(numericScale);
                }
                sb.append(")");
            } else if ("FLOAT".equals(dataType) || "DOUBLE".equals(dataType)) {
                if (numericScale != null && numericScale > 0) {
                    sb.append("(" + numericPrecision + "," + numericScale + ")");
                }
            } else if (("TIME".equals(dataType) || "DATETIME".equals(dataType) || "TIMESTAMP".equals(dataType)) && (datetimePrecision = this.getDateTimePrecision()) != null && datetimePrecision > 0) {
                sb.append("(" + datetimePrecision + ")");
            }
        } else {
            sb.append(columnType);
        }
        if (CHARACTER_DATA_TYPES.contains(this.getDataType())) {
            String collationName;
            String characterSet = this.getCharacterSetName();
            if (StringUtils.isNotBlank((CharSequence)characterSet)) {
                sb.append(" character set ").append(characterSet);
            }
            if ((collationName = this.getCollationName()) != null && !collationName.equalsIgnoreCase(characterSet)) {
                sb.append(" collate ").append(collationName);
            }
        }
        String extra = this.getExtra();
        String expr = this.getGenerationExpression();
        if (StringUtils.isNotBlank((CharSequence)expr)) {
            sb.append(" GENERATED ALWAYS AS ");
            sb.append("(").append(expr).append(")");
            if ("STORED GENERATED".equals(extra)) {
                sb.append(" STORED");
            } else if ("VIRTUAL GENERATED".equals(extra)) {
                sb.append(" VIRTUAL");
            }
        }
        if ("NO".equals(this.getNullable())) {
            sb.append(" not null");
        } else if ("TIMESTAMP".equals(dataType)) {
            sb.append(" null");
        }
        Integer srid = this.getSrid();
        if (srid != null && srid > 0) {
            sb.append(" SRID ").append(srid);
        }
        sb.append((CharSequence)this.buildDefaultValue());
        if (StringUtils.isNotBlank((CharSequence)extra) && StringUtils.isBlank((CharSequence)expr) && StringUtils.isNotBlank((CharSequence)(extra = extra.replace("DEFAULT_GENERATED", "").trim()))) {
            Integer precision;
            if (ON_UPDATE_CURRENT_TIMESTAMP.equals(extra) && (precision = this.getDateTimePrecision()) != null && precision > 0) {
                extra = extra + "(" + precision + ")";
            }
            sb.append(" ").append(extra);
        }
        if (StringUtils.isNotBlank((CharSequence)(columnComment = this.getColumnComment()))) {
            sb.append(" comment '").append(columnComment.replace("'", "''").replace("\\", "\\\\")).append("'");
        }
        return sb;
    }

    protected StringBuilder buildDefaultValue() {
        String originDbType = this.getOriginDbType().getType();
        if (DbType.MARIADB_101.getType().equals(originDbType) || DbType.ADB_MYSQL_20.getType().equals(originDbType)) {
            return this.buildDefaultValueForMariaDb();
        }
        if (DbType.TIDB_4.getType().equals(originDbType) && ("TIMESTAMP".equalsIgnoreCase(this.getDataType()) || "DATETIME".equalsIgnoreCase(this.getDataType())) && StringUtils.isNotEmpty((CharSequence)this.getExtra()) && this.getExtra().toUpperCase(Locale.getDefault()).contains("DEFAULT_GENERATED")) {
            this.setExtra(this.getExtra().replace("DEFAULT_GENERATED", "").trim());
        }
        StringBuilder sb = new StringBuilder();
        String columnDefault = this.getColumnDefault();
        if (StringUtils.isBlank((CharSequence)this.getGenerationExpression()) && columnDefault != null) {
            sb.append(" default ");
            if (this.isBuiltinFunction(columnDefault)) {
                Integer precision;
                if (CURRENT_TIMESTAMP.equals(columnDefault) && (precision = this.getDateTimePrecision()) != null && precision > 0) {
                    columnDefault = columnDefault + "(" + precision + ")";
                }
                sb.append(columnDefault);
            } else if (this.isColumnDefaultGenerated()) {
                sb.append("(").append(columnDefault.replace("'", "''")).append(")");
            } else if ("BIT".equalsIgnoreCase(this.getDataType())) {
                sb.append(columnDefault);
            } else {
                if (("BINARY".equalsIgnoreCase(this.getDataType()) || "VARBINARY".equalsIgnoreCase(this.getDataType())) && DbType.MYSQL_80.getType().equals(originDbType) && DbType.MYSQL_80.isPriorFrom(this.getOriginDbType()) && columnDefault.startsWith("0x")) {
                    try {
                        byte[] bytes = Hex.decodeHex((String)columnDefault.substring(2));
                        columnDefault = new String(bytes);
                    }
                    catch (DecoderException decoderException) {
                        // empty catch block
                    }
                }
                if (columnDefault.startsWith("'") && columnDefault.endsWith("'")) {
                    sb.append(columnDefault);
                } else {
                    sb.append("'").append(columnDefault.replace("'", "''")).append("'");
                }
            }
        }
        if (columnDefault != null && columnDefault.contains("--")) {
            sb.append("\n");
        }
        return sb;
    }

    private StringBuilder buildDefaultValueForMariaDb() {
        StringBuilder sb = new StringBuilder();
        String columnDefault = this.getColumnDefault();
        if (StringUtils.isBlank((CharSequence)this.getGenerationExpression()) && StringUtils.isNotBlank((CharSequence)columnDefault)) {
            sb.append(" default ").append(columnDefault);
        }
        return sb;
    }

    protected boolean isBuiltinFunction(String columnDefault) {
        return this.isDefaultUdt() || columnDefault == null || !JdbcType.isStringType(this.getDataType()) && columnDefault.trim().toUpperCase(Locale.getDefault()).startsWith(CURRENT_TIMESTAMP);
    }

    protected boolean isColumnDefaultGenerated() {
        String extra = this.getExtra();
        return StringUtils.isNotBlank((CharSequence)this.getGenerationExpression()) || StringUtils.isNotBlank((CharSequence)extra) && extra.toUpperCase(Locale.getDefault()).contains("DEFAULT_GENERATED");
    }

    protected boolean checkCharsetAndCollation() {
        String characterSetName = this.getCharacterSetName();
        String[] charsetArr = characterSetName.split("_");
        String[] collationArr = this.getCollationName().split("_");
        if (characterSetName.equalsIgnoreCase(collationArr[0])) {
            return true;
        }
        return charsetArr.length == 2 && characterSetName.equalsIgnoreCase(collationArr[0] + "_" + collationArr[1]);
    }

    public boolean isDefaultUdt() {
        return this.defaultUdt;
    }

    public void setDefaultUdt(boolean defaultUdt) {
        this.defaultUdt = defaultUdt;
    }

    public Long getCharacterMaximumLength() {
        return this.characterMaximumLength;
    }

    public void setCharacterMaximumLength(Long characterMaximumLength) {
        this.characterMaximumLength = characterMaximumLength;
    }

    public Long getCharacterOctetLength() {
        return this.characterOctetLength;
    }

    public void setCharacterOctetLength(Long characterOctetLength) {
        this.characterOctetLength = characterOctetLength;
    }

    public Integer getNumericPrecision() {
        return this.numericPrecision;
    }

    public void setNumericPrecision(Integer numericPrecision) {
        this.numericPrecision = numericPrecision;
    }

    public Integer getNumericScale() {
        return this.numericScale;
    }

    public void setNumericScale(Integer numericScale) {
        this.numericScale = numericScale;
    }

    public Integer getDateTimePrecision() {
        return this.dateTimePrecision;
    }

    public void setDateTimePrecision(Integer dateTimePrecision) {
        this.dateTimePrecision = dateTimePrecision;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public String getColumnKey() {
        return this.columnKey;
    }

    public void setColumnKey(String columnKey) {
        this.columnKey = columnKey;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(String privileges) {
        this.privileges = privileges;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public String getGenerationExpression() {
        return this.generationExpression;
    }

    public void setGenerationExpression(String generationExpression) {
        this.generationExpression = generationExpression;
    }

    public BigDecimal getAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(BigDecimal autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public List<String> getTypeValues() {
        return this.typeValues;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(boolean unsigned) {
        this.unsigned = unsigned;
    }

    public boolean isZerofill() {
        return this.zerofill;
    }

    public void setZerofill(boolean zerofill) {
        this.zerofill = zerofill;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean isAscii() {
        return this.ascii;
    }

    public void setAscii(boolean ascii) {
        this.ascii = ascii;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean unicode) {
        this.unicode = unicode;
    }

    public boolean isByte() {
        return this.isByte;
    }

    public void setByte(boolean isByte) {
        this.isByte = isByte;
    }
}

