/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import java.util.stream.Collectors;

public abstract class AbstractMySqlIndex
extends AbstractIndex {
    private int nonunique;
    private String collation;
    private long cardinality;
    private String subPart;
    private String packed;
    private String nullable;
    private String indexComment;
    private String visible;

    public AbstractMySqlIndex(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("drop index ").append(this.getWrappedIndexName()).append(" on ").append(this.getSchemaObjectName());
        return new DropObjectDefine(ObjectType.INDEX, this.getSimpleObjectName(), this.terminate(sb));
    }

    @Override
    public StringBuilder joinIndexColumns() {
        String indexType = this.getIndexType();
        return this.enclose(this.getIndexColumns().stream().map(e -> {
            String columnOrder;
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            String subPart = e.getSubPart();
            if (!"SPATIAL".equals(indexType) && StringUtils.isNotBlank((CharSequence)subPart)) {
                columnName = columnName + "(" + subPart + ")";
            }
            if (!"HASH".equals(indexType) && !"FULLTEXT".equals(indexType) && !"SPATIAL".equals(indexType) && StringUtils.isNotBlank((CharSequence)(columnOrder = this.getCollationMapping().get(e.getColumnOrder())))) {
                columnName = columnName + columnOrder;
            }
            return columnName;
        }).collect(Collectors.joining(", ")));
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    public int getNonunique() {
        return this.nonunique;
    }

    public void setNonunique(int nonunique) {
        this.nonunique = nonunique;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(long cardinality) {
        this.cardinality = cardinality;
    }

    public String getSubPart() {
        return this.subPart;
    }

    public void setSubPart(String subPart) {
        this.subPart = subPart;
    }

    public String getPacked() {
        return this.packed;
    }

    public void setPacked(String packed) {
        this.packed = packed;
    }

    public String getNullable() {
        return this.nullable;
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    public String getIndexComment() {
        return this.indexComment;
    }

    public void setIndexComment(String indexComment) {
        this.indexComment = indexComment;
    }

    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }
}

