/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.mysql;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractProcedure;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlRoutine;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractMySqlProcedure
extends AbstractProcedure {
    private final AbstractMySqlRoutine routine;

    public AbstractMySqlProcedure(AbstractSchema schema, AbstractMySqlRoutine routine) {
        super(schema);
        this.routine = routine;
        this.setObjectName(routine.getRoutineName());
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(256);
        this.setObjectName(this.routine.getRoutineName());
        sb.append("CREATE PROCEDURE ").append(this.getSchemaObjectName());
        sb.append(" (").append(this.buildParamList()).append(") ");
        sb.append("\n").append(this.routine.getRoutineDefinition());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.PROCEDURE, this.getSimpleObjectName(), sb.toString())});
    }

    public String buildParamList() {
        return this.getRoutine().getParameters().stream().map(e -> e.getParameterMode() + " " + this.wrap(e.getParameterName()) + " " + e.getDtdIdentifier()).collect(Collectors.joining(", "));
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    public AbstractMySqlRoutine getRoutine() {
        return this.routine;
    }
}

